/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.AbstractDBOutlier;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Distance based outlier score")
@Description(value="Generalization of the original DB-Outlier approach to a ranking method, by turning the fraction parameter into the output value.")
@Reference(prefix="Generalization of a method proposed in", authors="E.M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Procs Int. Conf. on Very Large Databases (VLDB'98), New York, USA, 1998")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.DBOutlierScore"})
public class DBOutlierScore<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierScore.class);

    public DBOutlierScore(DistanceFunction<? super O> distanceFunction, double d) {
        super(distanceFunction, d);
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Database database, Relation<O> relation, double d) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        double d2 = distanceQuery.getRelation().size();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(distanceQuery.getRelation().getDBIDs(), 4);
        DBIDIter dBIDIter = distanceQuery.getRelation().iterDBIDs();
        while (dBIDIter.valid()) {
            double d3 = (double)rangeQuery.getRangeForDBID(dBIDIter, d).size() / d2;
            writableDoubleDataStore.putDouble(dBIDIter, 1.0 - d3);
            dBIDIter.advance();
        }
        return writableDoubleDataStore;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDBOutlier.Parameterizer<O> {
        @Override
        protected DBOutlierScore<O> makeInstance() {
            return new DBOutlierScore(this.distanceFunction, this.d);
        }
    }
}

