/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.PolynomialKernelFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="H.-P. Kriegel, M. Schubert, A. Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining (KDD '08), Las Vegas, NV, 2008", url="http://dx.doi.org/10.1145/1401890.1401946")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ABOD", "abod"})
public class ABOD<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ABOD.class);
    protected SimilarityFunction<? super V> kernelFunction;

    public ABOD(SimilarityFunction<? super V> similarityFunction) {
        this.kernelFunction = similarityFunction;
    }

    public OutlierResult run(Database database, Relation<V> relation) {
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        SimilarityQuery<? super V> similarityQuery = database.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(similarityQuery, relation, (DBIDs)arrayDBIDs);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        MeanVariance meanVariance = new MeanVariance();
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter3 = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            double d = this.computeABOF(kernelMatrix, dBIDArrayIter, dBIDArrayIter2, dBIDArrayIter3, meanVariance);
            doubleMinMax.put(d);
            writableDoubleDataStore.putDouble(dBIDArrayIter, d);
            dBIDArrayIter.advance();
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Angle-Based Outlier Degree", "abod-outlier", writableDoubleDataStore, relation.getDBIDs());
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(invertedOutlierScoreMeta, materializedDoubleRelation);
    }

    protected double computeABOF(KernelMatrix kernelMatrix, DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, MeanVariance meanVariance) {
        meanVariance.reset();
        double d = kernelMatrix.getSimilarity(dBIDRef, dBIDRef);
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            double d2;
            double d3;
            double d4;
            if (!DBIDUtil.equal(dBIDArrayIter, dBIDRef) && (d4 = d + (d3 = kernelMatrix.getSimilarity(dBIDArrayIter, dBIDArrayIter)) - (d2 = kernelMatrix.getSimilarity(dBIDRef, dBIDArrayIter)) - d2) > 0.0) {
                dBIDArrayIter2.seek(dBIDArrayIter.getOffset() + 1);
                while (dBIDArrayIter2.valid()) {
                    double d5;
                    double d6;
                    double d7;
                    if (!DBIDUtil.equal(dBIDArrayIter2, dBIDRef) && (d7 = d + (d6 = kernelMatrix.getSimilarity(dBIDArrayIter2, dBIDArrayIter2)) - (d5 = kernelMatrix.getSimilarity(dBIDRef, dBIDArrayIter2)) - d5) > 0.0) {
                        double d8 = kernelMatrix.getSimilarity(dBIDArrayIter, dBIDArrayIter2);
                        double d9 = d8 - d2 - d5 + d;
                        double d10 = 1.0 / (d4 * d7);
                        meanVariance.put(d9 * d10, Math.sqrt(d10));
                    }
                    dBIDArrayIter2.advance();
                }
            }
            dBIDArrayIter.advance();
        }
        return meanVariance.getNaiveVariance();
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID KERNEL_FUNCTION_ID = new OptionID("abod.kernelfunction", "Kernel function to use.");
        protected SimilarityFunction<V> kernelFunction = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(KERNEL_FUNCTION_ID, (Class<?>)SimilarityFunction.class, PolynomialKernelFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.kernelFunction = (SimilarityFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ABOD<V> makeInstance() {
            return new ABOD<V>(this.kernelFunction);
        }
    }
}

