/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;

@Title(value="Gaussian Model Outlier Detection")
@Description(value="Fit a multivariate gaussian model onto the data, and use the PDF to compute an outlier score.")
public class GaussianModel<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(GaussianModel.class);
    public static final OptionID INVERT_ID = new OptionID("gaussod.invert", "Invert the value range to [0:1], with 1 being outliers instead of 0.");
    private static final double SINGULARITY_CHEAT = 1.0E-9;
    private boolean invert = false;

    public GaussianModel(boolean bl) {
        this.invert = bl;
    }

    public OutlierResult run(Relation<V> relation) {
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        CovarianceMatrix covarianceMatrix = CovarianceMatrix.make(relation);
        Vector vector = covarianceMatrix.getMeanVector(relation).getColumnVector();
        Matrix matrix = covarianceMatrix.destroyToNaiveMatrix();
        Matrix matrix2 = matrix.cheatToAvoidSingularity(1.0E-9).inverse();
        double d = 1.0 / Math.sqrt(MathUtil.powi(Math.PI * 2, RelationUtil.dimensionality(relation)) * matrix.det());
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            Vector vector2 = ((NumberVector)relation.get((DBIDRef)object)).getColumnVector().minusEquals(vector);
            double d2 = vector2.transposeTimesTimes(matrix2, vector2);
            double d3 = d * Math.exp(-d2 / 2.0);
            doubleMinMax.put(d3);
            writableDoubleDataStore.putDouble((DBIDRef)object, d3);
            object.advance();
        }
        if (this.invert) {
            double d4 = doubleMinMax.getMax() != 0.0 ? doubleMinMax.getMax() : 1.0;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                writableDoubleDataStore.putDouble(dBIDIter, (d4 - writableDoubleDataStore.doubleValue(dBIDIter)) / d4);
                dBIDIter.advance();
            }
            object = new BasicOutlierScoreMeta(0.0, 1.0);
        } else {
            object = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Gaussian Model Outlier Score", "gaussian-model-outlier", writableDoubleDataStore, relation.getDBIDs());
        return new OutlierResult((OutlierScoreMeta)object, materializedDoubleRelation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected boolean invert = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(INVERT_ID);
            if (parameterization.grab(flag)) {
                this.invert = (Boolean)flag.getValue();
            }
        }

        @Override
        protected GaussianModel<V> makeInstance() {
            return new GaussianModel(this.invert);
        }
    }
}

