/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.Arrays;

public class SparseItemset
extends Itemset {
    int[] indices;

    public SparseItemset(int[] nArray) {
        this.indices = nArray;
    }

    public SparseItemset(int[] nArray, int n) {
        this.indices = nArray;
        this.support = n;
    }

    public SparseItemset(OneItemset oneItemset, OneItemset oneItemset2) {
        int[] nArray;
        if (oneItemset.item == oneItemset2.item) {
            throw new AbortException("SparseItemset constructed from identical 1-itemsets.");
        }
        if (oneItemset.item < oneItemset2.item) {
            int[] nArray2 = new int[2];
            nArray2[0] = oneItemset.item;
            nArray = nArray2;
            nArray2[1] = oneItemset2.item;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = oneItemset2.item;
            nArray = nArray3;
            nArray3[1] = oneItemset.item;
        }
        this.indices = nArray;
    }

    @Override
    public int length() {
        return this.indices.length;
    }

    @Override
    public boolean containedIn(BitVector bitVector) {
        for (int n : this.indices) {
            if (bitVector.booleanValue(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long[] getItems() {
        long[] lArray = BitsUtil.zero(this.indices[this.indices.length - 1]);
        for (int n : this.indices) {
            BitsUtil.setI(lArray, n);
        }
        return lArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Itemset) || ((Itemset)object).length() != 1) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.indices, ((SparseItemset)object).indices);
    }

    @Override
    public int compareTo(Itemset itemset) {
        int n = Integer.compare(this.indices.length, itemset.length());
        if (n != 0) {
            return n;
        }
        SparseItemset sparseItemset = (SparseItemset)itemset;
        for (int i = 0; i < this.indices.length; ++i) {
            int n2 = Integer.compare(this.indices[i], sparseItemset.indices[i]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation) {
        for (int i = 0; i < this.indices.length; ++i) {
            String string;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            String string2 = string = vectorFieldTypeInformation != null ? vectorFieldTypeInformation.getLabel(this.indices[i]) : null;
            if (string == null) {
                stringBuilder.append(this.indices[i]);
                continue;
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(": ").append(this.support);
        return stringBuilder;
    }

    public boolean prefixTest(SparseItemset sparseItemset) {
        if (this.indices.length != sparseItemset.indices.length) {
            throw new AbortException("PrefixTest is only valid for itemsets of the same length!");
        }
        for (int i = this.indices.length - 2; i >= 0; --i) {
            if (this.indices[i] == sparseItemset.indices[i]) continue;
            return false;
        }
        return true;
    }
}

