/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansHamerly;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansLloyd;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain.CenterOfMassMetaClustering;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;

@Reference(authors="S. D. Lee, B. Kao, R. Cheng", title="Reducing UK-means to K-means", booktitle="ICDM Data Mining Workshops, 2007", url="http://dx.doi.org/10.1109/ICDMW.2007.40")
public class CKMeans
extends CenterOfMassMetaClustering<Clustering<KMeansModel>> {
    private static final Logging LOG = Logging.getLogger(CKMeans.class);

    public CKMeans(KMeans<?, KMeansModel> kMeans) {
        super(kMeans);
    }

    public CKMeans(NumberVectorDistanceFunction<? super NumberVector> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super NumberVector> kMeansInitialization) {
        super(new KMeansLloyd<NumberVector>(numberVectorDistanceFunction, n, n2, kMeansInitialization));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private KMeans<?, KMeansModel> kmeans;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, (Class<?>)KMeans.class, KMeansHamerly.class);
            if (parameterization.grab(objectParameter)) {
                this.kmeans = (KMeans)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected CKMeans makeInstance() {
            return new CKMeans(this.kmeans);
        }
    }
}

