/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Title(value="Hierarchical clustering by label")
@Description(value="Cluster points by a (pre-assigned!) label. For comparing results with a reference clustering.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.ByLabelHierarchicalClustering"})
public class ByLabelHierarchicalClustering
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ByLabelHierarchicalClustering.class);

    @Override
    public Clustering<Model> run(Database database) {
        try {
            Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(relation);
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public Clustering<Model> run(Relation<?> relation) {
        Object object;
        Object object3;
        HashMap<String, DBIDs> hashMap = new HashMap<String, DBIDs>();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        Clustering<Model> clustering = new Clustering<Model>("By Label Hierarchical Clustering", "bylabel-clustering");
        Object object4 = relation.iterDBIDs();
        while (object4.valid()) {
            object3 = relation.get((DBIDRef)object4);
            if (object3 == null) {
                arrayModifiableDBIDs.add((DBIDRef)object4);
            } else {
                String object22 = object3.toString();
                this.assign(hashMap, object22, (DBIDRef)object4);
            }
            object4.advance();
        }
        object4 = new ArrayList(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            DBIDs dBIDs = (DBIDs)entry.getValue();
            if (dBIDs instanceof DBID) {
                arrayModifiableDBIDs.add((DBID)dBIDs);
                continue;
            }
            object = new Cluster<ClusterModel>((String)entry.getKey(), dBIDs, ClusterModel.CLUSTER);
            ((ArrayList)object4).add(object);
        }
        object3 = ((ArrayList)object4).iterator();
        while (object3.hasNext()) {
            Cluster cluster = (Cluster)object3.next();
            boolean bl = true;
            object = ((ArrayList)object4).iterator();
            while (object.hasNext()) {
                Cluster cluster2 = (Cluster)object.next();
                if (cluster2 == cluster || !cluster2.getName().startsWith(cluster.getName())) continue;
                clustering.addChildCluster(cluster2, cluster);
                if (LOG.isDebuggingFiner()) {
                    LOG.debugFiner(cluster2.getName() + " is a child of " + cluster.getName());
                }
                bl = false;
            }
            if (!bl) continue;
            clustering.addToplevelCluster(cluster);
        }
        if (arrayModifiableDBIDs.size() > 0) {
            object3 = new Cluster<ClusterModel>("Noise", (DBIDs)arrayModifiableDBIDs, ClusterModel.CLUSTER);
            ((Cluster)object3).setNoise(true);
            clustering.addToplevelCluster((Cluster<Model>)object3);
        }
        return clustering;
    }

    private void assign(HashMap<String, DBIDs> hashMap, String string, DBIDRef dBIDRef) {
        if (hashMap.containsKey(string)) {
            DBIDs dBIDs = hashMap.get(string);
            if (dBIDs instanceof DBID) {
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                hashSetModifiableDBIDs.add((DBID)dBIDs);
                hashSetModifiableDBIDs.add(dBIDRef);
                hashMap.put(string, hashSetModifiableDBIDs);
            } else {
                assert (dBIDs instanceof HashSetModifiableDBIDs);
                assert (dBIDs.size() > 1);
                ((ModifiableDBIDs)dBIDs).add(dBIDRef);
            }
        } else {
            hashMap.put(string, DBIDUtil.deref(dBIDRef));
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.GUESSED_LABEL);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

