/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeapEntry;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.fastoptics.RandomProjectedNeighborsAndDensities;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Schneider and M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM international conference on Conference on Information & Knowledge Management (CIKM)", url="http://dx.doi.org/10.1145/2505515.2505590")
public class FastOPTICS<V extends NumberVector>
extends AbstractAlgorithm<ClusterOrder>
implements OPTICSTypeAlgorithm {
    private static final Logging LOG = Logging.getLogger(FastOPTICS.class);
    public static final double UNDEFINED_DISTANCE = (double)-0.1f;
    ClusterOrder order;
    WritableDoubleDataStore reachDist;
    ModifiableDBIDs processed;
    DataStore<? extends DBIDs> neighs;
    DoubleDataStore inverseDensities;
    int minPts;
    RandomProjectedNeighborsAndDensities<V> index;

    public FastOPTICS(int n, RandomProjectedNeighborsAndDensities<V> randomProjectedNeighborsAndDensities) {
        this.minPts = n;
        this.index = randomProjectedNeighborsAndDensities;
    }

    public ClusterOrder run(Database database, Relation<V> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        DistanceQuery<NumberVector> distanceQuery = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        this.reachDist = DataStoreUtil.makeDoubleStorage(dBIDs, 3, -0.1f);
        this.index.computeSetsBounds(relation, this.minPts, dBIDs);
        this.inverseDensities = this.index.computeAverageDistInSet();
        this.neighs = this.index.getNeighs();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("FastOPTICS clustering", dBIDs.size(), LOG) : null;
        this.processed = DBIDUtil.newHashSet(dBIDs.size());
        this.order = new ClusterOrder(dBIDs, "FastOPTICS Cluster Order", "fast-optics");
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (!this.processed.contains(dBIDIter)) {
                this.expandClusterOrder(DBIDUtil.deref(dBIDIter), this.order, distanceQuery, finiteProgress);
            }
            dBIDIter.advance();
        }
        this.index.logStatistics();
        LOG.ensureCompleted(finiteProgress);
        return this.order;
    }

    protected void expandClusterOrder(DBID dBID, ClusterOrder clusterOrder, DistanceQuery<V> distanceQuery, FiniteProgress finiteProgress) {
        UpdatableHeap<OPTICSHeapEntry> updatableHeap = new UpdatableHeap<OPTICSHeapEntry>();
        updatableHeap.add(new OPTICSHeapEntry(dBID, null, 1000000.0));
        while (!updatableHeap.isEmpty()) {
            OPTICSHeapEntry oPTICSHeapEntry = (OPTICSHeapEntry)updatableHeap.poll();
            DBID dBID2 = oPTICSHeapEntry.objectID;
            clusterOrder.add(dBID2, oPTICSHeapEntry.reachability, oPTICSHeapEntry.predecessorID);
            this.processed.add(dBID2);
            double d = this.inverseDensities.doubleValue(dBID2);
            DBIDIter dBIDIter = this.neighs.get(dBID2).iter();
            while (dBIDIter.valid()) {
                if (!this.processed.contains(dBIDIter)) {
                    double d2 = distanceQuery.distance((DBIDRef)dBID2, (DBIDRef)dBIDIter);
                    if (d > d2) {
                        d2 = d;
                    }
                    if (this.reachDist.doubleValue(dBIDIter) == (double)-0.1f) {
                        this.reachDist.put((DBIDRef)dBIDIter, d2);
                    } else if (d2 < this.reachDist.doubleValue(dBIDIter)) {
                        this.reachDist.put((DBIDRef)dBIDIter, d2);
                    }
                    updatableHeap.add(new OPTICSHeapEntry(DBIDUtil.deref(dBIDIter), dBID2, d2));
                }
                dBIDIter.advance();
            }
            LOG.incrementProcessed(finiteProgress);
        }
    }

    @Override
    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(EuclideanDistanceFunction.STATIC.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        int minpts;
        RandomProjectedNeighborsAndDensities<V> index;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(AbstractOPTICS.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minpts = intParameter.intValue();
            }
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(RandomProjectedNeighborsAndDensities.class);
            this.index = (RandomProjectedNeighborsAndDensities)parameterization.tryInstantiate(clazz);
        }

        @Override
        protected FastOPTICS<V> makeInstance() {
            return new FastOPTICS<V>(this.minpts, this.index);
        }
    }
}

