/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Q. Zhao, M. Xu, P. Fra\u0308nti", title="Knee Point Detection on Bayesian Information Criterion", booktitle="20th IEEE International Conference on Tools with Artificial Intelligence", url="http://dx.doi.org/10.1109/ICTAI.2008.154")
public class BayesianInformationCriterionZhao
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, Relation<V> relation) {
        return BayesianInformationCriterionZhao.logLikelihoodAlternate(relation, clustering, numberVectorDistanceFunction) - 0.5 * (double)clustering.getAllClusters().size() * Math.log(BayesianInformationCriterionZhao.numPoints(clustering));
    }

    @Override
    public boolean ascending() {
        return true;
    }

    @Override
    public boolean isBetter(double d, double d2) {
        return !(d <= d2);
    }
}

