/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.List;

@Reference(authors="D. Pelleg, A. Moore", booktitle="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", title="Proceedings of the 17th International Conference on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps")
public abstract class AbstractKMeansQualityMeasure<O extends NumberVector>
implements KMeansQualityMeasure<O> {
    public static int numPoints(Clustering<? extends MeanModel> clustering) {
        int n = 0;
        for (Cluster<? extends MeanModel> cluster : clustering.getAllClusters()) {
            n += cluster.size();
        }
        return n;
    }

    public static <V extends NumberVector> double varianceOfCluster(Cluster<? extends MeanModel> cluster, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, Relation<V> relation) {
        MeanModel meanModel = cluster.getModel();
        if (meanModel instanceof KMeansModel) {
            return ((KMeansModel)meanModel).getVarianceContribution();
        }
        DBIDs dBIDs = cluster.getIDs();
        Vector vector = meanModel.getMean();
        boolean bl = numberVectorDistanceFunction instanceof SquaredEuclideanDistanceFunction;
        double d = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = numberVectorDistanceFunction.distance((NumberVector)relation.get(dBIDIter), vector);
            d += bl ? d2 : d2 * d2;
            dBIDIter.advance();
        }
        return d;
    }

    @Reference(authors="D. Pelleg, A. Moore", booktitle="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", title="Proceedings of the 17th International Conference on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps")
    public static <V extends NumberVector> double logLikelihood(Relation<V> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        List<Cluster<? extends MeanModel>> list = clustering.getAllClusters();
        int n = RelationUtil.dimensionality(relation);
        int n2 = list.size();
        int n3 = 0;
        int[] nArray = new int[n2];
        double d = 0.0;
        double[] dArray = new double[n2];
        Iterator<Cluster<? extends MeanModel>> iterator = list.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Cluster<? extends MeanModel> cluster = iterator.next();
            nArray[n4] = cluster.size();
            n3 += nArray[n4];
            dArray[n4] = AbstractKMeansQualityMeasure.varianceOfCluster(cluster, numberVectorDistanceFunction, relation);
            d += dArray[n4];
            ++n4;
        }
        double d2 = d / (double)(n3 - n2);
        double d3 = Math.log(d2);
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d4 += (double)nArray[i] * Math.log(nArray[i]) - (double)nArray[i] * 0.5 * MathUtil.LOGTWOPI - (double)(nArray[i] * n) * 0.5 * d3 - (dArray[i] - (double)n2) * 0.5;
        }
        return d4 -= (double)n3 * Math.log(n3);
    }

    @Reference(authors="Q. Zhao, M. Xu, P. Fra\u0308nti", title="Knee Point Detection on Bayesian Information Criterion", booktitle="20th IEEE International Conference on Tools with Artificial Intelligence", url="http://dx.doi.org/10.1109/ICTAI.2008.154")
    public static <V extends NumberVector> double logLikelihoodAlternate(Relation<V> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        List<Cluster<? extends MeanModel>> list = clustering.getAllClusters();
        int n = RelationUtil.dimensionality(relation);
        int n2 = list.size();
        int n3 = 0;
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        Iterator<Cluster<? extends MeanModel>> iterator = list.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Cluster<? extends MeanModel> cluster = iterator.next();
            nArray[n4] = cluster.size();
            n3 += nArray[n4];
            dArray[n4] = AbstractKMeansQualityMeasure.varianceOfCluster(cluster, numberVectorDistanceFunction, relation);
            ++n4;
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += (double)nArray[i] * Math.log((double)nArray[i] / (double)n3) - (double)(nArray[i] * n) * 0.5 * MathUtil.LOGTWOPI - (double)nArray[i] * 0.5 * Math.log(dArray[i]) - (double)(nArray[i] - n2) * 0.5;
        }
        return d;
    }

    public static int numberOfFreeParameters(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering) {
        int n = clustering.getAllClusters().size();
        int n2 = RelationUtil.dimensionality(relation);
        return n - 1 + n * n2 + n;
    }
}

