/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.SampleKMeansInitialization"})
public class SampleKMeansInitialization<V extends NumberVector>
extends AbstractKMeansInitialization<V> {
    private KMeans<V, ?> innerkMeans;
    private double rate;

    public SampleKMeansInitialization(RandomFactory randomFactory, KMeans<V, ?> kMeans, double d) {
        super(randomFactory);
        this.innerkMeans = kMeans;
        this.rate = d;
    }

    @Override
    public <T extends V, O extends NumberVector> List<O> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<O> factory) {
        DBIDs dBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.rate, this.rnd);
        Relation<T> relation2 = relation;
        if (!numberVectorDistanceFunction.getInputTypeRestriction().isAssignableFromType(TypeUtil.NUMBER_VECTOR_FIELD)) {
            LoggingUtil.warning("Initializing k-means with k-means using specialized distance functions MAY fail, if the initialization method does require a distance defined on arbitrary number vectors.");
        }
        NumberVectorDistanceFunction<T> numberVectorDistanceFunction2 = numberVectorDistanceFunction;
        ProxyView<T> proxyView = new ProxyView<T>(dBIDs, relation2);
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs, proxyView);
        this.innerkMeans.setK(n);
        this.innerkMeans.setDistanceFunction(numberVectorDistanceFunction2);
        Clustering<?> clustering = this.innerkMeans.run(proxyDatabase, proxyView);
        ArrayList<O> arrayList = new ArrayList<O>();
        for (Cluster<?> cluster : clustering.getAllClusters()) {
            arrayList.add(factory.newNumberVector(ModelUtil.getPrototype(cluster.getModel(), relation)));
        }
        return arrayList;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeansInitialization.Parameterizer {
        public static final OptionID KMEANS_ID = new OptionID("kmeans.algorithm", "KMeans variant to run multiple times.");
        public static final OptionID SAMPLE_ID = new OptionID("kmeans.samplesize", "Sample set size (if > 1) or sampling rante (if < 1).");
        protected KMeans<V, ?> innerkMeans;
        protected double rate;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Object object;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(KMEANS_ID, KMeans.class);
            if (parameterization.grab(objectParameter)) {
                object = new ListParameterization();
                ((ListParameterization)object).addParameter(KMeans.K_ID, 13);
                ((ListParameterization)object).addParameter(KMeans.DISTANCE_FUNCTION_ID, SquaredEuclideanDistanceFunction.class);
                ChainedParameterization chainedParameterization = new ChainedParameterization(new Parameterization[]{object, parameterization});
                chainedParameterization.errorsTo(parameterization);
                this.innerkMeans = (KMeans)objectParameter.instantiateClass(chainedParameterization);
            }
            if (parameterization.grab((Parameter<?>)(object = new DoubleParameter(SAMPLE_ID)))) {
                this.rate = ((DoubleParameter)object).doubleValue();
            }
        }

        @Override
        protected SampleKMeansInitialization<V> makeInstance() {
            return new SampleKMeansInitialization<V>(this.rnd, this.innerkMeans, this.rate);
        }
    }
}

