/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.List;

@Reference(authors="E. W. Forgy", title="Cluster analysis of multivariate data: efficiency versus interpretability of classifications", booktitle="Biometrics 21(3)")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.RandomlyChosenInitialMeans"})
public class RandomlyChosenInitialMeans<O>
extends AbstractKMeansInitialization<NumberVector>
implements KMedoidsInitialization<O> {
    public RandomlyChosenInitialMeans(RandomFactory randomFactory) {
        super(randomFactory);
    }

    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), n, this.rnd);
        ArrayList<V> arrayList = new ArrayList<V>(n);
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            arrayList.add(factory.newNumberVector((NumberVector)relation.get(dBIDIter)));
            dBIDIter.advance();
        }
        return arrayList;
    }

    @Override
    public DBIDs chooseInitialMedoids(int n, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery) {
        return DBIDUtil.randomSample(dBIDs, n, this.rnd);
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected RandomlyChosenInitialMeans<V> makeInstance() {
            return new RandomlyChosenInitialMeans(this.rnd);
        }
    }
}

