/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.BestOfMultipleKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.LinkedList;

@Reference(authors="M. Steinbach, G. Karypis, V. Kumar", title="A Comparison of Document Clustering Techniques", booktitle="KDD workshop on text mining. Vol. 400. No. 1")
public class KMeansBisecting<V extends NumberVector, M extends MeanModel>
extends AbstractAlgorithm<Clustering<M>>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(KMeansBisecting.class);
    private KMeans<V, M> innerkMeans;
    private int k;

    public KMeansBisecting(int n, KMeans<V, M> kMeans) {
        this.k = n;
        this.innerkMeans = kMeans;
    }

    @Override
    public Clustering<M> run(Database database, Relation<V> relation) {
        ProxyDatabase proxyDatabase = new ProxyDatabase(relation.getDBIDs(), database);
        LinkedList linkedList = new LinkedList();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Bisecting k-means", this.k - 1, LOG) : null;
        for (int i = 0; i < this.k - 1; ++i) {
            Object object;
            if (linkedList.size() == 0) {
                proxyDatabase = new ProxyDatabase(relation.getDBIDs(), database);
            } else {
                object = null;
                for (Cluster cluster : linkedList) {
                    if (object != null && cluster.size() <= ((Cluster)object).size()) continue;
                    object = cluster;
                }
                linkedList.remove(object);
                proxyDatabase.setDBIDs(((Cluster)object).getIDs());
            }
            object = this.innerkMeans.run(proxyDatabase);
            linkedList.addAll(((Clustering)object).getAllClusters());
            LOG.incrementProcessed(finiteProgress);
            if (!LOG.isVerbose()) continue;
            LOG.verbose("Iteration " + i);
        }
        LOG.ensureCompleted(finiteProgress);
        Clustering clustering = new Clustering("Bisecting k-Means Result", "Bisecting-k-means");
        for (Cluster cluster : linkedList) {
            clustering.addToplevelCluster(cluster);
        }
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public DistanceFunction<? super V> getDistanceFunction() {
        return this.innerkMeans.getDistanceFunction();
    }

    @Override
    public void setK(int n) {
        this.k = n;
    }

    @Override
    public void setDistanceFunction(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        this.innerkMeans.setDistanceFunction(numberVectorDistanceFunction);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, M extends MeanModel>
    extends AbstractParameterizer {
        public static final OptionID KMEANS_ID = new OptionID("bisecting.kmeansvariant", "KMeans variant");
        protected KMeans<V, M> kMeansVariant;
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(KMeans.K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KMEANS_ID, (Class<?>)KMeans.class, BestOfMultipleKMeans.class))) {
                ListParameterization listParameterization = new ListParameterization();
                listParameterization.addParameter(KMeans.K_ID, 2);
                ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
                chainedParameterization.errorsTo(parameterization);
                this.kMeansVariant = (KMeans)objectParameter.instantiateClass(chainedParameterization);
            }
        }

        @Override
        protected KMeansBisecting<V, M> makeInstance() {
            return new KMeansBisecting<V, M>(this.k, this.kMeansVariant);
        }
    }
}

