/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;
import java.util.Collection;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, and J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining, PAKDD", url="http://dx.doi.org/10.1007/978-3-642-37456-2_14")
public class SimplifiedHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(SimplifiedHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;

    public SimplifiedHierarchyExtraction(HierarchicalClusteringAlgorithm hierarchicalClusteringAlgorithm, int n) {
        this.algorithm = hierarchicalClusteringAlgorithm;
        this.minClSize = n;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult = this.algorithm.run(database);
        DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
        DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
        DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
        DoubleDataStore doubleDataStore2 = null;
        if (pointerHierarchyRepresentationResult instanceof PointerDensityHierarchyRepresentationResult) {
            doubleDataStore2 = ((PointerDensityHierarchyRepresentationResult)pointerHierarchyRepresentationResult).getCoreDistanceStore();
        }
        Clustering<DendrogramModel> clustering = this.extractClusters(dBIDs, dBIDDataStore, doubleDataStore, doubleDataStore2);
        clustering.addChildResult(pointerHierarchyRepresentationResult);
        return clustering;
    }

    public Clustering<DendrogramModel> extractClusters(DBIDs dBIDs, DBIDDataStore dBIDDataStore, DoubleDataStore doubleDataStore, DoubleDataStore doubleDataStore2) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", dBIDs.size(), LOG) : null;
        ArrayDBIDs arrayDBIDs = PointerHierarchyRepresentationResult.topologicalSort(dBIDs, dBIDDataStore, doubleDataStore);
        WritableDataStore<TempCluster> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 1, TempCluster.class);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        ArrayList<Cluster<DendrogramModel>> arrayList = new ArrayList<Cluster<DendrogramModel>>();
        Clustering<DendrogramModel> clustering = new Clustering<DendrogramModel>("Hierarchical Clustering", "hierarchical-clustering");
        DBIDVar dBIDVar = DBIDUtil.newVar();
        Cluster<DendrogramModel> cluster = arrayDBIDs.iter();
        while (cluster.valid()) {
            double d = doubleDataStore.doubleValue((DBIDRef)((Object)cluster));
            boolean bl = doubleDataStore2 == null || d >= doubleDataStore2.doubleValue((DBIDRef)((Object)cluster));
            TempCluster tempCluster = (TempCluster)writableDataStore.get((DBIDRef)((Object)cluster));
            boolean bl2 = tempCluster != null ? tempCluster.isNotSpurious(this.minClSize) : this.minClSize <= 1 && bl;
            dBIDDataStore.assignVar((DBIDRef)((Object)cluster), dBIDVar);
            if (DBIDUtil.equal(cluster, dBIDVar)) {
                if (tempCluster != null) {
                    if (tempCluster.isNotSpurious(this.minClSize)) {
                        arrayList.add(tempCluster.toCluster(clustering, cluster));
                    } else {
                        arrayModifiableDBIDs.addDBIDs(tempCluster.newids);
                    }
                    writableDataStore.put((DBIDRef)((Object)cluster), (TempCluster)null);
                } else if (this.minClSize <= 1 && bl) {
                    arrayList.add(this.makeSingletonCluster((DBIDRef)((Object)cluster), d));
                } else {
                    arrayModifiableDBIDs.add((DBIDRef)((Object)cluster));
                }
                LOG.incrementProcessed(finiteProgress);
            } else {
                boolean bl3;
                boolean bl4;
                TempCluster tempCluster2 = (TempCluster)writableDataStore.get(dBIDVar);
                boolean bl5 = bl4 = doubleDataStore2 == null || d <= doubleDataStore2.doubleValue(dBIDVar);
                boolean bl6 = tempCluster2 != null ? tempCluster2.isNotSpurious(this.minClSize) : (bl3 = this.minClSize <= 1 && bl4);
                if (tempCluster2 != null && tempCluster != null) {
                    if (bl3 && bl2) {
                        tempCluster2.addChild(tempCluster2.toCluster(clustering, cluster));
                        tempCluster2.addChild(tempCluster.toCluster(clustering, cluster));
                        assert (tempCluster2.children.size() == 2);
                        tempCluster2.depth = d;
                    } else if (bl2) {
                        tempCluster.addDBIDs(tempCluster2.newids);
                        assert (tempCluster2.children.size() == 0);
                        tempCluster.depth = d;
                        writableDataStore.put(dBIDVar, tempCluster);
                    } else {
                        tempCluster2.addDBIDs(tempCluster.newids);
                        assert (tempCluster.children.size() == 0);
                        tempCluster2.depth = d;
                    }
                } else if (tempCluster != null) {
                    if (bl2 && bl3) {
                        tempCluster.addChild(tempCluster.toCluster(clustering, cluster));
                    }
                    this.addSingleton(tempCluster, dBIDVar, d, bl3);
                    writableDataStore.put(dBIDVar, tempCluster);
                } else if (tempCluster2 != null) {
                    if (bl2 && bl3) {
                        tempCluster2.addChild(tempCluster2.toCluster(clustering, cluster));
                    }
                    this.addSingleton(tempCluster2, (DBIDRef)((Object)cluster), d, bl2);
                } else {
                    tempCluster2 = new TempCluster(d);
                    this.addSingleton(tempCluster2, (DBIDRef)((Object)cluster), d, bl2);
                    this.addSingleton(tempCluster2, dBIDVar, d, bl3);
                    writableDataStore.put(dBIDVar, tempCluster2);
                }
                writableDataStore.put((DBIDRef)((Object)cluster), (TempCluster)null);
                LOG.incrementProcessed(finiteProgress);
            }
            cluster.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (arrayModifiableDBIDs.size() > 0) {
            cluster = new Cluster<DendrogramModel>("Noise", arrayModifiableDBIDs, true, new DendrogramModel(Double.POSITIVE_INFINITY));
            clustering.addToplevelCluster(cluster);
            for (Cluster cluster2 : arrayList) {
                clustering.addChildCluster(cluster, cluster2);
            }
        } else {
            for (Cluster cluster3 : arrayList) {
                clustering.addToplevelCluster(cluster3);
            }
        }
        return clustering;
    }

    private void addSingleton(TempCluster tempCluster, DBIDRef dBIDRef, double d, boolean bl) {
        if (bl) {
            tempCluster.addChild(this.makeSingletonCluster(dBIDRef, d));
        } else {
            tempCluster.add(dBIDRef);
        }
        tempCluster.depth = d;
    }

    private Cluster<DendrogramModel> makeSingletonCluster(DBIDRef dBIDRef, double d) {
        String string = "obj_" + DBIDUtil.toString(dBIDRef);
        return new Cluster<DendrogramModel>(string, (DBIDs)DBIDUtil.deref(dBIDRef), new DendrogramModel(d));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minClSize = intParameter.intValue();
            }
        }

        @Override
        protected SimplifiedHierarchyExtraction makeInstance() {
            return new SimplifiedHierarchyExtraction(this.algorithm, this.minClSize);
        }
    }

    protected static class TempCluster {
        protected ModifiableDBIDs newids = DBIDUtil.newArray();
        protected double depth = 0.0;
        protected Collection<Cluster<DendrogramModel>> children = new ArrayList<Cluster<DendrogramModel>>();

        public TempCluster(double d) {
            this.depth = d;
        }

        public void add(DBIDRef dBIDRef) {
            this.newids.add(dBIDRef);
        }

        public void addDBIDs(DBIDs dBIDs) {
            this.newids.addDBIDs(dBIDs);
        }

        public void addChild(Cluster<DendrogramModel> cluster) {
            this.children.add(cluster);
        }

        public boolean isNotSpurious(int n) {
            return this.children.size() > 0 || this.newids.size() >= n;
        }

        private Cluster<DendrogramModel> toCluster(Clustering<DendrogramModel> clustering, DBIDRef dBIDRef) {
            String string = this.children.size() > 1 ? "mrg_" + DBIDUtil.toString(dBIDRef) + "_" + this.depth : (this.newids.size() == 1 ? "obj_" + DBIDUtil.toString(dBIDRef) : (!Double.isNaN(this.depth) ? "clu_" + DBIDUtil.toString(dBIDRef) + "_" + this.depth : "clu_" + DBIDUtil.toString(dBIDRef)));
            Cluster<DendrogramModel> cluster = new Cluster<DendrogramModel>(string, (DBIDs)DBIDUtil.newArray(this.newids), new DendrogramModel(this.depth));
            for (Cluster<DendrogramModel> cluster2 : this.children) {
                clustering.addChildCluster(cluster, cluster2);
            }
            this.newids.clear();
            this.children.clear();
            return cluster;
        }
    }
}

