/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AbstractHDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleLongMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="HDBSCAN: Hierarchical Density-Based Spatial Clustering of Applications with Noise")
@Description(value="Density-Based Clustering Based on Hierarchical Density Estimates")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, and J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining, PAKDD", url="http://dx.doi.org/10.1007/978-3-642-37456-2_14")
public class HDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O, PointerDensityHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(HDBSCANLinearMemory.class);

    public HDBSCANLinearMemory(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction, n);
    }

    public PointerDensityHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.minPts);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        WritableDoubleDataStore writableDoubleDataStore = this.computeCoreDists(arrayDBIDs, kNNQuery, this.minPts);
        int n = arrayDBIDs.size() - 1;
        DoubleLongMinHeap doubleLongMinHeap = new DoubleLongMinHeap(n);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing minimum spanning tree (n-1 edges)", n, LOG) : null;
        PrimsMinimumSpanningTree.processDense(arrayDBIDs, new AbstractHDBSCAN.HDBSCANAdapter(arrayDBIDs, writableDoubleDataStore, distanceQuery), new AbstractHDBSCAN.HeapMSTCollector(doubleLongMinHeap, finiteProgress, LOG));
        LOG.ensureCompleted(finiteProgress);
        WritableDBIDDataStore writableDBIDDataStore = DataStoreUtil.makeDBIDStorage(arrayDBIDs, 6);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 6, Double.POSITIVE_INFINITY);
        this.convertToPointerRepresentation(arrayDBIDs, doubleLongMinHeap, writableDBIDDataStore, writableDoubleDataStore2);
        return new PointerDensityHierarchyRepresentationResult(arrayDBIDs, writableDBIDDataStore, writableDoubleDataStore2, writableDoubleDataStore);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractHDBSCAN.Parameterizer<O> {
        @Override
        protected HDBSCANLinearMemory<O> makeInstance() {
            return new HDBSCANLinearMemory(this.distanceFunction, this.minPts);
        }
    }
}

