/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.PreDeCon;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="C. B\u00f6hm, K. Kailing, H.-P. Kriegel, P. Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04), Brighton, UK, 2004", url="http://dx.doi.org/10.1109/ICDM.2004.10087")
public class PreDeConCorePredicate
implements CorePredicate {
    protected PreDeCon.Settings settings;

    public PreDeConCorePredicate(PreDeCon.Settings settings) {
        this.settings = settings;
    }

    @Override
    public <T> CorePredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        return new Instance(this.settings);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<?> simpleTypeInformation) {
        return simpleTypeInformation.getRestrictionClass().isAssignableFrom(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected PreDeCon.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.settings = parameterization.tryInstantiate(PreDeCon.Settings.class);
        }

        @Override
        protected PreDeConCorePredicate makeInstance() {
            return new PreDeConCorePredicate(this.settings);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<PreDeConNeighborPredicate.PreDeConModel> {
        protected PreDeCon.Settings settings;

        public Instance(PreDeCon.Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean isCorePoint(DBIDRef dBIDRef, PreDeConNeighborPredicate.PreDeConModel preDeConModel) {
            return preDeConModel.pdim <= this.settings.lambda && preDeConModel.ids.size() >= this.settings.minpts;
        }
    }
}

