/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.ERiC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, and A. Zimek", title="On Exploring Complex Relationships of Correlation Clusters", booktitle="Proc. 19th International Conference on Scientific and Statistical Database Management (SSDBM 2007), Banff, Canada, 2007", url="http://dx.doi.org/10.1109/SSDBM.2007.21")
public class ERiCNeighborPredicate<V extends NumberVector>
implements NeighborPredicate {
    private static final Logging LOG = Logging.getLogger(ERiCNeighborPredicate.class);
    protected final ERiC.Settings settings;
    private double deltasq;

    public ERiCNeighborPredicate(ERiC.Settings settings) {
        this.settings = settings;
        this.deltasq = settings.delta * settings.delta;
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        Relation relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        return this.instantiate(database, relation);
    }

    public Instance instantiate(Database database, Relation<V> relation) {
        DistanceQuery<NumberVector> distanceQuery = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> kNNQuery = database.getKNNQuery(distanceQuery, this.settings.k);
        WritableDataStore<PCAFilteredResult> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, PCAFilteredResult.class);
        Duration duration = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.settings.k);
            writableDataStore.put(dBIDIter, (PCAFilteredResult)this.settings.pca.processQueryResult((DoubleDBIDList)kNNList, relation));
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.statistics(duration.end());
        return new Instance(relation.getDBIDs(), writableDataStore, relation);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{new SimpleTypeInformation<PCAFilteredResult>(PCAFilteredResult.class)};
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected ERiC.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(ERiC.Settings.class);
        }

        @Override
        protected ERiCNeighborPredicate<V> makeInstance() {
            return new ERiCNeighborPredicate(this.settings);
        }
    }

    public class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<DBIDs, PCAFilteredResult> {
        private Relation<? extends NumberVector> relation;

        public Instance(DBIDs dBIDs, DataStore<PCAFilteredResult> dataStore, Relation<? extends NumberVector> relation) {
            super(dBIDs, dataStore);
            this.relation = relation;
        }

        @Override
        public DBIDs getNeighbors(DBIDRef dBIDRef) {
            PCAFilteredResult pCAFilteredResult = (PCAFilteredResult)this.storage.get(dBIDRef);
            NumberVector numberVector = this.relation.get(dBIDRef);
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            DBIDIter dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                PCAFilteredResult pCAFilteredResult2 = (PCAFilteredResult)this.storage.get(dBIDIter);
                NumberVector numberVector2 = this.relation.get(dBIDIter);
                if (this.strongNeighbors(numberVector, numberVector2, pCAFilteredResult, pCAFilteredResult2)) {
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            return hashSetModifiableDBIDs;
        }

        @Override
        public DBIDIter iterDBIDs(DBIDs dBIDs) {
            return dBIDs.iter();
        }

        public boolean strongNeighbors(NumberVector numberVector, NumberVector numberVector2, PCAFilteredResult pCAFilteredResult, PCAFilteredResult pCAFilteredResult2) {
            if (pCAFilteredResult.getCorrelationDimension() != pCAFilteredResult2.getCorrelationDimension()) {
                return false;
            }
            if (!this.approximatelyLinearDependent(pCAFilteredResult, pCAFilteredResult2) || !this.approximatelyLinearDependent(pCAFilteredResult2, pCAFilteredResult)) {
                return false;
            }
            Vector vector = numberVector.getColumnVector().minusEquals(numberVector2.getColumnVector());
            return MathUtil.mahalanobisDistance(pCAFilteredResult.similarityMatrix(), vector) <= ERiCNeighborPredicate.this.settings.tau && MathUtil.mahalanobisDistance(pCAFilteredResult2.similarityMatrix(), vector) <= ERiCNeighborPredicate.this.settings.tau;
        }

        public boolean weakNeighbors(NumberVector numberVector, NumberVector numberVector2, PCAFilteredResult pCAFilteredResult, PCAFilteredResult pCAFilteredResult2) {
            if (pCAFilteredResult.getCorrelationDimension() < pCAFilteredResult2.getCorrelationDimension()) {
                return false;
            }
            if (!this.approximatelyLinearDependent(pCAFilteredResult, pCAFilteredResult2)) {
                return false;
            }
            if (pCAFilteredResult.getCorrelationDimension() == pCAFilteredResult2.getCorrelationDimension() && !this.approximatelyLinearDependent(pCAFilteredResult2, pCAFilteredResult)) {
                return false;
            }
            Vector vector = numberVector.getColumnVector().minusEquals(numberVector2.getColumnVector());
            if (MathUtil.mahalanobisDistance(pCAFilteredResult.similarityMatrix(), vector) > ERiCNeighborPredicate.this.settings.tau) {
                return false;
            }
            if (pCAFilteredResult.getCorrelationDimension() == pCAFilteredResult2.getCorrelationDimension()) {
                return MathUtil.mahalanobisDistance(pCAFilteredResult2.similarityMatrix(), vector) <= ERiCNeighborPredicate.this.settings.tau;
            }
            return true;
        }

        protected boolean approximatelyLinearDependent(PCAFilteredResult pCAFilteredResult, PCAFilteredResult pCAFilteredResult2) {
            Matrix matrix = pCAFilteredResult.dissimilarityMatrix();
            Matrix matrix2 = pCAFilteredResult2.adapatedStrongEigenvectors();
            for (int i = 0; i < matrix2.getColumnDimensionality(); ++i) {
                Vector vector = matrix2.getCol(i);
                double d = vector.transposeTimes(vector) - vector.transposeTimesTimes(matrix, vector);
                if (!(d > ERiCNeighborPredicate.this.deltasq)) continue;
                return false;
            }
            return true;
        }

        public int dimensionality(DBIDRef dBIDRef) {
            return ((PCAFilteredResult)this.storage.get(dBIDRef)).getCorrelationDimension();
        }
    }
}

