/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.CASHIntervalSplit;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import java.util.logging.Logger;

public class CASHInterval
extends HyperBoundingBox
implements Comparable<CASHInterval> {
    private static final long serialVersionUID = 1L;
    private static int ID = 0;
    private final Integer intervalID = ++ID;
    private int level;
    private double d_min;
    private double d_max;
    private ModifiableDBIDs ids;
    private int maxSplitDimension;
    private CASHInterval leftChild;
    private CASHInterval rightChild;
    private CASHIntervalSplit split;

    public CASHInterval() {
    }

    public CASHInterval(double[] dArray, double[] dArray2, CASHIntervalSplit cASHIntervalSplit, ModifiableDBIDs modifiableDBIDs, int n, int n2, double d, double d2) {
        super(dArray, dArray2);
        this.split = cASHIntervalSplit;
        this.ids = modifiableDBIDs;
        this.maxSplitDimension = n;
        this.level = n2;
        this.d_min = d;
        this.d_max = d2;
    }

    public ModifiableDBIDs getIDs() {
        return this.ids;
    }

    public void removeIDs(DBIDs dBIDs) {
        this.ids.removeDBIDs(dBIDs);
    }

    public int numObjects() {
        return this.ids.size();
    }

    @Override
    public String toString() {
        return super.toString() + ", ids: " + this.ids.size() + ", d_min: " + this.d_min + ", d_max " + this.d_max;
    }

    public int priority() {
        return this.numObjects();
    }

    public int getMaxSplitDimension() {
        return this.maxSplitDimension;
    }

    public int getLevel() {
        return this.level;
    }

    public CASHInterval getLeftChild() {
        return this.leftChild;
    }

    public CASHInterval getRightChild() {
        return this.rightChild;
    }

    public double getD_min() {
        return this.d_min;
    }

    public double getD_max() {
        return this.d_max;
    }

    @Override
    public int compareTo(CASHInterval cASHInterval) {
        if (this.equals(cASHInterval)) {
            return 0;
        }
        if (this.priority() < cASHInterval.priority()) {
            return -1;
        }
        if (this.priority() > cASHInterval.priority()) {
            return 1;
        }
        if (this.level < cASHInterval.level) {
            return -1;
        }
        if (this.level > cASHInterval.level) {
            return 1;
        }
        if (this.maxSplitDimension < cASHInterval.maxSplitDimension) {
            return -1;
        }
        if (this.maxSplitDimension > cASHInterval.maxSplitDimension) {
            return 1;
        }
        if (cASHInterval.intervalID.compareTo(this.intervalID) < 0) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CASHInterval cASHInterval = (CASHInterval)object;
        if (this.intervalID != cASHInterval.intervalID) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return this.intervalID.hashCode();
    }

    public boolean hasChildren() {
        return this.leftChild != null || this.rightChild != null;
    }

    public void split() {
        if (this.hasChildren()) {
            return;
        }
        boolean bl = this.maxSplitDimension >= this.getDimensionality() - 1;
        int n = bl ? this.level + 1 : this.level;
        int n2 = bl ? 0 : this.maxSplitDimension + 1;
        double d = this.getMin(n2) + (this.getMax(n2) - this.getMin(n2)) * 0.5;
        for (int i = 0; i < 2; ++i) {
            double[] dArray = SpatialUtil.getMin(this);
            double[] dArray2 = SpatialUtil.getMax(this);
            if (i == 0) {
                dArray[n2] = d;
            } else {
                dArray2[n2] = d;
            }
            ModifiableDBIDs modifiableDBIDs = this.split.determineIDs(this.getIDs(), new HyperBoundingBox(dArray, dArray2), this.d_min, this.d_max);
            if (modifiableDBIDs == null) continue;
            if (i == 0) {
                this.rightChild = new CASHInterval(dArray, dArray2, this.split, modifiableDBIDs, n2, n, this.d_min, this.d_max);
                continue;
            }
            this.leftChild = new CASHInterval(dArray, dArray2, this.split, modifiableDBIDs, n2, n, this.d_min, this.d_max);
        }
        if (LoggingConfiguration.DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nchild level ").append(n).append(",  split Dim   ").append(n2);
            if (this.leftChild != null) {
                stringBuilder.append("\nleft   ").append(this.leftChild);
            }
            if (this.rightChild != null) {
                stringBuilder.append("\nright   ").append(this.rightChild);
            }
            Logger.getLogger(this.getClass().getName()).fine(stringBuilder.toString());
        }
    }
}

