/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.FourCCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.FourCNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.LimitEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="4C: Computing Correlation Connected Clusters")
@Description(value="4C identifies local subgroups of data objects sharing a uniform correlation. The algorithm is based on a combination of PCA and density-based clustering (DBSCAN).")
@Reference(authors="C. B\u00f6hm, K. Kailing, P. Kr\u00f6ger, A. Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data, Paris, France, 2004, 455-466", url="http://dx.doi.org/10.1145/1007568.1007620")
public class FourC<V extends NumberVector>
extends GeneralizedDBSCAN {
    private static final Logging LOG = Logging.getLogger(FourC.class);

    public FourC(Settings settings) {
        super(new FourCNeighborPredicate(settings), new FourCCorePredicate(settings), false);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.settings = parameterization.tryInstantiate(Settings.class);
        }

        @Override
        protected FourC<O> makeInstance() {
            return new FourC(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public boolean absolute = false;
        public double delta = 0.0;
        public double kappa = 50.0;
        public int lambda = Integer.MAX_VALUE;
        public int minpts;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final double DEFAULT_DELTA = 0.1;
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                this.settings = new Settings();
                this.configEpsilon(parameterization);
                this.configMinPts(parameterization);
                this.configDelta(parameterization);
                this.configKappa(parameterization);
                this.configLambda(parameterization);
            }

            protected void configEpsilon(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.epsilon = doubleParameter.doubleValue();
                }
            }

            protected void configMinPts(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.minpts = intParameter.intValue();
                }
            }

            protected void configDelta(Parameterization parameterization) {
                Flag flag = new Flag(LimitEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_ABSOLUTE);
                if (parameterization.grab(flag)) {
                    this.settings.absolute = flag.isTrue();
                }
                DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(LimitEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_DELTA).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (!this.settings.absolute) {
                    doubleParameter.setDefaultValue((Object)0.1);
                } else {
                    doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
                }
                if (parameterization.grab(doubleParameter)) {
                    this.settings.delta = doubleParameter.doubleValue();
                }
            }

            protected void configKappa(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.kappa = doubleParameter.doubleValue();
                }
            }

            protected void configLambda(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true);
                if (parameterization.grab(intParameter)) {
                    this.settings.lambda = intParameter.intValue();
                }
            }

            @Override
            protected Object makeInstance() {
                return this.settings;
            }
        }
    }
}

