/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DependencyDerivator;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.CASHInterval;
import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.CASHIntervalSplit;
import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.ParameterizationFunction;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.CorrelationAnalysisSolution;
import de.lmu.ifi.dbs.elki.data.model.LinearEquationModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FirstNEigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.IntegerPriorityObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Arrays;

@Title(value="CASH: Robust clustering in arbitrarily oriented subspaces")
@Description(value="Subspace clustering algorithm based on the Hough transform.")
@Reference(authors="E. Achtert, C. B\u00f6hm, J. David, P. Kr\u00f6ger, A. Zimek", title="Robust clustering in arbitraily oriented subspaces", booktitle="Proc. 8th SIAM Int. Conf. on Data Mining (SDM'08), Atlanta, GA, 2008", url="http://www.siam.org/proceedings/datamining/2008/dm08_69_AchtertBoehmDavidKroegerZimek.pdf")
public class CASH<V extends NumberVector>
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(CASH.class);
    protected int minPts;
    protected int maxLevel;
    protected int minDim;
    protected double jitter;
    protected boolean adjust;
    private int noiseDim;
    private ModifiableDBIDs processedIDs;
    private Relation<ParameterizationFunction> fulldatabase;

    public CASH(int n, int n2, int n3, double d, boolean bl) {
        this.minPts = n;
        this.maxLevel = n2;
        this.minDim = n3;
        this.jitter = d;
        this.adjust = bl;
    }

    public Clustering<Model> run(Database database, Relation<V> relation) {
        Object object;
        this.fulldatabase = this.preprocess(database, relation);
        if (LOG.isVerbose()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("DB size: ").append(this.fulldatabase.size());
            ((StringBuilder)object).append("\nmin Dim: ").append(this.minDim);
            LOG.verbose(((StringBuilder)object).toString());
        }
        this.processedIDs = DBIDUtil.newHashSet(this.fulldatabase.size());
        this.noiseDim = CASH.dimensionality(this.fulldatabase);
        object = LOG.isVerbose() ? new FiniteProgress("CASH Clustering", this.fulldatabase.size(), LOG) : null;
        Clustering<Model> clustering = this.doRun(this.fulldatabase, (FiniteProgress)object);
        LOG.ensureCompleted((FiniteProgress)object);
        if (LOG.isVerbose()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Cluster<Model> cluster : clustering.getAllClusters()) {
                if (cluster.getModel() instanceof LinearEquationModel) {
                    LinearEquationModel linearEquationModel = (LinearEquationModel)cluster.getModel();
                    stringBuilder.append("\n Cluster: Dim: " + linearEquationModel.getLes().subspacedim() + " size: " + cluster.size());
                    continue;
                }
                stringBuilder.append("\n Cluster: " + cluster.getModel().getClass().getName() + " size: " + cluster.size());
            }
            LOG.verbose(stringBuilder.toString());
        }
        return clustering;
    }

    private Relation<ParameterizationFunction> preprocess(Database database, Relation<V> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        SimpleTypeInformation<ParameterizationFunction> simpleTypeInformation = new SimpleTypeInformation<ParameterizationFunction>(ParameterizationFunction.class);
        WritableDataStore<ParameterizationFunction> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 2, ParameterizationFunction.class);
        Object object = dBIDs.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, new ParameterizationFunction((NumberVector)relation.get((DBIDRef)object)));
            object.advance();
        }
        object = new MaterializedRelation<ParameterizationFunction>(simpleTypeInformation, dBIDs, null, writableDataStore);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Clustering<Model> doRun(Relation<ParameterizationFunction> relation, FiniteProgress finiteProgress) {
        Object object;
        Cluster<LinearEquationModel> cluster;
        Object object2;
        Clustering<Model> clustering = new Clustering<Model>("CASH clustering", "cash-clustering");
        int n = CASH.dimensionality(relation);
        ComparableMinHeap<IntegerPriorityObject<CASHInterval>> comparableMinHeap = new ComparableMinHeap<IntegerPriorityObject<CASHInterval>>();
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(relation.getDBIDs());
        this.initHeap(comparableMinHeap, relation, n, hashSetModifiableDBIDs);
        if (LOG.isDebugging()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            ((StringBuilder)object2).append("\nXXXX dim ").append(n);
            ((StringBuilder)object2).append("\nXXXX database.size ").append(relation.size());
            ((StringBuilder)object2).append("\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            LOG.debugFine(((StringBuilder)object2).toString());
        } else if (LOG.isVerbose()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("XXXX dim ").append(n).append(" database.size ").append(relation.size());
            LOG.verbose(((StringBuilder)object2).toString());
        }
        while (!comparableMinHeap.isEmpty()) {
            Object object3;
            object2 = this.determineNextIntervalAtMaxLevel(comparableMinHeap);
            if (LOG.isDebugging()) {
                LOG.debugFine("next interval in dim " + n + ": " + object2);
            } else if (LOG.isVerbose()) {
                LOG.verbose("next interval in dim " + n + ": " + object2);
            }
            if (object2 == null) break;
            cluster = DBIDUtil.newHashSet();
            if (n > this.minDim + 1) {
                void var9_12;
                if (this.adjust) {
                    HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet();
                    object = this.runDerivator(relation, n, (CASHInterval)object2, hashSetModifiableDBIDs2);
                } else {
                    ModifiableDBIDs modifiableDBIDs = ((CASHInterval)object2).getIDs();
                    object = this.determineBasis(SpatialUtil.centroid((SpatialComparable)object2));
                }
                if (var9_12.size() != 0) {
                    Object object4 = this.buildDB(n, (Matrix)object, (DBIDs)var9_12, relation);
                    object3 = this.doRun((Relation<ParameterizationFunction>)object4, finiteProgress);
                    for (Cluster<Model> cluster2 : ((Clustering)object3).getAllClusters()) {
                        clustering.addToplevelCluster(cluster2);
                        hashSetModifiableDBIDs.removeDBIDs(cluster2.getIDs());
                        cluster.addDBIDs(cluster2.getIDs());
                        this.processedIDs.addDBIDs(cluster2.getIDs());
                    }
                }
            } else {
                LinearEquationSystem linearEquationSystem = this.runDerivator(relation, n - 1, ((CASHInterval)object2).getIDs());
                object = new Cluster<LinearEquationModel>((DBIDs)((CASHInterval)object2).getIDs(), new LinearEquationModel(linearEquationSystem));
                clustering.addToplevelCluster((Cluster<Model>)object);
                hashSetModifiableDBIDs.removeDBIDs(((CASHInterval)object2).getIDs());
                cluster.addDBIDs(((CASHInterval)object2).getIDs());
                this.processedIDs.addDBIDs(((CASHInterval)object2).getIDs());
            }
            ArrayList object5 = new ArrayList(comparableMinHeap.size());
            object = comparableMinHeap.unsortedIter();
            while (object.valid()) {
                object5.add(object.get());
                object.advance();
            }
            comparableMinHeap.clear();
            for (Object object4 : object5) {
                object3 = (CASHInterval)((IntegerPriorityObject)object4).getObject();
                ((CASHInterval)object3).removeIDs((DBIDs)((Object)cluster));
                if (((CASHInterval)object3).getIDs().size() < this.minPts) continue;
                comparableMinHeap.add(new IntegerPriorityObject<Object>(((CASHInterval)object3).priority(), object3));
            }
            if (finiteProgress == null) continue;
            finiteProgress.setProcessed(this.processedIDs.size(), LOG);
        }
        if (!hashSetModifiableDBIDs.isEmpty()) {
            if (n == this.noiseDim) {
                object2 = new Cluster<ClusterModel>(hashSetModifiableDBIDs, true, ClusterModel.CLUSTER);
                clustering.addToplevelCluster((Cluster<Model>)object2);
                this.processedIDs.addDBIDs(hashSetModifiableDBIDs);
            } else if (hashSetModifiableDBIDs.size() >= this.minPts) {
                object2 = this.runDerivator(this.fulldatabase, n - 1, hashSetModifiableDBIDs);
                cluster = new Cluster<LinearEquationModel>(hashSetModifiableDBIDs, true, new LinearEquationModel((LinearEquationSystem)object2));
                clustering.addToplevelCluster(cluster);
                this.processedIDs.addDBIDs(hashSetModifiableDBIDs);
            }
        }
        if (LOG.isDebugging()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("noise fuer dim ").append(n).append(": ").append(hashSetModifiableDBIDs.size());
            for (Cluster cluster3 : clustering.getAllClusters()) {
                if (cluster3.getModel() instanceof LinearEquationModel) {
                    object = (LinearEquationModel)cluster3.getModel();
                    ((StringBuilder)object2).append("\n Cluster: Dim: " + ((LinearEquationModel)object).getLes().subspacedim() + " size: " + cluster3.size());
                    continue;
                }
                ((StringBuilder)object2).append("\n Cluster: " + cluster3.getModel().getClass().getName() + " size: " + cluster3.size());
            }
            LOG.debugFine(((StringBuilder)object2).toString());
        }
        if (finiteProgress != null) {
            finiteProgress.setProcessed(this.processedIDs.size(), LOG);
        }
        return clustering;
    }

    private static int dimensionality(Relation<ParameterizationFunction> relation) {
        return relation.get(relation.iterDBIDs()).getDimensionality();
    }

    private void initHeap(ObjectHeap<IntegerPriorityObject<CASHInterval>> objectHeap, Relation<ParameterizationFunction> relation, int n, DBIDs dBIDs) {
        Object object;
        CASHIntervalSplit cASHIntervalSplit = new CASHIntervalSplit(relation, this.minPts);
        double[] dArray = this.determineMinMaxDistance(relation, n);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = d2 - d;
        int n2 = (int)Math.ceil(d3 / this.jitter);
        double d4 = d3 / (double)n2;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        if (LOG.isDebugging()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("d_min ").append(d);
            ((StringBuilder)object).append("\nd_max ").append(d2);
            ((StringBuilder)object).append("\nnumDIntervals ").append(n2);
            ((StringBuilder)object).append("\ndIntervalSize ").append(d4);
            LOG.debugFine(((StringBuilder)object).toString());
        } else if (LOG.isVerbose()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("d_min ").append(d);
            ((StringBuilder)object).append("\nd_max ").append(d2);
            ((StringBuilder)object).append("\nnumDIntervals ").append(n2);
            ((StringBuilder)object).append("\ndIntervalSize ").append(d4);
            LOG.verbose(((StringBuilder)object).toString());
        }
        object = new double[n - 1];
        double[] dArray4 = new double[n - 1];
        Arrays.fill(dArray4, Math.PI);
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = i == 0 ? d : dArray3[i - 1];
            dArray3[i] = i < n2 - 1 ? dArray2[i] + d4 : d2 - dArray2[i];
            HyperBoundingBox hyperBoundingBox = new HyperBoundingBox((double[])object, dArray4);
            ModifiableDBIDs modifiableDBIDs = cASHIntervalSplit.determineIDs(dBIDs, hyperBoundingBox, dArray2[i], dArray3[i]);
            if (modifiableDBIDs == null || modifiableDBIDs.size() < this.minPts) continue;
            CASHInterval cASHInterval = new CASHInterval((double[])object, dArray4, cASHIntervalSplit, modifiableDBIDs, -1, 0, dArray2[i], dArray3[i]);
            objectHeap.add(new IntegerPriorityObject<CASHInterval>(cASHInterval.priority(), cASHInterval));
        }
        if (LOG.isDebuggingFiner()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("heap.size ").append(objectHeap.size());
            LOG.debugFiner(stringBuilder.toString());
        }
    }

    private MaterializedRelation<ParameterizationFunction> buildDB(int n, Matrix matrix, DBIDs dBIDs, Relation<ParameterizationFunction> relation) {
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs);
        SimpleTypeInformation<ParameterizationFunction> simpleTypeInformation = new SimpleTypeInformation<ParameterizationFunction>(ParameterizationFunction.class);
        WritableDataStore<ParameterizationFunction> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 2, ParameterizationFunction.class);
        Object object = dBIDs.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, this.project(matrix, relation.get((DBIDRef)object)));
            object.advance();
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("db fuer dim " + (n - 1) + ": " + dBIDs.size());
        }
        object = new MaterializedRelation<ParameterizationFunction>(simpleTypeInformation, dBIDs, null, writableDataStore);
        proxyDatabase.addRelation((Relation<?>)object);
        return object;
    }

    private ParameterizationFunction project(Matrix matrix, ParameterizationFunction parameterizationFunction) {
        Matrix matrix2 = parameterizationFunction.getColumnVector().transposeTimes(matrix);
        ParameterizationFunction parameterizationFunction2 = new ParameterizationFunction(new DoubleVector(matrix2.getColumnPackedCopy()));
        return parameterizationFunction2;
    }

    private Matrix determineBasis(double[] dArray) {
        double[] dArray2 = new double[dArray.length + 1];
        for (int i = 0; i < dArray2.length; ++i) {
            double d = i == dArray.length ? 0.0 : dArray[i];
            dArray2[i] = this.sinusProduct(0, i, dArray) * StrictMath.cos(d);
        }
        Matrix matrix = new Matrix(dArray2, dArray.length + 1);
        return matrix.completeToOrthonormalBasis();
    }

    private double sinusProduct(int n, int n2, double[] dArray) {
        double d = 1.0;
        for (int i = n; i < n2; ++i) {
            d *= Math.sin(dArray[i]);
        }
        return d;
    }

    private CASHInterval determineNextIntervalAtMaxLevel(ObjectHeap<IntegerPriorityObject<CASHInterval>> objectHeap) {
        CASHInterval cASHInterval = this.doDetermineNextIntervalAtMaxLevel(objectHeap);
        while (cASHInterval == null) {
            if (objectHeap.isEmpty()) {
                return null;
            }
            cASHInterval = this.doDetermineNextIntervalAtMaxLevel(objectHeap);
        }
        return cASHInterval;
    }

    private CASHInterval doDetermineNextIntervalAtMaxLevel(ObjectHeap<IntegerPriorityObject<CASHInterval>> objectHeap) {
        CASHInterval cASHInterval = objectHeap.poll().getObject();
        int n = cASHInterval.getDimensionality();
        while (cASHInterval.getLevel() < this.maxLevel || cASHInterval.getMaxSplitDimension() != n - 1) {
            CASHInterval cASHInterval2;
            if (objectHeap.size() % 10000 == 0 && LOG.isVerbose()) {
                LOG.verbose("heap size " + objectHeap.size());
            }
            if (objectHeap.size() >= 40000) {
                LOG.warning("Heap size > 40.000!!!");
                objectHeap.clear();
                return null;
            }
            if (LOG.isDebuggingFiner()) {
                LOG.debugFiner("split " + cASHInterval.toString() + " " + cASHInterval.getLevel() + "-" + cASHInterval.getMaxSplitDimension());
            }
            cASHInterval.split();
            if (!cASHInterval.hasChildren()) {
                return null;
            }
            if (cASHInterval.getLeftChild() != null && cASHInterval.getRightChild() != null) {
                int n2 = cASHInterval.getLeftChild().compareTo(cASHInterval.getRightChild());
                if (n2 < 0) {
                    cASHInterval2 = cASHInterval.getRightChild();
                    objectHeap.add(new IntegerPriorityObject<CASHInterval>(cASHInterval.getLeftChild().priority(), cASHInterval.getLeftChild()));
                } else {
                    cASHInterval2 = cASHInterval.getLeftChild();
                    objectHeap.add(new IntegerPriorityObject<CASHInterval>(cASHInterval.getRightChild().priority(), cASHInterval.getRightChild()));
                }
            } else {
                cASHInterval2 = cASHInterval.getLeftChild() == null ? cASHInterval.getRightChild() : cASHInterval.getLeftChild();
            }
            cASHInterval = cASHInterval2;
        }
        return cASHInterval;
    }

    private double[] determineMinMaxDistance(Relation<ParameterizationFunction> relation, int n) {
        double[] dArray = new double[n - 1];
        double[] dArray2 = new double[n - 1];
        Arrays.fill(dArray2, Math.PI);
        HyperBoundingBox hyperBoundingBox = new HyperBoundingBox(dArray, dArray2);
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            ParameterizationFunction parameterizationFunction = relation.get(dBIDIter);
            HyperBoundingBox hyperBoundingBox2 = parameterizationFunction.determineAlphaMinMax(hyperBoundingBox);
            double d3 = parameterizationFunction.function(SpatialUtil.getMin(hyperBoundingBox2));
            double d4 = parameterizationFunction.function(SpatialUtil.getMax(hyperBoundingBox2));
            d = Math.min(d, d3);
            d2 = Math.max(d2, d4);
            dBIDIter.advance();
        }
        return new double[]{d, d2};
    }

    private Matrix runDerivator(Relation<ParameterizationFunction> relation, int n, CASHInterval cASHInterval, ModifiableDBIDs modifiableDBIDs) {
        Database database = this.buildDerivatorDB(relation, cASHInterval);
        ListParameterization listParameterization = new ListParameterization();
        listParameterization.addParameter(PCAFilteredRunner.Parameterizer.PCA_EIGENPAIR_FILTER, FirstNEigenPairFilter.class.getName());
        listParameterization.addParameter(FirstNEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_N, Integer.toString(n - 1));
        DependencyDerivator dependencyDerivator = null;
        Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(DependencyDerivator.class);
        dependencyDerivator = (DependencyDerivator)listParameterization.tryInstantiate(clazz);
        CorrelationAnalysisSolution correlationAnalysisSolution = (CorrelationAnalysisSolution)dependencyDerivator.run(database);
        Matrix matrix = correlationAnalysisSolution.getSimilarityMatrix();
        DoubleVector doubleVector = new DoubleVector(correlationAnalysisSolution.getCentroid());
        DistanceQuery<NumberVector> distanceQuery = QueryUtil.getDistanceQuery(database, new MatrixWeightedDistanceFunction(matrix), new Object[0]);
        double d = 0.25;
        modifiableDBIDs.addDBIDs(cASHInterval.getIDs());
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            DoubleVector doubleVector2 = new DoubleVector(relation.get((DBIDRef)object).getColumnVector());
            double d2 = distanceQuery.distance((NumberVector)doubleVector2, (NumberVector)doubleVector);
            if (d2 <= d) {
                modifiableDBIDs.add((DBIDRef)object);
            }
            object.advance();
        }
        object = correlationAnalysisSolution.getStrongEigenvectors();
        return ((Matrix)object).getMatrix(0, ((Matrix)object).getRowDimensionality() - 1, 0, n - 2);
    }

    private Database buildDerivatorDB(Relation<ParameterizationFunction> relation, CASHInterval cASHInterval) {
        ModifiableDBIDs modifiableDBIDs = cASHInterval.getIDs();
        ProxyDatabase proxyDatabase = new ProxyDatabase(modifiableDBIDs);
        int n = CASH.dimensionality(relation);
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n);
        WritableDataStore<DoubleVector> writableDataStore = DataStoreUtil.makeStorage(modifiableDBIDs, 2, DoubleVector.class);
        Object object = modifiableDBIDs.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, new DoubleVector(relation.get((DBIDRef)object).getColumnVector().getArrayRef()));
            object.advance();
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("db fuer derivator : " + modifiableDBIDs.size());
        }
        object = new MaterializedRelation<DoubleVector>(vectorFieldTypeInformation, modifiableDBIDs, null, writableDataStore);
        proxyDatabase.addRelation((Relation<?>)object);
        return proxyDatabase;
    }

    private LinearEquationSystem runDerivator(Relation<ParameterizationFunction> relation, int n, DBIDs dBIDs) {
        try {
            Database database = this.buildDerivatorDB(relation, dBIDs);
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(PCAFilteredRunner.Parameterizer.PCA_EIGENPAIR_FILTER, FirstNEigenPairFilter.class.getName());
            listParameterization.addParameter(FirstNEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_N, Integer.toString(n));
            DependencyDerivator dependencyDerivator = null;
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(DependencyDerivator.class);
            dependencyDerivator = (DependencyDerivator)listParameterization.tryInstantiate(clazz);
            CorrelationAnalysisSolution correlationAnalysisSolution = (CorrelationAnalysisSolution)dependencyDerivator.run(database);
            LinearEquationSystem linearEquationSystem = correlationAnalysisSolution.getNormalizedLinearEquationSystem(null);
            return linearEquationSystem;
        }
        catch (NonNumericFeaturesException nonNumericFeaturesException) {
            throw new IllegalStateException("Error during normalization" + nonNumericFeaturesException);
        }
    }

    private Database buildDerivatorDB(Relation<ParameterizationFunction> relation, DBIDs dBIDs) {
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs);
        int n = CASH.dimensionality(relation);
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n);
        MaterializedRelation<DoubleVector> materializedRelation = new MaterializedRelation<DoubleVector>(vectorFieldTypeInformation, dBIDs);
        proxyDatabase.addRelation(materializedRelation);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DoubleVector doubleVector = new DoubleVector(relation.get(dBIDIter).getColumnVector().getArrayRef());
            materializedRelation.insert(dBIDIter, doubleVector);
            dBIDIter.advance();
        }
        return proxyDatabase;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINPTS_ID = new OptionID("cash.minpts", "Threshold for minimum number of points in a cluster.");
        public static final OptionID MAXLEVEL_ID = new OptionID("cash.maxlevel", "The maximum level for splitting the hypercube.");
        public static final OptionID MINDIM_ID = new OptionID("cash.mindim", "The minimum dimensionality of the subspaces to be found.");
        public static final OptionID JITTER_ID = new OptionID("cash.jitter", "The maximum jitter for distance values.");
        public static final OptionID ADJUST_ID = new OptionID("cash.adjust", "Flag to indicate that an adjustment of the applied heuristic for choosing an interval is performed after an interval is selected.");
        protected int minPts;
        protected int maxLevel;
        protected int minDim;
        protected double jitter;
        protected boolean adjust;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(MINPTS_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minPts = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(MAXLEVEL_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.maxLevel = (Integer)intParameter2.getValue();
            }
            IntParameter intParameter3 = new IntParameter(MINDIM_ID, 1);
            intParameter3.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter3)) {
                this.minDim = (Integer)intParameter3.getValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(JITTER_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.jitter = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(ADJUST_ID))) {
                this.adjust = (Boolean)flag.getValue();
            }
        }

        @Override
        protected CASH<NumberVector> makeInstance() {
            return new CASH<NumberVector>(this.minPts, this.maxLevel, this.minDim, this.jitter, this.adjust);
        }
    }
}

