/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;

@Reference(authors="S. Mahran and K. Mahar", title="Using grid for accelerating density-based clustering", booktitle="8th IEEE Int. Conf. on Computer and Information Technology", url="http://dx.doi.org/10.1109/CIT.2008.4594646")
public class GriDBSCAN<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(GriDBSCAN.class);
    protected double epsilon;
    protected int minpts;
    protected double gridwidth;

    public GriDBSCAN(DistanceFunction<? super V> distanceFunction, double d, int n, double d2) {
        super(distanceFunction);
        this.epsilon = d;
        this.minpts = n;
        this.gridwidth = d2;
    }

    public Clustering<Model> run(Relation<V> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        if (dBIDs.size() < this.minpts) {
            Clustering<Model> clustering = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            clustering.addToplevelCluster(new Cluster<ClusterModel>(dBIDs, true, ClusterModel.CLUSTER));
            return clustering;
        }
        double d = this.gridwidth;
        if (d < 2.0 * this.epsilon) {
            LOG.warning("Invalid grid width (less than 2*epsilon, recommended 10*epsilon). Increasing grid width automatically.");
            d = 2.0 * this.epsilon;
        }
        return new Instance(this.getDistanceFunction(), this.epsilon, this.minpts, d).run(relation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        CombinedTypeInformation combinedTypeInformation = new CombinedTypeInformation(TypeUtil.NUMBER_VECTOR_FIELD, this.getDistanceFunction().getInputTypeRestriction());
        return TypeUtil.array(combinedTypeInformation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID GRID_ID = new OptionID("gridbscan.gridwidth", "Width of the grid used, must be at least two times epsilon.");
        protected double epsilon;
        protected int minpts;
        protected double gridwidth;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            DoubleParameter doubleParameter;
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, LPNormDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.epsilon = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = (Integer)intParameter.getValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
            DoubleParameter doubleParameter2 = (DoubleParameter)new DoubleParameter(GRID_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (this.epsilon > 0.0) {
                doubleParameter2.setDefaultValue((Object)(10.0 * this.epsilon));
                doubleParameter2.addConstraint((ParameterConstraint)new GreaterEqualConstraint(1.0 * this.epsilon));
            }
            if (parameterization.grab(doubleParameter2)) {
                this.gridwidth = doubleParameter2.doubleValue();
            }
        }

        @Override
        protected GriDBSCAN<O> makeInstance() {
            return new GriDBSCAN(this.distanceFunction, this.epsilon, this.minpts, this.gridwidth);
        }
    }

    protected static class MultiBorder
    implements Assignment {
        protected Border[] cs;

        protected MultiBorder(Border border, Border border2) {
            assert (border.core != border2.core);
            this.cs = new Border[]{border, border2};
        }

        public Assignment update(Border border) {
            Arrays.sort(this.cs);
            int n = 1;
            boolean bl = this.cs[0].core == border.core;
            for (int i = 1; i < this.cs.length; ++i) {
                if (this.cs[i].core != this.cs[i - 1].core) {
                    this.cs[n++] = this.cs[i];
                }
                bl |= this.cs[i].core == border.core;
            }
            if (bl) {
                if (n == 1) {
                    Border border2 = this.cs[0];
                    this.cs = null;
                    return border2;
                }
                if (n < this.cs.length) {
                    this.cs = Arrays.copyOf(this.cs, n);
                }
                return this;
            }
            if (n + 1 != this.cs.length) {
                this.cs = Arrays.copyOf(this.cs, n + 1);
            }
            this.cs[n] = border;
            return this;
        }

        public Core getCore() {
            Core core = this.cs[0].core;
            for (int i = 1; i < this.cs.length; ++i) {
                Core core2 = this.cs[i].core;
                core = core.parent > core2.parent ? core : core2;
            }
            assert (core.parent > 1);
            return core;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MultiBorder[");
            for (Border border : this.cs) {
                stringBuilder.append(border.core.parent).append(',');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    protected static class Border
    implements Assignment,
    Comparable<Border> {
        protected Core core;

        protected Border(Core core) {
            this.core = core;
        }

        public String toString() {
            return "Border[" + this.core.parent + "]";
        }

        @Override
        public int compareTo(Border border) {
            return Integer.compare(border.core.parent, this.core.parent);
        }
    }

    protected static class Core
    implements Assignment {
        protected int parent;

        protected Core(int n) {
            assert (n > 1);
            this.parent = n;
        }

        public void mergeWith(Core core) {
            this.parent = this.parent < core.parent ? this.parent : core.parent;
            core.parent = this.parent;
        }

        public String toString() {
            return "Core[" + this.parent + "]";
        }
    }

    protected static interface Assignment {
    }

    protected static class Instance<V extends NumberVector> {
        protected static final int UNPROCESSED = 0;
        protected static final int NOISE = 1;
        protected DistanceFunction<? super V> distanceFunction;
        protected double epsilon;
        protected int minpts;
        protected double gridwidth;
        protected double[][] domain;
        protected int dim;
        protected double[] offset;
        protected int[] cells;
        TLongObjectHashMap<ModifiableDBIDs> grid;
        private Core[] cores;
        private Border[] borders;
        private WritableDataStore<Assignment> clusterids;
        private WritableIntegerDataStore temporary;
        private boolean overflown;

        public Instance(DistanceFunction<? super V> distanceFunction, double d, int n, double d2) {
            this.distanceFunction = distanceFunction;
            this.epsilon = d;
            this.minpts = n;
            this.gridwidth = d2;
        }

        public Clustering<Model> run(Relation<V> relation) {
            Object object;
            Object object2;
            Clustering<Model> clustering;
            Object object3;
            ModifiableDBIDs[] modifiableDBIDsArray;
            DBIDs dBIDs = relation.getDBIDs();
            int n = dBIDs.size();
            this.domain = RelationUtil.computeMinMax(relation);
            this.dim = this.domain[0].length;
            this.offset = new double[this.dim];
            this.cells = new int[this.dim];
            long l = this.computeGridBaseOffsets();
            if (l > (long)n) {
                LOG.warning("The generated grid has more cells than data points. This may need excessive amounts of memory.");
            } else if (l == 1L) {
                LOG.warning("All data is in a single cell. This has degenerated to a non-indexed DBSCAN!");
            } else if (l <= (long)(this.dim * this.dim)) {
                LOG.warning("There are only " + l + " cells. This will likely be slower than regular DBSCAN!");
            }
            this.buildGrid(relation, (int)l, this.offset);
            if (this.grid.size() <= this.dim) {
                LOG.warning("There are only " + this.grid.size() + " occupied cells. This will likely be slower than regular DBSCAN!");
            }
            int n2 = this.checkGridCellSizes(n, l);
            this.clusterids = DataStoreUtil.makeStorage(dBIDs, 1, Assignment.class);
            this.temporary = DataStoreUtil.makeIntegerStorage(dBIDs, 1, 0);
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
            int n3 = 2;
            this.cores = new Core[2];
            this.borders = new Border[2];
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(this.minpts << 1);
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing grid cells", n2, LOG) : null;
            Object object4 = this.grid.iterator();
            while (object4.hasNext()) {
                object4.advance();
                modifiableDBIDsArray = (ModifiableDBIDs[])object4.value();
                if (modifiableDBIDsArray.size() < this.minpts) continue;
                this.temporary.clear();
                object3 = new ProxyView<V>((DBIDs)modifiableDBIDsArray, relation);
                clustering = ((AbstractRelation)object3).getRangeQuery(this.distanceFunction, this.epsilon);
                object2 = LOG.isVerbose() ? new FiniteProgress("Running DBSCAN", modifiableDBIDsArray.size(), LOG) : null;
                object = modifiableDBIDsArray.iter();
                while (object.valid()) {
                    if (this.temporary.intValue((DBIDRef)object) == 0) {
                        modifiableDoubleDBIDList.clear();
                        clustering.getRangeForDBID((DBIDRef)object, this.epsilon, modifiableDoubleDBIDList);
                        if (modifiableDoubleDBIDList.size() >= this.minpts) {
                            this.expandCluster((DBIDRef)object, n3, this.temporary, modifiableDoubleDBIDList, arrayModifiableDBIDs, (RangeQuery<V>)((Object)clustering), (FiniteProgress)object2);
                            ++n3;
                        } else {
                            this.temporary.putInt((DBIDRef)object, 1);
                            LOG.incrementProcessed((AbstractProgress)object2);
                        }
                    }
                    object.advance();
                }
                LOG.ensureCompleted((FiniteProgress)object2);
                this.updateCoreBorderObjects(n3);
                this.mergeClusterInformation((ModifiableDBIDs)modifiableDBIDsArray, this.temporary, this.clusterids);
                LOG.incrementProcessed(finiteProgress);
            }
            LOG.ensureCompleted(finiteProgress);
            this.temporary.destroy();
            object4 = LOG.isVerbose() ? new FiniteProgress("Building final result", n, LOG) : null;
            modifiableDBIDsArray = new ModifiableDBIDs[n3];
            object3 = DBIDUtil.newArray();
            clustering = dBIDs.iter();
            while (clustering.valid()) {
                object2 = (Assignment)this.clusterids.get((DBIDRef)((Object)clustering));
                if (object2 == null) {
                    object3.add((DBIDRef)((Object)clustering));
                } else {
                    if (object2 instanceof MultiBorder) {
                        object2 = ((MultiBorder)object2).getCore();
                    } else if (object2 instanceof Border) {
                        object2 = ((Border)object2).core;
                    }
                    assert (object2 instanceof Core);
                    object = (Core)object2;
                    while (this.cores[((Core)object).parent].parent != ((Core)object).parent) {
                        ((Core)object).parent = this.cores[((Core)object).parent].parent;
                        object = this.cores[((Core)object).parent];
                    }
                    ModifiableDBIDs modifiableDBIDs = modifiableDBIDsArray[((Core)object).parent];
                    if (modifiableDBIDs == null) {
                        modifiableDBIDs = modifiableDBIDsArray[((Core)object).parent] = DBIDUtil.newArray();
                    }
                    modifiableDBIDs.add((DBIDRef)((Object)clustering));
                }
                LOG.incrementProcessed((AbstractProgress)object4);
                clustering.advance();
            }
            LOG.ensureCompleted((FiniteProgress)object4);
            this.clusterids.destroy();
            clustering = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            for (int i = 2; i < modifiableDBIDsArray.length; ++i) {
                if (modifiableDBIDsArray[i] == null) continue;
                clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)modifiableDBIDsArray[i], ClusterModel.CLUSTER));
            }
            if (object3.size() > 0) {
                clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)object3, true, ClusterModel.CLUSTER));
            }
            return clustering;
        }

        private void updateCoreBorderObjects(int n) {
            this.cores = Arrays.copyOf(this.cores, n);
            this.borders = Arrays.copyOf(this.borders, n);
            for (int i = this.cores.length; i < n; ++i) {
                this.cores[i] = new Core(i);
                this.borders[i] = new Border(this.cores[i]);
            }
        }

        private long computeGridBaseOffsets() {
            StringBuffer stringBuffer = LOG.isDebuggingFinest() ? new StringBuffer() : null;
            double[] dArray = this.domain[0];
            double[] dArray2 = this.domain[1];
            long l = 1L;
            for (int i = 0; i < this.dim; ++i) {
                double d = dArray[i];
                double d2 = dArray2[i];
                double d3 = d2 - d;
                if (d == Double.NEGATIVE_INFINITY || d2 == Double.POSITIVE_INFINITY || d != d || d2 != d2) {
                    throw new AbortException("Dimension " + i + " contains non-finite values.");
                }
                int n = this.cells[i] = Math.max(1, (int)Math.ceil(d3 / this.gridwidth));
                this.offset[i] = d - ((double)n * this.gridwidth - d3) * 0.5;
                assert (this.offset[i] <= d) : "Grid inconsistent.";
                assert (this.offset[i] + (double)n * this.gridwidth >= d2) : "Grid inconsistent.";
                if ((l *= (long)n) < 0L) {
                    LOG.warning("Excessive amount of grid cells (long overflow)! Use larger grid cells.");
                    if (l < 0L) {
                        this.overflown = true;
                        l &= Long.MAX_VALUE;
                    }
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(i).append(": min=").append(d).append(" max=").append(d2);
                double d4 = this.offset[i];
                for (int j = 0; j <= n; ++j) {
                    stringBuffer.append(' ').append(d4);
                    d4 += this.gridwidth;
                }
                stringBuffer.append('\n');
            }
            if (stringBuffer != null) {
                LOG.debugFinest(stringBuffer);
            }
            return l;
        }

        protected void buildGrid(Relation<V> relation, int n, double[] dArray) {
            this.grid = new TLongObjectHashMap(n >>> 2);
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
                this.insertIntoGrid(dBIDIter, numberVector, 0, 0);
                dBIDIter.advance();
            }
        }

        private void insertIntoGrid(DBIDRef dBIDRef, V v, int n, int n2) {
            int n3 = this.cells[n];
            int n4 = n + 1;
            int n5 = Math.max(0, (int)Math.floor((v.doubleValue(n) - this.offset[n] - this.epsilon) / this.gridwidth));
            int n6 = Math.min(n3 - 1, (int)Math.floor((v.doubleValue(n) - this.offset[n] + this.epsilon) / this.gridwidth));
            assert (n5 <= n6) : "Grid inconsistent.";
            for (int i = n5; i <= n6; ++i) {
                int n7 = n2 * n3 + i;
                if (n4 == this.cells.length) {
                    ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)this.grid.get((long)n7);
                    if (modifiableDBIDs == null) {
                        modifiableDBIDs = DBIDUtil.newArray();
                        this.grid.put((long)n7, (Object)modifiableDBIDs);
                    }
                    modifiableDBIDs.add(dBIDRef);
                    continue;
                }
                this.insertIntoGrid(dBIDRef, v, n4, n7);
            }
        }

        protected int checkGridCellSizes(int n, long l) {
            int n2 = 0;
            int n3 = 0;
            double d = 0.0;
            TLongObjectIterator tLongObjectIterator = this.grid.iterator();
            while (tLongObjectIterator.hasNext()) {
                tLongObjectIterator.advance();
                int n4 = ((ModifiableDBIDs)tLongObjectIterator.value()).size();
                if (n4 >= n >> 1) {
                    LOG.warning("A single cell contains half of the database (" + n4 + " objects). This will not scale very well.");
                }
                n2 += n4;
                d += (double)((long)n4 * (long)n4);
                if (n4 < this.minpts) continue;
                ++n3;
            }
            double d2 = d / (double)n / (double)n;
            if (d2 >= 1.0) {
                LOG.warning("Pairwise distances within each cells are more expensive than a full DBSCAN run due to overlap!");
            }
            if (this.overflown) {
                LOG.statistics(new StringStatistic(GriDBSCAN.class.getName() + ".all-cells", "overflow"));
            } else {
                LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".all-cells", l));
            }
            LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".used-cells", this.grid.size()));
            LOG.statistics(new LongStatistic(GriDBSCAN.class.getName() + ".minpts-cells", n3));
            LOG.statistics(new DoubleStatistic(GriDBSCAN.class.getName() + ".redundancy", (double)n2 / (double)n));
            LOG.statistics(new DoubleStatistic(GriDBSCAN.class.getName() + ".relative-cost", d2));
            return n3;
        }

        protected int expandCluster(DBIDRef dBIDRef, int n, WritableIntegerDataStore writableIntegerDataStore, ModifiableDoubleDBIDList modifiableDoubleDBIDList, ArrayModifiableDBIDs arrayModifiableDBIDs, RangeQuery<V> rangeQuery, FiniteProgress finiteProgress) {
            assert (arrayModifiableDBIDs.size() == 0);
            int n2 = 1 + this.processCorePoint(dBIDRef, modifiableDoubleDBIDList, n, writableIntegerDataStore, arrayModifiableDBIDs);
            LOG.incrementProcessed(finiteProgress);
            DBIDVar dBIDVar = DBIDUtil.newVar();
            while (!arrayModifiableDBIDs.isEmpty()) {
                arrayModifiableDBIDs.pop(dBIDVar);
                modifiableDoubleDBIDList.clear();
                rangeQuery.getRangeForDBID(dBIDVar, this.epsilon, modifiableDoubleDBIDList);
                if (modifiableDoubleDBIDList.size() >= this.minpts) {
                    n2 += this.processCorePoint(dBIDVar, modifiableDoubleDBIDList, n, writableIntegerDataStore, arrayModifiableDBIDs);
                }
                LOG.incrementProcessed(finiteProgress);
            }
            return n2;
        }

        protected int processCorePoint(DBIDRef dBIDRef, DoubleDBIDList doubleDBIDList, int n, WritableIntegerDataStore writableIntegerDataStore, ArrayModifiableDBIDs arrayModifiableDBIDs) {
            writableIntegerDataStore.putInt(dBIDRef, n);
            int n2 = 0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                block8: {
                    block7: {
                        int n3;
                        block6: {
                            n3 = writableIntegerDataStore.intValue(doubleDBIDListIter);
                            if (n3 != 0) break block6;
                            if (doubleDBIDListIter.doubleValue() > 0.0) {
                                arrayModifiableDBIDs.add(doubleDBIDListIter);
                            }
                            break block7;
                        }
                        if (n3 != 1) break block8;
                    }
                    ++n2;
                    writableIntegerDataStore.putInt(doubleDBIDListIter, -n);
                }
                doubleDBIDListIter.advance();
            }
            return n2;
        }

        protected void mergeClusterInformation(ModifiableDBIDs modifiableDBIDs, WritableIntegerDataStore writableIntegerDataStore, WritableDataStore<Assignment> writableDataStore) {
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Collecting result", modifiableDBIDs.size(), LOG) : null;
            DBIDMIter dBIDMIter = modifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                Assignment assignment;
                Assignment assignment2;
                int n = writableIntegerDataStore.intValue(dBIDMIter);
                if (n > 1) {
                    assignment2 = this.cores[n];
                    assert (((Core)assignment2).parent > 1);
                    assignment = (Assignment)writableDataStore.get(dBIDMIter);
                    if (assignment == null) {
                        writableDataStore.put(dBIDMIter, assignment2);
                    } else if (assignment instanceof Core) {
                        ((Core)assignment2).mergeWith((Core)assignment);
                    } else if (assignment instanceof Border) {
                        ((Core)assignment2).mergeWith(((Border)assignment).core);
                        writableDataStore.put(dBIDMIter, assignment2);
                    } else {
                        int n2;
                        int n3;
                        assert (assignment instanceof MultiBorder);
                        if (LOG.isDebuggingFinest()) {
                            LOG.debugFinest("Multi-Merge: " + n + " - " + assignment + " -> " + assignment2);
                        }
                        int n4 = n3 = (n3 = ((Core)assignment2).parent) < (n2 = ((MultiBorder)assignment).getCore().parent) ? n3 : n2;
                        assert (n3 > 1);
                        for (Border border : ((MultiBorder)assignment).cs) {
                            this.cores[border.core.parent].parent = n3;
                        }
                        ((Core)assignment2).parent = n3;
                        writableDataStore.put(dBIDMIter, assignment2);
                    }
                } else if (n < 0) {
                    assignment2 = this.borders[-n];
                    assignment = (Assignment)writableDataStore.get(dBIDMIter);
                    if (assignment == null) {
                        writableDataStore.put(dBIDMIter, assignment2);
                    } else if (assignment instanceof Core) {
                        ((Core)assignment).mergeWith(((Border)assignment2).core);
                    } else if (assignment instanceof Border) {
                        if (((Border)assignment).core.parent != ((Border)assignment2).core.parent) {
                            writableDataStore.put(dBIDMIter, new MultiBorder((Border)assignment, (Border)assignment2));
                        }
                    } else {
                        assert (assignment instanceof MultiBorder);
                        writableDataStore.put(dBIDMIter, ((MultiBorder)assignment).update((Border)assignment2));
                    }
                } else assert (n == 1);
                LOG.incrementProcessed(finiteProgress);
                dBIDMIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
        }
    }
}

