/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="K-Nearest Neighbor Join")
@Description(value="Algorithm to find the k-nearest neighbors of each object in a spatial database")
public class KNNJoin<V extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
extends AbstractDistanceBasedAlgorithm<V, DataStore<KNNList>> {
    private static final Logging LOG = Logging.getLogger(KNNJoin.class);
    int k;

    public KNNJoin(DistanceFunction<? super V> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n;
    }

    public WritableDataStore<KNNList> run(Relation<V> relation) {
        SpatialNode spatialNode;
        Object object;
        WritableDataStore<KNNList> writableDataStore;
        Object object2;
        Object object3;
        int n;
        if (!(this.getDistanceFunction() instanceof SpatialPrimitiveDistanceFunction)) {
            throw new IllegalStateException("Distance Function must be an instance of " + SpatialPrimitiveDistanceFunction.class.getName());
        }
        ArrayList<SpatialIndexTree> arrayList = ResultUtil.filterResults(relation.getHierarchy(), relation, SpatialIndexTree.class);
        if (arrayList.size() != 1) {
            throw new AbortException("KNNJoin found " + arrayList.size() + " spatial indexes, expected exactly one.");
        }
        SpatialIndexTree spatialIndexTree = (SpatialIndexTree)arrayList.iterator().next();
        SpatialPrimitiveDistanceFunction spatialPrimitiveDistanceFunction = (SpatialPrimitiveDistanceFunction)this.getDistanceFunction();
        DBIDs dBIDs = relation.getDBIDs();
        ArrayList arrayList2 = new ArrayList(spatialIndexTree.getLeaves());
        ArrayList<List<KNNHeap>> arrayList3 = new ArrayList<List<KNNHeap>>(arrayList2.size());
        ComparableMinHeap<Task> comparableMinHeap = new ComparableMinHeap<Task>(arrayList2.size() * arrayList2.size() / 10);
        for (n = 0; n < arrayList2.size(); ++n) {
            object3 = (SpatialEntry)arrayList2.get(n);
            SpatialNode spatialNode2 = (SpatialNode)spatialIndexTree.getNode(object3);
            arrayList3.add(this.initHeaps(spatialPrimitiveDistanceFunction, spatialNode2));
        }
        n = arrayList2.size() * (arrayList2.size() - 1) >> 1;
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Number of leaves: " + arrayList2.size() + " so " + n + " MBR computations.");
        }
        object3 = LOG.isVerbose() ? new FiniteProgress("Comparing leaf MBRs", n, LOG) : null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = (SpatialEntry)arrayList2.get(i);
            writableDataStore = (List)arrayList3.get(i);
            double d = this.computeStopDistance((List<KNNHeap>)((Object)writableDataStore));
            for (int j = i + 1; j < arrayList2.size(); ++j) {
                object = (SpatialEntry)arrayList2.get(j);
                List list = (List)arrayList3.get(j);
                double d2 = this.computeStopDistance(list);
                double d3 = spatialPrimitiveDistanceFunction.minDist((SpatialComparable)object2, (SpatialComparable)object);
                if (d3 <= 0.0) {
                    spatialNode = (SpatialNode)spatialIndexTree.getNode((Entry)arrayList2.get(i));
                    SpatialNode spatialNode3 = (SpatialNode)spatialIndexTree.getNode((Entry)arrayList2.get(j));
                    this.processDataPages(spatialPrimitiveDistanceFunction, (List<KNNHeap>)((Object)writableDataStore), list, (N)spatialNode, (N)spatialNode3);
                } else if (d3 <= d || d3 <= d2) {
                    comparableMinHeap.add(new Task(d3, i, j));
                }
                LOG.incrementProcessed((AbstractProgress)object3);
            }
        }
        LOG.ensureCompleted((FiniteProgress)object3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing queue", comparableMinHeap.size(), LOG) : null;
        Object object4 = object2 = LOG.isVerbose() ? new IndefiniteProgress("Full comparisons", LOG) : null;
        while (!comparableMinHeap.isEmpty()) {
            boolean bl;
            writableDataStore = (Task)comparableMinHeap.poll();
            List list = (List)arrayList3.get(((Task)((Object)writableDataStore)).i);
            List list2 = (List)arrayList3.get(((Task)((Object)writableDataStore)).j);
            double d = this.computeStopDistance(list);
            double d4 = this.computeStopDistance(list2);
            boolean bl2 = ((Task)((Object)writableDataStore)).mindist <= d;
            boolean bl3 = bl = ((Task)((Object)writableDataStore)).mindist <= d4;
            if (bl2 || bl) {
                SpatialNode spatialNode4 = (SpatialNode)spatialIndexTree.getNode((Entry)arrayList2.get(((Task)((Object)writableDataStore)).i));
                spatialNode = (SpatialNode)spatialIndexTree.getNode((Entry)arrayList2.get(((Task)((Object)writableDataStore)).j));
                if (bl2 && bl) {
                    this.processDataPages(spatialPrimitiveDistanceFunction, list, list2, spatialNode4, spatialNode);
                } else if (bl2) {
                    this.processDataPages(spatialPrimitiveDistanceFunction, list, null, spatialNode4, spatialNode);
                } else {
                    this.processDataPages(spatialPrimitiveDistanceFunction, list2, null, spatialNode, spatialNode4);
                }
                LOG.incrementProcessed((AbstractProgress)object2);
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.setCompleted((IndefiniteProgress)object2);
        writableDataStore = DataStoreUtil.makeStorage(dBIDs, 4, KNNList.class);
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Number of processed data pages", arrayList2.size(), LOG) : null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SpatialNode spatialNode5 = (SpatialNode)spatialIndexTree.getNode((Entry)arrayList2.get(i));
            object = (List)arrayList3.get(i);
            for (int j = 0; j < spatialNode5.getNumEntries(); ++j) {
                writableDataStore.put(((LeafEntry)spatialNode5.getEntry(j)).getDBID(), ((KNNHeap)object.get(j)).toKNNList());
            }
            arrayList3.set(i, null);
            LOG.incrementProcessed(finiteProgress2);
        }
        LOG.ensureCompleted(finiteProgress2);
        return writableDataStore;
    }

    private List<KNNHeap> initHeaps(SpatialPrimitiveDistanceFunction<V> spatialPrimitiveDistanceFunction, N n) {
        ArrayList<KNNHeap> arrayList = new ArrayList<KNNHeap>(n.getNumEntries());
        for (int i = 0; i < n.getNumEntries(); ++i) {
            arrayList.add(DBIDUtil.newHeap(this.k));
        }
        this.processDataPages(spatialPrimitiveDistanceFunction, arrayList, null, n, n);
        return arrayList;
    }

    private void processDataPages(SpatialPrimitiveDistanceFunction<? super V> spatialPrimitiveDistanceFunction, List<KNNHeap> list, List<KNNHeap> list2, N n, N n2) {
        for (int i = 0; i < n2.getNumEntries(); ++i) {
            SpatialPointLeafEntry spatialPointLeafEntry = (SpatialPointLeafEntry)n2.getEntry(i);
            DBID dBID = spatialPointLeafEntry.getDBID();
            for (int j = 0; j < n.getNumEntries(); ++j) {
                SpatialPointLeafEntry spatialPointLeafEntry2 = (SpatialPointLeafEntry)n.getEntry(j);
                double d = spatialPrimitiveDistanceFunction.minDist(spatialPointLeafEntry, spatialPointLeafEntry2);
                list.get(j).insert(d, dBID);
                if (n == n2 || list2 == null) continue;
                list2.get(i).insert(d, spatialPointLeafEntry2.getDBID());
            }
        }
    }

    private double computeStopDistance(List<KNNHeap> list) {
        double d = Double.NaN;
        for (KNNHeap kNNHeap : list) {
            double d2 = kNNHeap.getKNNDistance();
            d = d2 < d ? d : d2;
        }
        if (d != d) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("knnjoin.k", "Specifies the k-nearest neighbors to be assigned.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID, 1);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected KNNJoin<V, N, E> makeInstance() {
            return new KNNJoin(this.distanceFunction, this.k);
        }
    }

    private class Task
    implements Comparable<Task> {
        final double mindist;
        final int i;
        final int j;

        public Task(double d, int n, int n2) {
            this.mindist = d;
            this.i = n;
            this.j = n2;
        }

        @Override
        public int compareTo(Task task) {
            return Double.compare(this.mindist, task.mindist);
        }
    }
}

