/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Arrays;

@Title(value="KNN-Distance-Order")
@Description(value="Assesses the knn distances for a specified k and orders them.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.KNNDistanceOrder"})
public class KNNDistancesSampler<O>
extends AbstractDistanceBasedAlgorithm<O, KNNDistanceOrderResult> {
    private static final Logging LOG = Logging.getLogger(KNNDistancesSampler.class);
    protected int k;
    protected double sample;
    private RandomFactory rnd;

    public KNNDistancesSampler(DistanceFunction<? super O> distanceFunction, int n, double d, RandomFactory randomFactory) {
        super(distanceFunction);
        this.k = n;
        this.sample = d;
        this.rnd = randomFactory;
    }

    public KNNDistanceOrderResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        int n = (int)(this.sample <= 1.0 ? Math.ceil((double)relation.size() * this.sample) : this.sample);
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), n, this.rnd);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Sampling kNN distances", n, LOG) : null;
        double[] dArray = new double[n];
        int n2 = 0;
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k + 1);
            dArray[n2] = kNNList.getKNNDistance();
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
            ++n2;
        }
        LOG.ensureCompleted(finiteProgress);
        return new KNNDistanceOrderResult(dArray, this.k);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knndistanceorder.k", "Specifies the distance of the k-distant object to be assessed, ignoring the query object.");
        public static final OptionID SAMPLING_ID = new OptionID("knndistanceorder.sample", "The percentage of objects to use for sampling, or the absolute number of samples.");
        public static final OptionID SEED_ID = new OptionID("knndistanceorder.seed", "Random generator seed for sampling.");
        protected int k;
        protected double percentage;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(SAMPLING_ID, 1.0).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.percentage = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected KNNDistancesSampler<O> makeInstance() {
            return new KNNDistancesSampler(this.distanceFunction, this.k, this.percentage, this.rnd);
        }
    }

    public static class KNNDistanceOrderResult
    extends XYCurve {
        private int k;

        public KNNDistanceOrderResult(double[] dArray, int n) {
            super("Objects", n + "-NN-distance", dArray.length + 1);
            this.k = n;
            Arrays.sort(dArray);
            for (int i = 0; i < dArray.length; ++i) {
                this.addAndSimplify(dArray.length - i, dArray[i]);
            }
        }

        @Override
        public String getLongName() {
            return this.k + "-NN distance order";
        }

        @Override
        public String getShortName() {
            return this.k + "-NNDistanceOrder";
        }
    }
}

