/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.netty.NettyApplicationEngineKt;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.util.DispatcherWithShutdown;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001:B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u00020\u0007H\u0002J\b\u00108\u001a\u000209H\u0016R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001c\u0010\u0014R\u001b\u0010\u001e\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0010\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0010\u001a\u0004\b$\u0010%R\u001b\u0010'\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b(\u0010%R\u001b\u0010*\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0010\u001a\u0004\b+\u0010\u0014\u00a8\u0006;"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "bootstraps", "", "Lio/netty/bootstrap/ServerBootstrap;", "getBootstraps$ktor_server_netty", "()Ljava/util/List;", "bootstraps$delegate", "Lkotlin/Lazy;", "callEventGroup", "Lio/netty/channel/EventLoopGroup;", "getCallEventGroup", "()Lio/netty/channel/EventLoopGroup;", "callEventGroup$delegate", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "channels", "Lio/netty/channel/Channel;", "configuration", "connectionEventGroup", "getConnectionEventGroup", "connectionEventGroup$delegate", "customBootstrap", "getCustomBootstrap", "()Lio/netty/bootstrap/ServerBootstrap;", "customBootstrap$delegate", "dispatcherWithShutdown", "Lio/ktor/util/DispatcherWithShutdown;", "getDispatcherWithShutdown", "()Lio/ktor/util/DispatcherWithShutdown;", "dispatcherWithShutdown$delegate", "engineDispatcherWithShutdown", "getEngineDispatcherWithShutdown", "engineDispatcherWithShutdown$delegate", "workerEventGroup", "getWorkerEventGroup", "workerEventGroup$delegate", "createBootstrap", "connector", "Lio/ktor/server/engine/EngineConnectorConfig;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "terminate", "toString", "", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Lazy connectionEventGroup$delegate;
    @NotNull
    private final Lazy workerEventGroup$delegate;
    @NotNull
    private final Lazy customBootstrap$delegate;
    @NotNull
    private final Lazy callEventGroup$delegate;
    @NotNull
    private final Lazy dispatcherWithShutdown$delegate;
    @NotNull
    private final Lazy engineDispatcherWithShutdown$delegate;
    @Nullable
    private CompletableJob cancellationDeferred;
    @Nullable
    private List<? extends Channel> channels;
    @NotNull
    private final Lazy bootstraps$delegate;

    public NettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration = new Configuration();
        configure.invoke((Object)configuration);
        this.configuration = configuration;
        this.connectionEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap(this.this$0).config().group();
                if (eventLoopGroup == null) {
                    eventLoopGroup = EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConnectionGroupSize());
                }
                return eventLoopGroup;
            }
        }));
        this.workerEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroupProxy defaultGroup = NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize() + NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize()) : EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize());
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap(this.this$0).config().childGroup();
                if (eventLoopGroup == null) {
                    eventLoopGroup = defaultGroup;
                }
                return eventLoopGroup;
            }
        }));
        this.customBootstrap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServerBootstrap>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ServerBootstrap invoke() {
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConfigureBootstrap().invoke((Object)serverBootstrap);
                return serverBootstrap;
            }
        }));
        this.callEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                return NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? NettyApplicationEngine.access$getWorkerEventGroup(this.this$0) : (EventLoopGroup)EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize());
            }
        }));
        this.dispatcherWithShutdown$delegate = LazyKt.lazy((Function0)dispatcherWithShutdown.2.INSTANCE);
        this.engineDispatcherWithShutdown$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DispatcherWithShutdown>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DispatcherWithShutdown invoke() {
                return new DispatcherWithShutdown((CoroutineDispatcher)ExecutorsKt.from((ExecutorService)((ExecutorService)NettyApplicationEngine.access$getWorkerEventGroup(this.this$0))));
            }
        }));
        this.bootstraps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ServerBootstrap>>(environment, this){
            final /* synthetic */ ApplicationEngineEnvironment $environment;
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.$environment = $environment;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ServerBootstrap> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$environment.getConnectors();
                NettyApplicationEngine nettyApplicationEngine = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(NettyApplicationEngine.access$createBootstrap(nettyApplicationEngine, (EngineConnectorConfig)p0));
                }
                return (List)destination$iv$iv;
            }
        }));
        PipelinePhase afterCall = new PipelinePhase("After");
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), afterCall);
        this.getPipeline().intercept(afterCall, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PipelineContext $this$intercept;
                        ResultKt.throwOnFailure((Object)object);
                        PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                        boolean $i$f$getCall = false;
                        ApplicationCall applicationCall = (ApplicationCall)$this$call$iv.getContext();
                        NettyApplicationCall nettyApplicationCall = applicationCall instanceof NettyApplicationCall ? (NettyApplicationCall)applicationCall : null;
                        if (nettyApplicationCall == null) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = nettyApplicationCall.finish$ktor_server_netty((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ NettyApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(applicationEngineEnvironment, (Function1<? super Configuration, Unit>)function1);
    }

    private final EventLoopGroup getConnectionEventGroup() {
        Lazy lazy = this.connectionEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final EventLoopGroup getWorkerEventGroup() {
        Lazy lazy = this.workerEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ServerBootstrap getCustomBootstrap() {
        Lazy lazy = this.customBootstrap$delegate;
        return (ServerBootstrap)lazy.getValue();
    }

    private final EventLoopGroup getCallEventGroup() {
        Lazy lazy = this.callEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final DispatcherWithShutdown getDispatcherWithShutdown() {
        Lazy lazy = this.dispatcherWithShutdown$delegate;
        return (DispatcherWithShutdown)lazy.getValue();
    }

    private final DispatcherWithShutdown getEngineDispatcherWithShutdown() {
        Lazy lazy = this.engineDispatcherWithShutdown$delegate;
        return (DispatcherWithShutdown)lazy.getValue();
    }

    @NotNull
    public final List<ServerBootstrap> getBootstraps$ktor_server_netty() {
        Lazy lazy = this.bootstraps$delegate;
        return (List)lazy.getValue();
    }

    private final ServerBootstrap createBootstrap(EngineConnectorConfig connector) {
        ServerBootstrap serverBootstrap;
        ServerBootstrap $this$createBootstrap_u24lambda_u2d0 = serverBootstrap = this.getCustomBootstrap().clone();
        boolean bl = false;
        if ($this$createBootstrap_u24lambda_u2d0.config().group() == null && $this$createBootstrap_u24lambda_u2d0.config().childGroup() == null) {
            $this$createBootstrap_u24lambda_u2d0.group(this.getConnectionEventGroup(), this.getWorkerEventGroup());
        }
        if ($this$createBootstrap_u24lambda_u2d0.config().channelFactory() == null) {
            $this$createBootstrap_u24lambda_u2d0.channel(JvmClassMappingKt.getJavaClass((KClass)NettyApplicationEngineKt.access$getChannelClass()));
        }
        $this$createBootstrap_u24lambda_u2d0.childHandler((ChannelHandler)new NettyChannelInitializer(this.getPipeline(), this.getEnvironment(), (EventExecutorGroup)this.getCallEventGroup(), (CoroutineContext)this.getEngineDispatcherWithShutdown(), this.getEnvironment().getParentCoroutineContext().plus((CoroutineContext)this.getDispatcherWithShutdown()), connector, this.configuration.getRequestQueueLimit(), this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec()));
        if (this.configuration.getTcpKeepAlive()) {
            $this$createBootstrap_u24lambda_u2d0.option(NioChannelOption.SO_KEEPALIVE, (Object)true);
        }
        ServerBootstrap serverBootstrap2 = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue((Object)serverBootstrap2, (String)"customBootstrap.clone().\u2026)\n            }\n        }");
        return serverBootstrap2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        Object object;
        this.getEnvironment().start();
        try {
            ChannelFuture it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)this.getBootstraps$ktor_server_netty(), (Iterable)this.getEnvironment().getConnectors());
            object = this;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((ServerBootstrap)it.getFirst()).bind(((EngineConnectorConfig)it.getSecond()).getHost(), ((EngineConnectorConfig)it.getSecond()).getPort()));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ChannelFuture)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.sync().channel());
            }
            ((NettyApplicationEngine)((Object)object)).channels = (List)destination$iv$iv;
        }
        catch (BindException cause) {
            this.terminate();
            throw cause;
        }
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this));
        if (wait) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Channel channel = (Channel)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(it.closeFuture());
                }
                List list2 = (List)destination$iv$iv;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ChannelFuture it = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it.sync();
                }
            }
            ApplicationEngineJvmKt.stop((ApplicationEngine)((ApplicationEngine)this), (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    private final void terminate() {
        this.getConnectionEventGroup().shutdownGracefully().sync();
        this.getWorkerEventGroup().shutdownGracefully().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        List list;
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        List<? extends Channel> list2 = this.channels;
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChannelFuture it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if ((it.isOpen() ? it.close() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list == null) {
            list3 = CollectionsKt.emptyList();
        }
        List channelFutures = list3;
        this.getDispatcherWithShutdown().prepareShutdown();
        this.getEngineDispatcherWithShutdown().prepareShutdown();
        try {
            Future shutdownConnections = this.getConnectionEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            shutdownConnections.await();
            Future shutdownWorkers = this.getWorkerEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                shutdownWorkers.await();
            } else {
                Future shutdownCall = this.getCallEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
                shutdownWorkers.await();
                shutdownCall.await();
            }
            this.getEnvironment().stop();
        }
        finally {
            this.getDispatcherWithShutdown().completeShutdown();
            this.getEngineDispatcherWithShutdown().completeShutdown();
            Iterable $this$forEach$iv = channelFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    public static final /* synthetic */ ServerBootstrap access$getCustomBootstrap(NettyApplicationEngine $this) {
        return $this.getCustomBootstrap();
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(NettyApplicationEngine $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ EventLoopGroup access$getWorkerEventGroup(NettyApplicationEngine $this) {
        return $this.getWorkerEventGroup();
    }

    public static final /* synthetic */ ServerBootstrap access$createBootstrap(NettyApplicationEngine $this, EngineConnectorConfig connector) {
        return $this.createBootstrap(connector);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'\u00a8\u0006+"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureBootstrap", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "requestQueueLimit", "", "getRequestQueueLimit", "()I", "setRequestQueueLimit", "(I)V", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "runningLimit", "getRunningLimit", "setRunningLimit", "shareWorkGroup", "", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "tcpKeepAlive", "getTcpKeepAlive", "setTcpKeepAlive", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int requestQueueLimit = 16;
        private int runningLimit = 10;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = configureBootstrap.1.INSTANCE;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        private boolean tcpKeepAlive;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = httpServerCodec.1.INSTANCE;

        public final int getRequestQueueLimit() {
            return this.requestQueueLimit;
        }

        public final void setRequestQueueLimit(int n) {
            this.requestQueueLimit = n;
        }

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n) {
            this.requestReadTimeoutSeconds = n;
        }

        public final boolean getTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public final void setTcpKeepAlive(boolean bl) {
            this.tcpKeepAlive = bl;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
            this.httpServerCodec = function0;
        }
    }
}

