/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.voxq;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.voxq.QuadraticQFunction;

public class IntraVoxelSampler {
    MoleculeModifierAndScorer mms;
    int numDOFs;
    private static final int numBurnInSamples = 5;
    private static final int thinningFactor = 5;
    public static final double RT = 0.593050165;
    double numDrawn = 0.0;
    double numAccepted = 0.0;

    public IntraVoxelSampler(MoleculeModifierAndScorer mms) {
        this.mms = mms;
        this.numDOFs = mms.getNumDOFs();
        CCDMinimizer ccdMin = new CCDMinimizer(mms, false);
        ccdMin.minimize();
        this.burnIn();
    }

    private void burnIn() {
        for (int samp = 0; samp < 5; ++samp) {
            this.nextSample();
        }
    }

    public DoubleMatrix1D nextSample() {
        for (int step = 0; step < 5; ++step) {
            for (int dof = 0; dof < this.numDOFs; ++dof) {
                boolean accepted;
                while (!(accepted = this.doMetropolisStep(dof))) {
                }
            }
        }
        return this.getCurDOFVals();
    }

    DoubleMatrix1D getCurDOFVals() {
        DoubleMatrix1D ans = DoubleFactory1D.dense.make(this.numDOFs);
        for (int dof = 0; dof < this.numDOFs; ++dof) {
            ans.set(dof, this.mms.getCurValueOfDOF(dof));
        }
        return ans;
    }

    private boolean doMetropolisStep(int dof) {
        double origDOFVal = this.mms.getCurValueOfDOF(dof);
        QuadraticQFunction bluggles = new QuadraticQFunction(this.mms, dof, origDOFVal);
        double newDOFVal = bluggles.drawDOFValue();
        double Ediff = this.mms.getValForDOF(dof, newDOFVal) - this.mms.getValForDOF(dof, origDOFVal);
        double Prat = Math.exp(-Ediff / 0.593050165);
        QuadraticQFunction q2 = new QuadraticQFunction(this.mms, dof, newDOFVal);
        double Qrat = bluggles.evalQ(newDOFVal) / q2.evalQ(origDOFVal);
        double metropolisRatio = Prat / Qrat;
        boolean accepted = true;
        if (metropolisRatio < 1.0) {
            boolean bl = accepted = metropolisRatio > Math.random();
        }
        if (accepted) {
            this.mms.setDOF(dof, newDOFVal);
            this.numAccepted += 1.0;
        } else {
            this.mms.setDOF(dof, origDOFVal);
        }
        this.numDrawn += 1.0;
        return accepted;
    }

    void printMolec(String PDBName) {
        System.out.println("DOF VALS BEING WRITTEN TO " + PDBName + ": " + String.valueOf(this.getCurDOFVals()));
        PDBIO.writeFile(this.mms.getMolec(), PDBName);
    }
}

