/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.tupexp.TupleExpander;
import java.util.ArrayList;

public class TupExpChooser {
    TupleExpander expander;
    TupleEnumerator tupEnum;

    public TupExpChooser(TupleExpander expander, TupleEnumerator tupEnum) {
        this.expander = expander;
        this.tupEnum = tupEnum;
    }

    public double calcPairwiseExpansion() {
        ArrayList<RCTuple> pairList = this.tupEnum.enumerateUnprunedTuples(2);
        if (pairList.isEmpty()) {
            pairList.addAll(this.tupEnum.enumerateUnprunedTuples(1));
        }
        return this.expander.calcExpansion(pairList);
    }

    public void calcExpansionCliqueTriples(double numTupFactor) {
        int numTriplesPerType = (int)(numTupFactor * (double)this.expander.tuples.size() / 2.0);
        ArrayList tupList = (ArrayList)this.expander.tuples.clone();
        ArrayList<RCTuple> topTriples = this.tupEnum.clique2PairTriples(numTriplesPerType);
        tupList.addAll(topTriples);
        this.expander.calcExpansion(tupList);
    }

    public double calcExpansionResTriples(int numPartners) {
        if (this.tupEnum.getEmat() == null) {
            this.tupEnum.setEmat(this.expander.getEnergyMatrix());
        }
        ArrayList tupList = (ArrayList)this.expander.tuples.clone();
        ArrayList<ArrayList<Integer>> topPositionTriples = this.tupEnum.topPositionTriples(numPartners);
        ArrayList<RCTuple> topTriples = this.tupEnum.enumerateUnprunedTuples(topPositionTriples);
        tupList.addAll(topTriples);
        return this.expander.calcExpansion(tupList);
    }
}

