/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.tupexp.FittingObjFcn;
import edu.duke.cs.osprey.tupexp.TupleExpander;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public class TESampleSet
implements Serializable {
    ArrayList<int[]> samples = new ArrayList();
    ArrayList<Double> trueVals = new ArrayList();
    ArrayList<Double> curFitVals = new ArrayList();
    ArrayList<Integer> tupleNumSamples = new ArrayList();
    ArrayList<Double> tupleResids = new ArrayList();
    double totalResid = 0.0;
    double worstResid = 0.0;
    ArrayList<Double> sampleResids = new ArrayList();
    int numTuplesDone;
    boolean[] tuplesDone;
    TupleExpander te;

    public TESampleSet(TupleExpander te) {
        this.te = te;
        for (RCTuple tup : te.tuples) {
            this.tupleNumSamples.add(0);
            this.tupleResids.add(0.0);
        }
        for (int tup = 0; tup < te.tuples.size(); ++tup) {
            if (tup > 0) {
                if (tup % TupleExpander.printedUpdateNumTuples == 0) {
                    System.out.println(tup + " tuples done");
                }
            }
            this.updateSamples(tup);
        }
    }

    void updateSamples(int tup) {
        int numSampsNeeded = this.te.numSamplesNeeded(tup) - this.tupleNumSamples.get(tup);
        for (int s = 0; s < numSampsNeeded; ++s) {
            int[] sample = this.drawUnprunedSample(this.te.tuples.get(tup), true);
            if (!this.isNewSampleDistinct(sample)) continue;
            double trueVal = this.te.scoreAssignmentList(sample);
            ArrayList<Integer> sampTuples = this.calcSampleTuples(sample);
            sampTuples.trimToSize();
            this.samples.add(sample);
            for (int term : sampTuples) {
                this.tupleNumSamples.set(term, this.tupleNumSamples.get(term) + 1);
            }
            this.trueVals.add(trueVal);
            this.curFitVals.add(0.0);
        }
    }

    boolean isNewSampleDistinct(int[] sample) {
        for (int sampNum2 = 0; sampNum2 < this.samples.size(); ++sampNum2) {
            int[] sample2 = this.samples.get(sampNum2);
            boolean samplesIdentical = true;
            for (int pos = 0; pos < this.te.numPos; ++pos) {
                if (sample[pos] == sample2[pos]) continue;
                samplesIdentical = false;
                break;
            }
            if (!samplesIdentical) continue;
            return false;
        }
        return true;
    }

    boolean tupleFeasible(RCTuple tup) {
        int[] sample = this.drawUnprunedSample(tup, false);
        return sample != null;
    }

    boolean finishSample(int[] sample) {
        while (true) {
            int nextPos;
            if ((nextPos = this.getRandomUnfilledPos(sample)) == -1) {
                return true;
            }
            int[] distr = new int[this.te.numAllowed[nextPos]];
            boolean haveOptions = false;
            for (int a = 0; a < this.te.numAllowed[nextPos]; ++a) {
                distr[a] = 1;
                if (this.te.canCheckPartialPruning) {
                    if (this.te.isPruned(new RCTuple(nextPos, a))) {
                        distr[a] = 0;
                    }
                    for (int pos = 0; pos < this.te.numPos; ++pos) {
                        if (sample[pos] == -1 || !this.isPairPrunedInSample(pos, sample[pos], nextPos, a, sample)) continue;
                        distr[a] = 0;
                        break;
                    }
                } else {
                    int[] augSamp = (int[])sample.clone();
                    augSamp[nextPos] = a;
                    if (this.te.isPruned(new RCTuple(augSamp))) {
                        distr[a] = 0;
                    }
                }
                if (distr[a] != 1) continue;
                haveOptions = true;
            }
            if (!haveOptions) break;
            sample[nextPos] = TESampleSet.discreteDraw(distr);
        }
        return false;
    }

    int getRandomUnfilledPos(int[] sample) {
        int[] distr = new int[this.te.numPos];
        boolean haveOptions = false;
        for (int pos = 0; pos < this.te.numPos; ++pos) {
            if (sample[pos] != -1) continue;
            distr[pos] = 1;
            haveOptions = true;
        }
        if (haveOptions) {
            return TESampleSet.discreteDraw(distr);
        }
        return -1;
    }

    static int discreteDraw(int[] distr) {
        int tot = 0;
        for (int a : distr) {
            tot += a;
        }
        int randVal = new Random().nextInt(tot);
        int cumSum = 0;
        for (int ans = 0; ans < distr.length; ++ans) {
            if ((cumSum += distr[ans]) <= randVal) continue;
            return ans;
        }
        throw new RuntimeException("ERROR: shouldn't get to end of discreteDraw!!!");
    }

    ArrayList<Integer> calcSampleTuples(int[] sample) {
        ArrayList<Integer> sampTuples = new ArrayList<Integer>();
        for (int tup = 0; tup < this.te.tuples.size(); ++tup) {
            if (!this.te.sampleMatchesTuple(sample, this.te.tuples.get(tup))) continue;
            sampTuples.add(tup);
        }
        return sampTuples;
    }

    void updateFitVals(FittingObjFcn fof) {
        for (int s = 0; s < this.samples.size(); ++s) {
            this.curFitVals.set(s, this.te.fitValueForTuples(this.calcSampleTuples(this.samples.get(s))));
        }
        this.updateAllResids(fof);
    }

    void updateAllResids(FittingObjFcn fof) {
        int t;
        this.totalResid = 0.0;
        for (t = 0; t < this.te.tuples.size(); ++t) {
            this.tupleResids.set(t, 0.0);
        }
        this.sampleResids = fof.computeAllResids(this.trueVals, this.curFitVals, this.te.constTerm);
        for (int s = 0; s < this.samples.size(); ++s) {
            double sampResid = this.sampleResids.get(s);
            this.totalResid += sampResid;
            for (int tup : this.calcSampleTuples(this.samples.get(s))) {
                this.tupleResids.set(tup, this.tupleResids.get(tup) + sampResid);
            }
        }
        this.totalResid /= (double)this.samples.size();
        this.worstResid = 0.0;
        for (t = 0; t < this.te.tuples.size(); ++t) {
            this.tupleResids.set(t, this.tupleResids.get(t) / (double)this.tupleNumSamples.get(t).intValue());
            this.worstResid = Math.max(this.worstResid, this.tupleResids.get(t));
        }
    }

    void addTuple(int tup) {
        this.tupleNumSamples.add(0);
        for (int s = 0; s < this.samples.size(); ++s) {
            int[] sample = this.samples.get(s);
            if (!this.te.sampleMatchesTuple(sample, this.te.tuples.get(tup))) continue;
            this.tupleNumSamples.set(tup, this.tupleNumSamples.get(tup) + 1);
        }
        this.tupleResids.add(0.0);
        this.updateSamples(tup);
    }

    void printResids() {
        System.out.println(this.samples.size() + " samples");
        System.out.println("Total resid: " + this.totalResid + " Worst resid: " + this.worstResid);
    }

    int[] drawUnprunedSample(RCTuple tup, boolean errorIfImpossible) {
        long sampTime;
        int[] sample = new int[this.te.numPos];
        long startTime = System.currentTimeMillis();
        for (int tryNum = 0; tryNum < 5; ++tryNum) {
            Arrays.fill(sample, -1);
            this.te.assignTupleInSample(sample, tup);
            boolean finishSampleSuccessful = this.finishSample(sample);
            sampTime = System.currentTimeMillis() - startTime;
            if (sampTime > 10000L) {
                System.out.println();
                System.out.println("finishSample sampling took over 10 s (ms shown): " + sampTime);
                System.out.println("Target tuple: " + tup.stringListing());
                System.out.println("tryNum: " + tryNum);
                if (finishSampleSuccessful) {
                    System.out.println("Sample: " + new RCTuple(sample).stringListing());
                } else {
                    System.out.println("No sample found yet.");
                }
                System.out.println();
            }
            if (!finishSampleSuccessful) continue;
            return sample;
        }
        Arrays.fill(sample, -1);
        this.te.assignTupleInSample(sample, tup);
        long sampStartTime = System.currentTimeMillis();
        sample = this.finishSampleDFS(sample);
        sampTime = System.currentTimeMillis() - sampStartTime;
        if (sampTime > 10000L) {
            System.out.println();
            System.out.println("Sampling took over 10 s (ms shown): " + sampTime);
            System.out.println("Target tuple: " + tup.stringListing());
            if (sample != null) {
                System.out.println("Sample: " + new RCTuple(sample).stringListing());
            } else {
                System.out.println("No sample found.");
            }
            System.out.println();
        }
        if (errorIfImpossible && sample == null) {
            throw new RuntimeException("ERROR: No unpruned samples available for tuple " + tup.stringListing());
        }
        return sample;
    }

    int[] finishSampleDFS(int[] sample) {
        ArrayList<ArrayList<int[]>> allowedRCs = new ArrayList<ArrayList<int[]>>();
        ArrayList<Integer> numElim = new ArrayList<Integer>();
        this.listCompatibleRCs(allowedRCs, numElim, sample);
        boolean tuplePossible = true;
        for (int pos = 0; pos < this.te.numPos; ++pos) {
            if (sample[pos] != -1 || !allowedRCs.get(pos).isEmpty()) continue;
            tuplePossible = false;
            break;
        }
        if (tuplePossible) {
            tuplePossible = this.unprunedSampDFS(sample, allowedRCs, numElim);
        }
        if (tuplePossible) {
            return sample;
        }
        return null;
    }

    boolean unprunedSampDFS(int[] sample, ArrayList<ArrayList<int[]>> allowedRCs, ArrayList<Integer> numElim) {
        int nextPos = -1;
        double nextPosElimRatio = -1.0;
        for (int pos = 0; pos < this.te.numPos; ++pos) {
            double elimRatio;
            if (sample[pos] != -1 || !((elimRatio = 1.0 * (double)numElim.get(pos).intValue() / (double)allowedRCs.get(pos).size()) > nextPosElimRatio)) continue;
            nextPos = pos;
            nextPosElimRatio = elimRatio;
        }
        if (nextPos == -1) {
            return true;
        }
        ArrayList<Integer> newOptions = TESampleSet.shuffleOptions(allowedRCs.get(nextPos));
        Iterator<Integer> iterator2 = newOptions.iterator();
        while (iterator2.hasNext()) {
            int opt;
            sample[nextPos] = opt = iterator2.next().intValue();
            ArrayList<int[]> elimHere = new ArrayList<int[]>();
            for (int pos = 0; pos < this.te.numPos; ++pos) {
                if (sample[pos] != -1) continue;
                for (int q = allowedRCs.get(pos).size() - 1; q >= 0; --q) {
                    boolean pruned;
                    int[] uaOpt = allowedRCs.get(pos).get(q);
                    if (this.te.canCheckPartialPruning) {
                        pruned = this.isPairPrunedInSample(nextPos, opt, uaOpt[0], uaOpt[1], sample);
                    } else {
                        int[] augSamp = (int[])sample.clone();
                        augSamp[uaOpt[0]] = uaOpt[1];
                        pruned = this.te.isPruned(new RCTuple(augSamp));
                    }
                    if (!pruned) continue;
                    elimHere.add(uaOpt);
                    allowedRCs.get(pos).remove(q);
                    numElim.set(pos, numElim.get(pos) + 1);
                }
            }
            boolean success = this.unprunedSampDFS(sample, allowedRCs, numElim);
            if (success) {
                return true;
            }
            for (int[] uaOpt : elimHere) {
                allowedRCs.get(uaOpt[0]).add(uaOpt);
                numElim.set(uaOpt[0], numElim.get(uaOpt[0]) - 1);
            }
        }
        sample[nextPos] = -1;
        return false;
    }

    private void listCompatibleRCs(ArrayList<ArrayList<int[]>> allowedRCs, ArrayList<Integer> numElim, int[] sample) {
        for (int pos = 0; pos < this.te.numPos; ++pos) {
            ArrayList<int[]> forPos = new ArrayList<int[]>();
            int numElimAtPos = 0;
            if (sample[pos] == -1) {
                for (int rc = 0; rc < this.te.numAllowed[pos]; ++rc) {
                    if (this.te.isPruned(new RCTuple(pos, rc))) continue;
                    boolean incompatible = false;
                    if (this.te.canCheckPartialPruning) {
                        for (int pos2 = 0; pos2 < this.te.numPos; ++pos2) {
                            if (sample[pos2] == -1 || !this.isPairPrunedInSample(pos2, sample[pos2], pos, rc, sample)) continue;
                            incompatible = true;
                            break;
                        }
                    } else {
                        int[] augSamp = (int[])sample.clone();
                        augSamp[pos] = rc;
                        incompatible = this.te.isPruned(new RCTuple(augSamp));
                    }
                    if (incompatible) {
                        ++numElimAtPos;
                        continue;
                    }
                    forPos.add(new int[]{pos, rc});
                }
            }
            allowedRCs.add(forPos);
            numElim.add(numElimAtPos);
        }
    }

    static ArrayList<Integer> shuffleOptions(ArrayList<int[]> optList) {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        int numRCs = optList.size();
        ArrayList<Integer> ordering = TESampleSet.randomOrdering(numRCs);
        for (int a = 0; a < numRCs; ++a) {
            ans.add(optList.get(ordering.get(a))[1]);
        }
        return ans;
    }

    static ArrayList<Integer> randomOrdering(int n) {
        int b;
        ArrayList<Integer> a = new ArrayList<Integer>();
        ArrayList<Integer> ans = new ArrayList<Integer>();
        Random rand = new Random();
        for (b = 0; b < n; ++b) {
            a.add(b);
        }
        for (b = 0; b < n; ++b) {
            ans.add((Integer)a.remove(rand.nextInt(n - b)));
        }
        return ans;
    }

    boolean isPairPrunedInSample(int pos1, int rc1, int pos2, int rc2, int[] sample) {
        RCTuple pair = new RCTuple(pos1, rc1, pos2, rc2);
        if (this.te.isPruned(pair)) {
            return true;
        }
        for (RCTuple prunedTup : this.te.higherOrderPrunedTuples(pair)) {
            sample[pos2] = rc2;
            boolean pruned = this.te.sampleMatchesTuple(sample, prunedTup);
            sample[pos2] = -1;
            if (!pruned) continue;
            return true;
        }
        return false;
    }
}

