/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import edu.duke.cs.osprey.tupexp.TupleExpander;
import java.util.ArrayList;

public class NewConfETupleExpander
extends TupleExpander {
    ConfEnergyCalculator confECalc;
    PruningMatrix pruneMat;

    public NewConfETupleExpander(SimpleConfSpace confSpace, double pruningInterval, LUTESettings luteSettings, ConfEnergyCalculator confECalc, PruningMatrix pruneMat) {
        super(confSpace.getNumPos(), confSpace.getNumResConfsByPos(), pruningInterval, luteSettings);
        this.confECalc = confECalc;
        this.pruneMat = pruneMat;
    }

    @Override
    double scoreAssignmentList(int[] assignmentList) {
        RCTuple tup = new RCTuple(assignmentList);
        double E = this.confECalc.calcEnergy((RCTuple)tup).energy;
        if (E == Double.POSITIVE_INFINITY) {
            if (this.isPruned(tup)) {
                throw new RuntimeException("ERROR: Scoring pruned conformation: " + tup.stringListing());
            }
            throw new RuntimeException("ERROR: Infinite E for unpruned conf: " + tup.stringListing());
        }
        return E;
    }

    @Override
    boolean isPruned(RCTuple tup) {
        return this.pruneMat.isPruned(tup);
    }

    @Override
    void pruneTuple(RCTuple tup) {
        this.pruneMat.markAsPruned(tup);
    }

    @Override
    ArrayList<RCTuple> higherOrderPrunedTuples(RCTuple tup) {
        if (tup.pos.size() != 2) {
            throw new RuntimeException("ERROR: higherOrderPrunedTuples is meant to take an RC pair as argument");
        }
        HigherTupleFinder<Boolean> htf = this.pruneMat.getHigherOrderTerms(tup.pos.get(0), tup.RCs.get(0), tup.pos.get(1), tup.RCs.get(1));
        if (htf != null) {
            ArrayList<RCTuple> otherTups = htf.listInteractionsWithValue(true);
            for (RCTuple otherTup : otherTups) {
                for (int i = 0; i < 2; ++i) {
                    otherTup.pos.add(tup.pos.get(i));
                    otherTup.RCs.add(tup.RCs.get(i));
                }
            }
            return otherTups;
        }
        return new ArrayList<RCTuple>();
    }
}

