/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.tupexp.TupleExpander;
import java.util.ArrayList;

public class ConfETupleExpander
extends TupleExpander {
    SearchProblem sp;
    boolean fullPLUGPruning;
    double worstELBDiff = 0.0;

    public ConfETupleExpander(SearchProblem sp) {
        super(sp.confSpace.numPos, sp.confSpace.getNumRCsAtPos(), sp.pruneMat.getPruningInterval(), sp.luteSettings);
        this.sp = sp;
        boolean bl = this.fullPLUGPruning = sp.plugMat != null;
        if (this.fullPLUGPruning) {
            this.canCheckPartialPruning = false;
        }
    }

    @Override
    double scoreAssignmentList(int[] assignmentList) {
        if (this.sp.useEPIC) {
            double E = this.sp.EPICMinimizedEnergy(assignmentList);
            RCTuple tup = new RCTuple(assignmentList);
            if (E == Double.POSITIVE_INFINITY) {
                if (this.isPruned(tup)) {
                    throw new RuntimeException("ERROR: Scoring pruned conformation: " + tup.stringListing());
                }
                throw new RuntimeException("ERROR: Infinite E for unpruned conf: " + tup.stringListing());
            }
            if (this.fullPLUGPruning && !this.sp.plugMat.isTupleFeasible(tup)) {
                throw new RuntimeException("ERROR: Scoring PLUG-infeasible conformation: " + tup.stringListing());
            }
            return E;
        }
        return this.sp.minimizedEnergy(assignmentList);
    }

    @Override
    public boolean isPruned(RCTuple tup) {
        if (this.sp.pruneMat.isPruned(tup)) {
            return true;
        }
        return this.fullPLUGPruning && !this.sp.plugMat.isTupleFeasible(tup);
    }

    @Override
    void pruneTuple(RCTuple tup) {
        this.sp.pruneMat.markAsPruned(tup);
    }

    @Override
    ArrayList<RCTuple> higherOrderPrunedTuples(RCTuple tup) {
        if (tup.pos.size() != 2) {
            throw new RuntimeException("ERROR: higherOrderPrunedTuples is meant to take an RC pair as argument");
        }
        HigherTupleFinder<Boolean> htf = this.sp.pruneMat.getHigherOrderTerms(tup.pos.get(0), tup.RCs.get(0), tup.pos.get(1), tup.RCs.get(1));
        if (htf != null) {
            ArrayList<RCTuple> otherTups = htf.listInteractionsWithValue(true);
            for (RCTuple otherTup : otherTups) {
                for (int i = 0; i < 2; ++i) {
                    otherTup.pos.add(tup.pos.get(i));
                    otherTup.RCs.add(tup.RCs.get(i));
                }
            }
            return otherTups;
        }
        return new ArrayList<RCTuple>();
    }
}

