/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools.resultdoc;

import com.google.common.base.Charsets;
import edu.duke.cs.osprey.tools.Streams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class GNUPlot {
    public static byte[] plotPng(int width, int height, Plotter plotter) {
        byte[] byArray;
        block8: {
            Plotter pngPlotter = c -> {
                c.terminal.set("png size %s, %s", width, height);
                plotter.plot(c);
                c.flush();
            };
            InputStream result = GNUPlot.plot(pngPlotter);
            try {
                byArray = IOUtils.toByteArray((InputStream)result);
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("can't read PNG plot", ex);
                }
            }
            result.close();
        }
        return byArray;
    }

    public static String plotSvg(int width, int height, Plotter plotter) {
        String string;
        block8: {
            Plotter svgPlotter = c -> {
                c.terminal.set("svg size %s, %s", width, height);
                plotter.plot(c);
                c.flush();
            };
            InputStream result = GNUPlot.plot(svgPlotter);
            try {
                string = IOUtils.toString((InputStream)result, (Charset)Charsets.UTF_8);
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("can't read SVG plot", ex);
                }
            }
            result.close();
        }
        return string;
    }

    private static InputStream plot(Plotter plotter) {
        try {
            Process process2 = new ProcessBuilder(new String[0]).command("gnuplot").start();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process2.getOutputStream()));){
                plotter.plot(new Cmd(writer));
            }
            for (String line : IOUtils.readLines((InputStream)process2.getErrorStream(), (Charset)Charsets.UTF_8)) {
                System.err.println("GNUPlot: " + line);
            }
            return process2.getInputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException("can't run GNUPlot", ex);
        }
    }

    public static interface Plotter {
        public void plot(Cmd var1) throws IOException;
    }

    public static class Cmd {
        private final BufferedWriter out;
        public final Tics xtics = new Tics("xtics");
        public final Tics ytics = new Tics("ytics");
        public final Style style = new Style();
        public final LiteralProp terminal = new LiteralProp(this, "terminal");
        public final TextProp xlabel = new TextProp(this, "xlabel");
        public final TextProp ylabel = new TextProp(this, "ylabel");
        public final LiteralProp key = new LiteralProp(this, "key");

        private Cmd(BufferedWriter out) {
            this.out = out;
        }

        public void command(String text) throws IOException {
            this.out.write(text);
            this.out.write("\n");
        }

        public void command(String format, Object ... args) throws IOException {
            this.command(String.format(format, args));
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void datablock(String name, String data) throws IOException {
            this.command("$" + name + " << EOD");
            this.command(data);
            this.command("EOD");
        }

        public static String renderText(String val) {
            return "\"" + val.replace("\"", "\\\"").replace("\n", "\\n") + "\"";
        }

        public class Tics {
            private final String name;
            public final TextProp format;
            public final NumberProp scale;
            public final NumberProp rotate;

            public Tics(String name) {
                this.name = name;
                this.format = new TextProp(Cmd.this, name + " format");
                this.scale = new NumberProp(Cmd.this, name + " scale");
                this.rotate = new NumberProp(Cmd.this, "set " + name + " rotate by %s", "set " + name + " norotate");
            }

            public void hide() throws IOException {
                Cmd.this.command("unset " + this.name);
            }

            public void set(Map<Number, String> ticks) throws IOException {
                Cmd.this.command("set " + this.name + " (" + Streams.joinToString(ticks, ", ", (val, label2) -> Cmd.renderText(label2) + " " + String.valueOf(val)) + ")");
            }

            public void add(Number val, String label2) throws IOException {
                Cmd.this.command("set " + this.name + " add (" + Cmd.renderText(label2) + " " + String.valueOf(val) + ")");
            }
        }

        public class Style {
            public final LiteralProp data;

            public Style() {
                this.data = new LiteralProp(Cmd.this, "style data");
            }
        }

        public class LiteralProp
        extends Prop {
            private String val = null;

            public LiteralProp(Cmd this$0, String set, String unset) {
                super(set, unset);
            }

            public LiteralProp(Cmd this$0, String name) {
                super(name);
            }

            @Override
            public void set(String val) throws IOException {
                this.val = val;
                super.set(val);
            }

            public void set(String format, Object ... args) throws IOException {
                this.set(String.format(format, args));
            }

            public String get() {
                return this.val;
            }
        }

        public class TextProp
        extends Prop {
            private String val = null;

            public TextProp(Cmd this$0, String set, String unset) {
                super(set, unset);
            }

            public TextProp(Cmd this$0, String name) {
                super(name);
            }

            @Override
            public void set(String val) throws IOException {
                this.val = val;
                if (val != null) {
                    val = Cmd.renderText(val);
                }
                super.set(val);
            }

            public void set(String format, Object ... args) throws IOException {
                this.set(String.format(format, args));
            }

            public String get() {
                return this.val;
            }
        }

        public class NumberProp
        extends Prop {
            private Number val = null;

            public NumberProp(Cmd this$0, String set, String unset) {
                super(set, unset);
            }

            public NumberProp(Cmd this$0, String name) {
                super(name);
            }

            public void set(Number val) throws IOException {
                this.val = val;
                if (val != null) {
                    super.set(val.toString());
                } else {
                    super.set(null);
                }
            }

            public Number get() {
                return this.val;
            }
        }

        private abstract class Prop {
            private final String set;
            private final String unset;

            public Prop(String set, String unset) {
                this.set = set;
                this.unset = unset;
            }

            public Prop(String name) {
                this("set " + name + " %s", "unset " + name);
            }

            protected void set(String val) throws IOException {
                if (val == null) {
                    Cmd.this.command(this.unset);
                } else {
                    Cmd.this.command(String.format(this.set, val));
                }
            }
        }
    }
}

