/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.util.concurrent.TimeUnit;

public class TimeFormatter {
    public static final long NSpUS = 1000L;
    public static final long NSpMS = 1000000L;
    public static final long NSpS = 1000000000L;
    public static final long NSpM = 60000000000L;
    public static final long NSpH = 3600000000000L;

    public static double getTimeUs(long ns) {
        return (double)ns / 1000.0;
    }

    public static double getTimeMs(long ns) {
        return (double)ns / 1000000.0;
    }

    public static double getTimeS(long ns) {
        return (double)ns / 1.0E9;
    }

    public static double getTimeM(long ns) {
        return (double)ns / 6.0E10;
    }

    public static double getTimeH(long ns) {
        return (double)ns / 3.6E12;
    }

    public static String format(long ns) {
        return TimeFormatter.format(ns, 0);
    }

    public static String format(long ns, int decimals) {
        long nsabs = Math.abs(ns);
        if (TimeFormatter.getTimeH(nsabs) > 1.0) {
            return TimeFormatter.format(ns, TimeUnit.HOURS, decimals);
        }
        if (TimeFormatter.getTimeM(nsabs) > 1.0) {
            return TimeFormatter.format(ns, TimeUnit.MINUTES, decimals);
        }
        if (TimeFormatter.getTimeS(nsabs) > 1.0) {
            return TimeFormatter.format(ns, TimeUnit.SECONDS, decimals);
        }
        if (TimeFormatter.getTimeMs(nsabs) > 1.0) {
            return TimeFormatter.format(ns, TimeUnit.MILLISECONDS, decimals);
        }
        if (TimeFormatter.getTimeUs(nsabs) > 1.0) {
            return TimeFormatter.format(ns, TimeUnit.MICROSECONDS, decimals);
        }
        return TimeFormatter.format(ns, TimeUnit.NANOSECONDS, decimals);
    }

    public static String format(long ns, TimeUnit unit) {
        return TimeFormatter.format(ns, unit, 0);
    }

    public static String format(long ns, TimeUnit unit, int decimals) {
        Object formatSpec = unit == TimeUnit.NANOSECONDS ? "%d " : "%." + decimals + "f ";
        switch (unit) {
            case NANOSECONDS: {
                return String.format((String)formatSpec + "ns", ns);
            }
            case MICROSECONDS: {
                return String.format((String)formatSpec + "us", TimeFormatter.getTimeUs(ns));
            }
            case MILLISECONDS: {
                return String.format((String)formatSpec + "ms", TimeFormatter.getTimeMs(ns));
            }
            case SECONDS: {
                return String.format((String)formatSpec + "s", TimeFormatter.getTimeS(ns));
            }
            case MINUTES: {
                return String.format((String)formatSpec + "m", TimeFormatter.getTimeM(ns));
            }
            case HOURS: {
                return String.format((String)formatSpec + "h", TimeFormatter.getTimeH(ns));
            }
        }
        throw new Error("Unsupported time unit: " + String.valueOf((Object)unit));
    }
}

