/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.TimeFormatter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class Stopwatch
implements Serializable {
    private boolean isRunning = false;
    private long startTime = -1L;
    private long timeNs;

    public Stopwatch reset() {
        this.timeNs = 0L;
        return this;
    }

    public Stopwatch start() {
        this.reset();
        return this.resume();
    }

    public Stopwatch resume() {
        assert (!this.isRunning);
        this.startTime = System.nanoTime();
        this.isRunning = true;
        return this;
    }

    public Stopwatch stop() {
        assert (this.isRunning);
        this.timeNs += System.nanoTime() - this.startTime;
        this.isRunning = false;
        return this;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getTimeNs() {
        if (this.isRunning) {
            return this.timeNs + System.nanoTime() - this.startTime;
        }
        return this.timeNs;
    }

    public double getTimeUs() {
        return TimeFormatter.getTimeUs(this.getTimeNs());
    }

    public double getTimeMs() {
        return TimeFormatter.getTimeMs(this.getTimeNs());
    }

    public double getTimeS() {
        return TimeFormatter.getTimeS(this.getTimeNs());
    }

    public double getTimeM() {
        return TimeFormatter.getTimeM(this.getTimeNs());
    }

    public double getTimeH() {
        return TimeFormatter.getTimeH(this.getTimeNs());
    }

    public String getTime() {
        return TimeFormatter.format(this.getTimeNs());
    }

    public String getTime(int decimals) {
        return TimeFormatter.format(this.getTimeNs(), decimals);
    }

    public String getTime(TimeUnit unit) {
        return TimeFormatter.format(this.getTimeNs(), unit);
    }

    public String getTime(TimeUnit unit, int decimals) {
        return TimeFormatter.format(this.getTimeNs(), unit, decimals);
    }
}

