/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.GenericDocument;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVG {
    private final GenericDocument doc;
    private final SVGGeneratorContext ctx;
    private final SVGGraphics2D g;
    private final DOMGroupManager groups;
    private final Map<String, StyleClass> styleClasses = new HashMap<String, StyleClass>();
    private List<StyleClass> currentStyleClasses = null;
    private String currentId = null;
    private Rectangle2D.Double bounds;

    public SVG() {
        this.doc = (GenericDocument)GenericDOMImplementation.getDOMImplementation().createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.ctx = SVGGeneratorContext.createDefault((Document)this.doc);
        this.ctx.setStyleHandler((elem, styleMap, ctxAgain) -> {
            if (elem.getTagName().equalsIgnoreCase("g")) {
                return;
            }
            if (this.currentStyleClasses != null && !this.currentStyleClasses.isEmpty()) {
                elem.setAttribute("class", StyleClass.renderNames(this.currentStyleClasses));
            }
            if (this.currentId != null) {
                elem.setAttribute("id", this.currentId);
            }
        });
        this.g = new SVGGraphics2D(this.ctx, false);
        try {
            Field groupsField = this.g.getClass().getDeclaredField("domGroupManager");
            groupsField.setAccessible(true);
            this.groups = (DOMGroupManager)groupsField.get(this.g);
        }
        catch (Throwable t) {
            throw new Error("Reflection hacks failed, maybe the Batik version changed?", t);
        }
        this.setBounds(0.0, 100.0, 0.0, 100.0);
    }

    public void setBounds(double x1, double x2, double y1, double y2) {
        this.bounds = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public StyleClass makeStyleClass(String name) {
        StyleClass styleClass = new StyleClass(name);
        this.putStyleClasses(styleClass);
        return styleClass;
    }

    public void putStyleClasses(StyleClass ... styleClasses) {
        for (StyleClass styleClass : styleClasses) {
            this.styleClasses.put(styleClass.name, styleClass);
        }
    }

    public ShapeDrawable makeLine(double x1, double y1, double x2, double y2) {
        return new ShapeDrawable(new Line2D.Double(x1, y1, x2, y2));
    }

    public ShapeDrawable makeRect(double x1, double x2, double y1, double y2) {
        return new ShapeDrawable(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
    }

    public ShapeDrawable makeRectWH(double x, double y, double w, double h) {
        return new ShapeDrawable(new Rectangle2D.Double(x, y, w, h));
    }

    public ShapeDrawable makePoint(double x, double y, double radius) {
        double size = radius * 2.0;
        return new ShapeDrawable(new Ellipse2D.Double(x - radius, y - radius, size, size));
    }

    public TextDrawable makeText(String text) {
        return new TextDrawable(text);
    }

    public Finished finish() {
        return new Finished();
    }

    public static class StyleClass {
        public final String name;
        public final Map<String, String> values = new HashMap<String, String>();
        public int priority = 0;

        public StyleClass(String name) {
            this.name = name;
        }

        private String colorToString(int color) {
            return String.format("#%6s", Integer.toHexString(color)).replace(' ', '0');
        }

        public void set(String prop, String value2) {
            this.values.put(prop, value2);
        }

        public void setNoStroke() {
            this.set("stroke", "none");
        }

        public void setStrokeColor(int color) {
            this.set("stroke", this.colorToString(color));
        }

        public void setStrokeWidth(double size) {
            this.set("stroke-width", Double.toString(size));
        }

        public void setStrokeOpacity(double opacity) {
            this.set("stroke-opacity", Double.toString(opacity));
        }

        public void setStrokeDashArray(int ... array) {
            String arrayString = String.join((CharSequence)",", Arrays.stream(array).mapToObj(i -> Integer.toString(i)).collect(Collectors.toList()));
            this.set("stroke-dasharray", arrayString);
        }

        public void setNoFill() {
            this.set("fill", "none");
        }

        public void setFillColor(int color) {
            this.set("fill", this.colorToString(color));
        }

        public void setFontSize(double size, LengthUnit unit) {
            this.set("font-size", unit.render(size));
        }

        public void setTextAnchor(TextAnchor val) {
            this.set("text-anchor", val.name().toLowerCase());
        }

        public void setDominantBaseline(DominantBaseline val) {
            this.set("dominant-baseline", val.token);
        }

        public static String renderNames(List<StyleClass> currentStyleClasses) {
            if (currentStyleClasses == null || currentStyleClasses.isEmpty()) {
                return "";
            }
            if (currentStyleClasses.size() == 1) {
                return currentStyleClasses.get((int)0).name;
            }
            return String.join((CharSequence)" ", currentStyleClasses.stream().filter(style -> style != null).map(style -> style.name).collect(Collectors.toList()));
        }

        public static enum TextAnchor {
            Start,
            Middle,
            End;

        }

        public static enum DominantBaseline {
            Auto("auto"),
            UseScript("use-script"),
            NoChange("no-change"),
            ResetSize("reset-size"),
            Ideographic("ideographic"),
            Alphabetic("alphabetic"),
            Hanging("hanging"),
            Mathematical("mathematical"),
            Central("central"),
            Middle("middle"),
            TextAfterEdge("text-after-edge"),
            TextBeforeEdge("text-before-edge"),
            Inherit("inherit");

            public final String token;

            private DominantBaseline(String token) {
                this.token = token;
            }
        }
    }

    public class ShapeDrawable
    extends Drawable {
        public final Shape shape;

        public ShapeDrawable(Shape shape) {
            this.shape = shape;
        }

        @Override
        protected void reallyDraw() {
            SVG.this.g.draw(this.shape);
        }
    }

    public class TextDrawable
    extends Drawable {
        public final String text;
        private double x;
        private double y;
        private String dy;

        public TextDrawable(String text) {
            this.x = 0.0;
            this.y = 0.0;
            this.dy = null;
            this.text = text;
        }

        public TextDrawable setPos(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public TextDrawable setDY(double dy, LengthUnit unit) {
            this.dy = unit.render(-dy);
            return this;
        }

        @Override
        protected void reallyDraw() {
            Element elem = SVG.this.doc.createElementNS("http://www.w3.org/2000/svg", "text");
            elem.appendChild(SVG.this.doc.createTextNode(this.text));
            elem.setAttribute("x", SVG.this.ctx.doubleString(this.x));
            elem.setAttribute("y", SVG.this.ctx.doubleString(this.y));
            elem.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
            if (SVG.this.currentStyleClasses != null && !SVG.this.currentStyleClasses.isEmpty()) {
                elem.setAttribute("class", StyleClass.renderNames(SVG.this.currentStyleClasses));
            }
            if (SVG.this.currentId != null) {
                elem.setAttribute("id", SVG.this.currentId);
            }
            if (this.dy != null) {
                elem.setAttribute("dy", this.dy);
            }
            SVG.this.groups.addElement(elem, (short)16);
        }
    }

    public class Finished {
        private final Element svgElem;

        private Finished() {
            this.svgElem = SVG.this.g.getRoot();
            Element topGroup = (Element)this.svgElem.getElementsByTagName("g").item(0);
            this.svgElem.setAttribute("viewBox", String.format("%f %f %f %f", SVG.this.bounds.x, -(SVG.this.bounds.y + SVG.this.bounds.height), SVG.this.bounds.width, SVG.this.bounds.height));
            topGroup.setAttribute("transform", "scale(1,-1)");
            for (Element element : this.elements(this.svgElem.getElementsByTagName("text"))) {
                try {
                    double y = Double.parseDouble(element.getAttribute("y"));
                    element.setAttribute("transform", String.format("scale(1,-1) translate(0, %f) translate(0, %f)", -y, -y));
                }
                catch (NumberFormatException y) {}
            }
            CDATASection stylesheet = SVG.this.doc.createCDATASection("");
            ArrayList<StyleClass> arrayList = new ArrayList<StyleClass>(SVG.this.styleClasses.values());
            arrayList.sort(Comparator.comparingInt(a -> a.priority));
            for (StyleClass styleClass : arrayList) {
                stylesheet.appendData(".");
                stylesheet.appendData(styleClass.name);
                stylesheet.appendData(" { ");
                styleClass.values.forEach((key, value2) -> {
                    stylesheet.appendData((String)key);
                    stylesheet.appendData(":");
                    stylesheet.appendData((String)value2);
                    stylesheet.appendData("; ");
                });
                stylesheet.appendData("}\n");
            }
            Element style = SVG.this.doc.createElementNS("http://www.w3.org/2000/svg", "style");
            style.setAttributeNS(null, "type", "text/css");
            style.appendChild(stylesheet);
            SVG.this.doc.getChildElementById((Node)this.svgElem, "genericDefs").appendChild(style);
        }

        private Iterable<? extends Element> elements(final NodeList nodes) {
            return () -> new Iterator<Element>(){
                int i = 0;
                int n = nodes.getLength();

                @Override
                public boolean hasNext() {
                    return this.i < this.n;
                }

                @Override
                public Element next() {
                    return (Element)nodes.item(this.i++);
                }
            };
        }

        public void write(Writer out) {
            try {
                SVG.this.g.stream(this.svgElem, out, true, false);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void write(File file) {
            try (FileWriter out = new FileWriter(file);){
                this.write(out);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public abstract class Drawable {
        private List<StyleClass> styleClasses = null;
        private String id = null;

        public Drawable setStyleClasses(StyleClass ... vals) {
            if (this.styleClasses == null) {
                this.styleClasses = new ArrayList<StyleClass>();
            }
            this.styleClasses.clear();
            for (StyleClass val : vals) {
                if (val == null) continue;
                this.styleClasses.add(val);
            }
            return this;
        }

        public Drawable setId(String val) {
            this.id = val;
            return this;
        }

        public void draw() {
            SVG.this.currentStyleClasses = this.styleClasses;
            SVG.this.currentId = this.id;
            this.reallyDraw();
        }

        protected abstract void reallyDraw();
    }

    private static interface Drawer {
        public void draw();
    }

    public static enum LengthUnit {
        em("em"),
        ex("ex"),
        px("px"),
        in("in"),
        cm("cm"),
        mm("mm"),
        pt("pt"),
        pc("pc"),
        percent("%");

        public final String token;

        private LengthUnit(String token) {
            this.token = token;
        }

        public String render(double value2) {
            return String.format("%f%s", value2, this.token);
        }
    }
}

