/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.GLibC;
import edu.duke.cs.osprey.tools.MathTools;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class JvmMem {
    private static boolean warnedAboutLimits = false;
    private static final String EdenSuffix = "Eden Space";
    private static final String SurvivorSuffix = "Survivor Space";
    private static final String OldSuffix = "Old Gen";

    private static List<MemoryPoolMXBean> getPools(List<String> name) {
        return ManagementFactory.getMemoryPoolMXBeans().stream().filter(pool -> name.stream().anyMatch(n -> pool.getName().endsWith((String)n))).collect(Collectors.toList());
    }

    private static MemoryPoolMXBean getPool(String name) {
        return (MemoryPoolMXBean)JvmMem.getPools(List.of(name)).stream().findFirst().orElseThrow(() -> new NoSuchElementException("no memory pool named " + name));
    }

    private static List<MemoryPoolMXBean> getOtherPools(List<String> name) {
        return ManagementFactory.getMemoryPoolMXBeans().stream().filter(pool -> name.stream().noneMatch(n -> pool.getName().endsWith((String)n))).collect(Collectors.toList());
    }

    public static MemInfo getEdenPool() {
        return new MemInfo(JvmMem.getPool(EdenSuffix));
    }

    public static MemInfo getSurvivorPool() {
        return new MemInfo(JvmMem.getPool(SurvivorSuffix));
    }

    public static MemInfo getYoungPool() {
        return new MemInfo("Young Gen", JvmMem.getPools(List.of(EdenSuffix, SurvivorSuffix)));
    }

    public static MemInfo getOldPool() {
        return new MemInfo(JvmMem.getPool(OldSuffix));
    }

    public static MemInfo getOverheadPool() {
        return new MemInfo("Overhead", JvmMem.getOtherPools(List.of(EdenSuffix, SurvivorSuffix, OldSuffix)));
    }

    public static MemInfo getProcess() {
        long max;
        MemInfo overhead;
        MemInfo old;
        MemInfo young;
        block2: {
            young = JvmMem.getYoungPool();
            old = JvmMem.getOldPool();
            overhead = JvmMem.getOverheadPool();
            max = -1L;
            try {
                max = GLibC.getrlimit((GLibC.RLimitResource)GLibC.RLimitResource.RSS).max;
            }
            catch (Throwable t) {
                if (warnedAboutLimits) break block2;
                System.err.println("WARN: can't determine process memory limits");
                t.printStackTrace(System.err);
                warnedAboutLimits = true;
            }
        }
        return new MemInfo("Total", max, young.usedBytes + old.usedBytes + overhead.usedBytes, young.allocatedBytes + old.allocatedBytes + overhead.allocatedBytes);
    }

    public static String oneLineReport() {
        MemInfo old = JvmMem.getOldPool();
        MemInfo process2 = JvmMem.getProcess();
        return String.format("JvmMem[Heap: %s; Process: %s]", old, process2);
    }

    public static void monitorMemoryToStdout(Duration interval, boolean showHostname) {
        String hostname = null;
        if (showHostname) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                System.err.println("WARN: can't find hostname");
                ex.printStackTrace(System.err);
            }
        }
        String fhostname = hostname;
        Runnable report = () -> {
            StringBuilder buf = new StringBuilder();
            if (fhostname != null) {
                buf.append(fhostname);
                buf.append(": ");
            }
            buf.append(JvmMem.oneLineReport());
            buf.append('\n');
            System.out.print(buf);
        };
        Thread thread2 = new Thread(() -> {
            while (true) {
                report.run();
                try {
                    Thread.sleep(interval.toMillis());
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        });
        thread2.setName("Memory Monitor");
        thread2.setDaemon(true);
        thread2.start();
    }

    public static class MemInfo {
        public final String name;
        public final long maxBytes;
        public final long usedBytes;
        public final double usedPercent;
        public final long allocatedBytes;
        public final double allocatedPercent;

        public MemInfo(String name, long maxBytes, long usedBytes, long allocatedBytes) {
            this.name = name;
            this.maxBytes = maxBytes;
            this.usedBytes = usedBytes;
            this.usedPercent = 100.0 * (double)usedBytes / (double)maxBytes;
            this.allocatedBytes = allocatedBytes;
            this.allocatedPercent = 100.0 * (double)allocatedBytes / (double)maxBytes;
        }

        public MemInfo(MemoryPoolMXBean pool) {
            this(pool.getName(), List.of(pool));
        }

        public MemInfo(String name, List<MemoryPoolMXBean> pools) {
            this(name, MemInfo.sumMax(pools), pools.stream().mapToLong(it -> it.getUsage().getUsed()).sum(), pools.stream().mapToLong(it -> it.getUsage().getCommitted()).sum());
        }

        private static long sumMax(List<MemoryPoolMXBean> pools) {
            if (pools.stream().anyMatch(it -> it.getUsage().getMax() < 0L)) {
                return -1L;
            }
            return pools.stream().mapToLong(it -> it.getUsage().getMax()).sum();
        }

        public String toString() {
            if (this.maxBytes >= 0L) {
                return String.format("%.1f%% of %s, %s alloc", this.usedPercent, MathTools.formatBytes(this.maxBytes), MathTools.formatBytes(this.allocatedBytes));
            }
            return String.format("%s, %s alloc", MathTools.formatBytes(this.usedBytes), MathTools.formatBytes(this.allocatedBytes));
        }
    }
}

