/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.FileTools;
import java.util.Iterator;
import java.util.function.BiConsumer;

public class ConfigFileReader {
    private Iterator<String> iter;
    private String line;

    public ConfigFileReader(String text) {
        this.iter = FileTools.parseLines(text).iterator();
    }

    private String normalizeLine(String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            line = line.substring(0, commentPos);
        }
        line = line.trim();
        return line;
    }

    public String getLine() {
        return this.line;
    }

    public String getSectionName() {
        if (this.line != null && this.line.startsWith("[") && this.line.endsWith("]")) {
            return this.line.substring(1, this.line.length() - 1);
        }
        return null;
    }

    public void getAssignment(BiConsumer<String, String> callback) {
        String[] parts = this.line.split("=");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (parts.length < 2) {
            throw new IllegalArgumentException("line is not an assignment: " + this.line);
        }
        callback.accept(parts[0], parts[1]);
    }

    public void advance() {
        this.line = this.iter.hasNext() ? this.normalizeLine(this.iter.next()) : null;
    }

    public void advanceToNonEmptyLine() {
        while (this.iter.hasNext()) {
            this.line = this.normalizeLine(this.iter.next());
            if (!this.line.isEmpty()) break;
            this.line = null;
        }
    }
}

