/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tests;

import edu.duke.cs.osprey.astar.comets.LME;
import edu.duke.cs.osprey.astar.comets.NewCOMETSDoer;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gmec.PrecomputedMatrices;
import edu.duke.cs.osprey.gmec.PruningSettings;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NewCOMETS {
    public static void main(String[] args) {
        int numStates = 4;
        SimpleConfSpace[] confSpaces = new SimpleConfSpace[numStates];
        PrecomputedMatrices[] precompMats = new PrecomputedMatrices[numStates];
        LME objFcn = new LME("1 -1 0 0 0", 4);
        LME[] constraints = new LME[]{new LME("1 -1 0 0 20", 4), new LME("0 0 -1 1 70", 4), new LME("0 1 0 1 20", 4)};
        int[] boundMutPos = new int[]{3, 4, 5, 6, 7};
        int[] unboundMutPos = new int[]{0, 1, 2, 3, 4};
        ArrayList<ArrayList<Integer>> mutable2StatePosNums = NewCOMETS.toDoubleList(boundMutPos, unboundMutPos, boundMutPos, unboundMutPos);
        ArrayList<ArrayList<String>> AATypeOptions = NewCOMETS.toDoubleList({"ILE", "LEU", "MET", "PHE", "TRP", "TYR", "VAL"}, {"ASP", "GLU"}, {"ILE", "LEU", "MET", "PHE", "TRP", "TYR", "VAL"}, {"ILE", "LEU", "MET", "PHE", "TRP", "TYR", "VAL"}, {"ASN", "GLN", "SER", "THR"});
        int numMaxMut = -1;
        String[] wtSeq = null;
        int numSeqsWanted = 5;
        ConfEnergyCalculator[] confECalc = new ConfEnergyCalculator[numStates];
        String[] stateNames = new String[]{"3K75.b", "3K75.ub", "3LQC.b", "3LQC.ub"};
        PruningSettings pruningSettings = new PruningSettings();
        pruningSettings.typedep = true;
        boolean useERef = true;
        for (int state = 0; state < numStates; ++state) {
            confSpaces[state] = NewCOMETS.prepareConfSpace(state, AATypeOptions);
            ForcefieldParams ffparams = new ForcefieldParams();
            ffparams.solvScale = 0.0;
            EnergyCalculator ecalc = new EnergyCalculator.Builder(confSpaces[state], ffparams).build();
            ConfEnergyCalculator.Builder confEcalcBuilder = new ConfEnergyCalculator.Builder(confSpaces[state], ecalc);
            if (useERef) {
                SimpleReferenceEnergies eref = new SimpleReferenceEnergies.Builder(confSpaces[state], ecalc).build();
                confEcalcBuilder.setReferenceEnergies(eref);
            }
            confECalc[state] = confEcalcBuilder.build();
            EnergyMatrix emat = new SimplerEnergyMatrixCalculator.Builder(confECalc[state]).build().calcEnergyMatrix();
            double Ival = 0.0;
            double Ew = 0.0;
            precompMats[state] = new PrecomputedMatrices(Ival, Ew, stateNames[state], emat, confSpaces[state], ecalc, confECalc[state], new EPICSettings(), new LUTESettings(), pruningSettings);
        }
        NewCOMETSDoer cd = new NewCOMETSDoer(confSpaces, precompMats, objFcn, constraints, mutable2StatePosNums, AATypeOptions, numMaxMut, wtSeq, numSeqsWanted, true, confECalc);
        ArrayList<String> bestSequences = cd.calcBestSequences();
    }

    private static SimpleConfSpace prepareConfSpace(int state, ArrayList<ArrayList<String>> AATypeOptions) {
        String pdbFile;
        String[] mutResNums = switch (state) {
            case 0 -> {
                pdbFile = "examples/3K75.3LQC/3K75.b.shell.pdb";
                yield new String[]{"0391", "0409", "0411", "0422", "0424"};
            }
            case 1 -> {
                pdbFile = "examples/3K75.3LQC/3K75.ub.shell.pdb";
                yield new String[]{"0291", "0309", "0311", "0322", "0324"};
            }
            case 2 -> {
                pdbFile = "examples/3K75.3LQC/3LQC.b.shell.pdb";
                yield new String[]{"0591", "0609", "0611", "0622", "0624"};
            }
            case 3 -> {
                pdbFile = "examples/3K75.3LQC/3LQC.ub.shell.pdb";
                yield new String[]{"0291", "0309", "0311", "0322", "0324"};
            }
            default -> throw new RuntimeException("Unrecognized state");
        };
        Molecule mol = PDBIO.readFile(pdbFile);
        Strand strand = new Strand.Builder(mol).build();
        for (int mutPos = 0; mutPos < AATypeOptions.size(); ++mutPos) {
            strand.flexibility.get(mutResNums[mutPos]).setLibraryRotamers((List<String>)AATypeOptions.get(mutPos));
        }
        if (state % 2 == 0) {
            strand.flexibility.get("067").setLibraryRotamers("Phe");
            strand.flexibility.get("090").setLibraryRotamers("Thr");
            strand.flexibility.get("0136").setLibraryRotamers("Tyr");
        }
        SimpleConfSpace confSpace = new SimpleConfSpace.Builder().addStrand(strand, new StrandFlex[0]).build();
        return confSpace;
    }

    private static ArrayList<ArrayList<Integer>> toDoubleList(int[] ... arr) {
        ArrayList<ArrayList<Integer>> ans = new ArrayList<ArrayList<Integer>>();
        for (int[] a : arr) {
            ArrayList<Integer> subAns = new ArrayList<Integer>();
            for (int b : a) {
                subAns.add(b);
            }
            ans.add(subAns);
        }
        return ans;
    }

    private static ArrayList<ArrayList<String>> toDoubleList(String[] ... arr) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        for (String[] a : arr) {
            ans.add(new ArrayList<String>(Arrays.asList(a)));
        }
        return ans;
    }
}

