/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.tools.MathTools;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.Function;

public class ClusterR1 {
    private final TreeSet<Double> values = new TreeSet();

    public void add(double a) {
        this.values.add(a);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public MathTools.DoubleBounds bounds() {
        MathTools.DoubleBounds bounds = new MathTools.DoubleBounds(this.values.first(), this.values.first());
        for (double a : this.values) {
            bounds.expand(a);
        }
        return bounds;
    }

    public double mean() {
        double sum = 0.0;
        for (double a : this.values) {
            sum += a;
        }
        return sum / (double)this.values.size();
    }

    public double mode(MathTools.DoubleBounds bounds, int numBuckets) {
        double min = bounds.lower;
        double width = bounds.size();
        Function<Double, Integer> valueToBucket = v -> (int)((v - min) * (double)numBuckets / width);
        Function<Integer, Double> bucketToValue = i -> width * (double)i.intValue() / (double)numBuckets + min;
        int[] counts = new int[numBuckets];
        Arrays.fill(counts, 0);
        for (double v2 : this.values) {
            int i2 = valueToBucket.apply(v2);
            if (i2 < 0 || i2 >= numBuckets) continue;
            int n = i2;
            counts[n] = counts[n] + 1;
        }
        int bucket = 0;
        int maxCount = 0;
        for (int i3 = 0; i3 < numBuckets; ++i3) {
            if (counts[i3] <= maxCount) continue;
            maxCount = counts[i3];
            bucket = i3;
        }
        return bucketToValue.apply(bucket);
    }

    public class Stats {
        public final ClusterR1 cluster;
        public final MathTools.DoubleBounds bounds;
        public final double mean;
        public final double mode;

        public Stats(double modeIncludesPercent, int modeBuckets) {
            this.cluster = ClusterR1.this;
            this.bounds = ClusterR1.this.bounds();
            this.mean = ClusterR1.this.mean();
            this.mode = ClusterR1.this.mode(this.getInterval(this.mean, modeIncludesPercent), modeBuckets);
        }

        public MathTools.DoubleBounds getInterval(double center, double includePercent) {
            int numNeg = 0;
            int numPos = 0;
            for (double a : ClusterR1.this.values) {
                if (a < center) {
                    ++numNeg;
                    continue;
                }
                if (!(a > center)) continue;
                ++numPos;
            }
            double skipRatio = 1.0 - includePercent / 100.0;
            int numNegToSkip = (int)((double)numNeg * skipRatio);
            int numPosToSkip = (int)((double)numPos * skipRatio);
            MathTools.DoubleBounds interval = new MathTools.DoubleBounds(center, center);
            int count = 0;
            for (double a : ClusterR1.this.values) {
                if (count++ <= numNegToSkip) continue;
                interval.lower = a;
                break;
            }
            count = 0;
            for (double a : ClusterR1.this.values.descendingSet()) {
                if (count++ <= numPosToSkip) continue;
                interval.upper = a;
                break;
            }
            return interval;
        }
    }
}

