/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AnderbergHierarchicalClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.CentroidLinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.LinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.ExtractFlatClusteringFromHierarchy;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.StaticArrayDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPIntegerNormDistanceFunction;
import edu.duke.cs.osprey.structure.analysis.SmallAngleVoxel;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AngleClustering {
    public static List<List<double[]>> cluster(Collection<double[]> points, final int numDimensions, double distCutoff) {
        StaticArrayDatabase db = new StaticArrayDatabase(() -> {
            ArrayList<DoubleVector> vecs = new ArrayList<DoubleVector>(points.size());
            for (double[] p : points) {
                vecs.add(new DoubleVector(p));
            }
            MultipleObjectsBundle b = new MultipleObjectsBundle();
            b.appendColumn((SimpleTypeInformation)new VectorFieldTypeInformation((FeatureVector.Factory)DoubleVector.FACTORY, numDimensions, numDimensions, DoubleVector.FACTORY.getDefaultSerializer()), vecs);
            return b;
        }, null);
        db.initialize();
        Relation vectors = db.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        LPIntegerNormDistanceFunction dist = new LPIntegerNormDistanceFunction(1){

            public double distance(NumberVector a, NumberVector b) {
                double dist = 0.0;
                for (int d = 0; d < numDimensions; ++d) {
                    double dd = Protractor.getDistDegrees(a.doubleValue(d), b.doubleValue(d));
                    dist += dd * dd;
                }
                return dist;
            }

            public double norm(NumberVector v) {
                throw new UnsupportedOperationException();
            }

            public double minDist(SpatialComparable a, SpatialComparable b) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ToroidalSquaredDistance";
            }
        };
        ExtractFlatClusteringFromHierarchy hac = new ExtractFlatClusteringFromHierarchy((HierarchicalClusteringAlgorithm)new AnderbergHierarchicalClustering((DistanceFunction)dist, (LinkageMethod)CentroidLinkageMethod.STATIC), distCutoff * distCutoff, false, false);
        Log.log("running clustering...", new Object[0]);
        Clustering result = hac.run((Database)db);
        Log.log("clustering done: %s clusters", result.getToplevelClusters().size());
        ArrayList<List<double[]>> clusters = new ArrayList<List<double[]>>();
        for (Cluster cluster : result.getToplevelClusters()) {
            ArrayList<double[]> clusterPoints = new ArrayList<double[]>(cluster.size());
            DBIDIter id1 = cluster.getIDs().iter();
            while (id1.valid()) {
                clusterPoints.add(((NumberVector)vectors.get((DBIDRef)id1)).getColumnVector().getArrayCopy());
                id1.advance();
            }
            clusters.add(clusterPoints);
            Log.log("\tcluster: n=%d", cluster.size());
        }
        return clusters;
    }

    public static double[] calcMedoid(Collection<double[]> points) {
        double[] medoid = null;
        double minScore = Double.POSITIVE_INFINITY;
        for (double[] p1 : points) {
            double score = 0.0;
            for (double[] p2 : points) {
                for (int d = 0; d < p1.length; ++d) {
                    double dd = Protractor.getDistDegrees(p1[d], p2[d]);
                    score += dd * dd;
                }
            }
            if (medoid != null && !(score < minScore)) continue;
            minScore = score;
            medoid = p1;
        }
        return medoid;
    }

    public static SmallAngleVoxel calcVoxel(List<double[]> points) {
        SmallAngleVoxel voxel = new SmallAngleVoxel(AngleClustering.calcMedoid(points));
        for (double[] p : points) {
            voxel.expand(p);
        }
        return voxel;
    }

    public static SmallAngleVoxel fitFixedVoxel(Collection<double[]> points, SmallAngleVoxel voxel, double radiusDegrees) {
        int n = voxel.intervals.length;
        int[] sizes = new int[n];
        for (int d = 0; d < n; ++d) {
            sizes[d] = Math.max(1, (int)Math.ceil(voxel.intervals[d].size() - radiusDegrees * 2.0));
        }
        double[] center = new double[n];
        SmallAngleVoxel fixedVoxel = new SmallAngleVoxel(center);
        for (int d = 0; d < n; ++d) {
            fixedVoxel.intervals[d].less = 0.0;
            fixedVoxel.intervals[d].more = radiusDegrees * 2.0;
        }
        long maxCount = 0L;
        int[] bestIndices = null;
        for (int[] indices : new MathTools.GridIterable(sizes)) {
            for (int d = 0; d < n; ++d) {
                fixedVoxel.intervals[d].center = Protractor.normalizeDegrees(voxel.intervals[d].min() + (double)indices[d]);
            }
            long count = points.stream().filter(p -> fixedVoxel.contains((double[])p)).count();
            if (count <= maxCount) continue;
            maxCount = count;
            bestIndices = (int[])indices.clone();
        }
        assert (bestIndices != null);
        for (int d = 0; d < n; ++d) {
            fixedVoxel.intervals[d].center = Protractor.normalizeDegrees(voxel.intervals[d].min() + (double)bestIndices[d]);
        }
        return fixedVoxel;
    }
}

