/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.TomlParseException;
import edu.duke.cs.osprey.tools.TomlTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.tomlj.TomlArray;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;

public class OMOLIO {
    public static String write(Molecule mol) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("name = %s\n", OMOLIO.quote(mol.name)));
        if (mol.residues.size() == 1) {
            buf.append(String.format("type = %s\n", OMOLIO.quote(((Residue)mol.residues.get(0)).getType())));
        }
        buf.append("\n");
        HashMap<Atom, Integer> indicesByAtom = new HashMap<Atom, Integer>();
        buf.append("atoms = [\n");
        int i = 0;
        for (Residue res2 : mol.residues) {
            for (Atom atom : res2.atoms) {
                double[] coords = atom.getCoords();
                indicesByAtom.put(atom, i);
                buf.append(String.format("\t{ i=%5d, name=%7s, x=%12.6f, y=%12.6f, z=%12.6f, elem=%3s },\n", i, OMOLIO.quote(atom.name), coords[0], coords[1], coords[2], OMOLIO.quote(atom.elementType)));
                ++i;
            }
        }
        buf.append("]\n");
        buf.append("\n");
        buf.append("bonds = [\n");
        for (Residue res2 : mol.residues) {
            for (Atom a1 : res2.atoms) {
                int i1 = (Integer)indicesByAtom.get(a1);
                for (Atom a2 : a1.bonds) {
                    int i2 = (Integer)indicesByAtom.get(a2);
                    if (i1 >= i2) continue;
                    buf.append(String.format("\t[%5d,%5d], # %6s - %-6s\n", i1, i2, a1.name, a2.name));
                }
            }
        }
        buf.append("]");
        buf.append("\n");
        buf.append("\n[polymer]\n");
        mol.residues.stream().map(res -> Character.valueOf(res.getChainId())).collect(Collectors.toSet()).forEach(chain -> {
            buf.append(String.format("%s = [\n", OMOLIO.quote(chain)));
            mol.residues.stream().filter(res -> chain.equals(Character.valueOf(res.getChainId()))).forEach(res -> {
                List<Integer> atoms = res.atoms.stream().map(atom -> (Integer)indicesByAtom.get(atom)).collect(Collectors.toList());
                buf.append(String.format("\t{ id=%7s, type=%6s, atoms=[%s] },\n", OMOLIO.quote(res.getPDBResNumber().substring(1)), OMOLIO.quote(res.getType()), OMOLIO.indicesToString(atoms)));
            });
            buf.append("]\n");
        });
        return buf.toString();
    }

    private static String indicesToString(List<Integer> indices) {
        return Streams.joinToString(indices, ", ", i -> Integer.toString(i));
    }

    private static String quote(Object val) {
        if (val == null) {
            return "\"\"";
        }
        String str = val.toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + str + "\"";
    }

    public static Molecule read(String toml) {
        TomlTable doc = TomlTools.parseOrThrow(toml);
        Molecule mol = new Molecule();
        mol.name = doc.getString("name");
        HashMap<Integer, Atom> atoms = new HashMap<Integer, Atom>();
        HashMap<Integer, double[]> atomCoords = new HashMap<Integer, double[]>();
        TomlArray atomsArray = TomlTools.getArrayOrThrow(doc, "atoms");
        for (int i = 0; i < atomsArray.size(); ++i) {
            TomlTable atomTable = TomlTools.getTableOrThrow(atomsArray, i);
            TomlPosition atomPos = atomsArray.inputPositionOf(i);
            int index = TomlTools.getIntOrThrow(atomTable, "i", atomPos);
            String name = TomlTools.getStringOrThrow(atomTable, "name", atomPos);
            double x = TomlTools.getDoubleOrThrow(atomTable, "x", atomPos);
            double y = TomlTools.getDoubleOrThrow(atomTable, "y", atomPos);
            double z = TomlTools.getDoubleOrThrow(atomTable, "z", atomPos);
            String element = TomlTools.getStringOrThrow(atomTable, "elem", atomPos);
            if (atoms.containsKey(index)) {
                throw new TomlParseException("duplicated atom index: " + index, atomPos);
            }
            atoms.put(index, new Atom(name, element));
            atomCoords.put(index, new double[]{x, y, z});
        }
        TomlTable polymerTable = TomlTools.getTableOrThrow(doc, "polymer");
        for (String chainId : polymerTable.keySet()) {
            TomlPosition chainPos = polymerTable.inputPositionOf(chainId);
            TomlArray chainArray = TomlTools.getArrayOrThrow(polymerTable, chainId, chainPos);
            for (int i = 0; i < chainArray.size(); ++i) {
                TomlTable residueTable = TomlTools.getTableOrThrow(chainArray, i, chainPos);
                TomlPosition residuePos = chainArray.inputPositionOf(i);
                String id = TomlTools.getStringOrThrow(residueTable, "id", residuePos);
                String type = TomlTools.getStringOrThrow(residueTable, "type", residuePos);
                TomlArray resAtomsArray = TomlTools.getArrayOrThrow(residueTable, "atoms", residuePos);
                ArrayList<Atom> resAtoms = new ArrayList<Atom>();
                ArrayList<double[]> resCoords = new ArrayList<double[]>();
                for (int a = 0; a < resAtomsArray.size(); ++a) {
                    int index = TomlTools.getIntOrThrow(resAtomsArray, a);
                    resAtoms.add((Atom)atoms.get(index));
                    resCoords.add((double[])atomCoords.get(index));
                }
                String fullName = String.format("%3s%2s%4s", type.substring(0, Math.min(type.length(), 3)), Character.valueOf(chainId.charAt(0)), id.substring(0, Math.min(id.length(), 4)));
                Residue res = new Residue(resAtoms, resCoords, fullName, mol);
                mol.residues.add(res);
            }
        }
        TomlArray bondsArray = TomlTools.getArrayOrThrow(doc, "bonds");
        for (int i = 0; i < bondsArray.size(); ++i) {
            TomlArray bondArray = TomlTools.getArrayOrThrow(bondsArray, i);
            TomlPosition pos = bondsArray.inputPositionOf(i);
            if (bondArray.size() != 2 || !bondArray.containsLongs()) {
                throw new TomlParseException("bond needs two integers", pos);
            }
            int i1 = TomlTools.getIntOrThrow(bondArray, 0);
            int i2 = TomlTools.getIntOrThrow(bondArray, 1);
            Atom a1 = (Atom)atoms.get(i1);
            Atom a2 = (Atom)atoms.get(i2);
            a1.addBond(a2);
        }
        return mol;
    }
}

