/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Molecule
implements Serializable {
    private static final long serialVersionUID = -2709516483892891323L;
    public String name = null;
    public Residues residues;
    private Map<Integer, ArrayList<Residue>> alternates;

    public Molecule() {
        this(new Residues());
    }

    public Molecule(Residues residues) {
        this.residues = residues;
        this.alternates = new HashMap<Integer, ArrayList<Residue>>();
    }

    public Molecule(Molecule other) {
        this(other, true);
    }

    public Molecule(Molecule other, boolean redoInterResBonds) {
        this();
        for (Residue residue : other.residues) {
            Residue residue2 = new Residue(residue);
            residue2.molec = this;
            this.residues.add(residue2);
        }
        for (Map.Entry entry : other.alternates.entrySet()) {
            ArrayList<Residue> val = new ArrayList<Residue>();
            for (Residue residue : (ArrayList)entry.getValue()) {
                residue = new Residue(residue);
                val.add(residue);
            }
            this.alternates.put((Integer)entry.getKey(), val);
        }
        if (redoInterResBonds) {
            this.markInterResBonds();
        }
    }

    public Residue getResByPDBResNumber(String resNum) {
        return this.residues.getOrThrow(resNum);
    }

    public Residue getResByPDBResNumberOrNull(String resNum) {
        return this.residues.getOrNull(resNum);
    }

    public List<Residue> getResRangeByPDBResNumber(String firstResNum, String lastResNum) {
        firstResNum = this.residues.getOrThrow(firstResNum).getPDBResNumber();
        lastResNum = this.residues.getOrThrow(lastResNum).getPDBResNumber();
        ArrayList<Residue> residues = new ArrayList<Residue>();
        boolean isInside = false;
        for (Residue res : this.residues) {
            String resNum = res.getPDBResNumber();
            if (resNum.equals(firstResNum)) {
                isInside = true;
            }
            if (isInside) {
                residues.add(res);
            }
            if (!resNum.equals(lastResNum)) continue;
            break;
        }
        return residues;
    }

    public List<Residue> getResiduesByPDBResNumbers(Iterable<String> resNums) {
        HashSet<String> resNumsSet = new HashSet<String>();
        for (String resNum : resNums) {
            resNumsSet.add(resNum);
        }
        return this.getResiduesByPDBResNumbers((Set<String>)resNumsSet);
    }

    public List<Residue> getResiduesByPDBResNumbers(Set<String> resNums) {
        Set normalizedResNums = resNums.stream().map(resNum -> Residues.normalizeResNum(resNum)).collect(Collectors.toSet());
        return this.residues.stream().filter(res -> normalizedResNums.contains(Residues.normalizeResNum(res.getPDBResNumber()))).collect(Collectors.toList());
    }

    public void appendResidue(Residue res) {
        res.molec = this;
        res.indexInMolecule = this.residues.size();
        this.residues.add(res);
    }

    public void addAlternate(int resIndex, Residue res) {
        if (!this.alternates.containsKey(resIndex)) {
            this.alternates.put(resIndex, new ArrayList());
        }
        res.molec = this;
        res.indexInMolecule = resIndex;
        this.alternates.get(resIndex).add(res);
    }

    public List<Residue> getAlternates(int resIndex) {
        List<Residue> residues = (List<Residue>)this.alternates.get(resIndex);
        if (residues == null) {
            residues = Collections.emptyList();
        }
        return residues;
    }

    public void deleteResidue(int resIndex) {
        this.residues.remove(resIndex);
        this.alternates.remove(resIndex);
        for (int i = resIndex; i < this.residues.size(); ++i) {
            --((Residue)this.residues.get((int)i)).indexInMolecule;
            if (!this.alternates.containsKey(i)) continue;
            for (Residue altRes : this.alternates.get(i)) {
                --altRes.indexInMolecule;
            }
        }
    }

    public void deleteResidues(Collection<String> resNames) {
        for (int i = this.residues.size() - 1; i >= 0; --i) {
            Residue res = (Residue)this.residues.get(i);
            if (!resNames.contains(res.fullName)) continue;
            this.deleteResidue(i);
        }
    }

    public ArrayList<Residue> resListFromTermini(String[] termini, ArrayList<String> flexibleRes) {
        ArrayList<Residue> resList = new ArrayList<Residue>();
        Residue curRes = this.getResByPDBResNumber(termini[0]);
        resList.add(curRes);
        String lastResNum = this.residues.getOrThrow(termini[1]).getPDBResNumber();
        while (!curRes.getPDBResNumber().equalsIgnoreCase(lastResNum)) {
            int curIndex = curRes.indexInMolecule;
            if (curIndex == this.residues.size() - 1) {
                throw new RuntimeException("ERROR: Reached end of molecule in rot/trans strand or BBFreeBlock without finding res " + termini[1]);
            }
            curRes = (Residue)this.residues.get(curRes.indexInMolecule + 1);
            String curPDBNum = curRes.getPDBResNumber();
            if (flexibleRes != null && !flexibleRes.contains(curPDBNum)) {
                throw new RuntimeException("ERROR: Res " + curPDBNum + " in rot/trans strand or BBFreeBlock but not flexible!");
            }
            resList.add(curRes);
        }
        return resList;
    }

    public int hashCode() {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        for (Residue residue : this.residues) {
            hashes.add(Arrays.hashCode(residue.coords));
        }
        return hashes.hashCode();
    }

    public Residue getResByFullName(String fullName) {
        for (Residue res : this.residues) {
            if (!res.fullName.equalsIgnoreCase(fullName)) continue;
            return res;
        }
        throw new RuntimeException("ERROR: Can't find residue with full name " + fullName);
    }

    public void markInterResBonds() {
        for (Residue res : this.residues) {
            res.template.interResBonding.connectInterResBonds(res, true);
        }
        for (Residue res : this.residues) {
            res.interResBondsMarked = true;
        }
    }
}

