/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.structure.Atom;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class AtomNeighbors {
    Atom mainAtom;
    LinkedHashSet<Atom> neighbors12;
    LinkedHashSet<Atom> neighbors13;
    LinkedHashSet<Atom> neighbors14;

    public AtomNeighbors(Atom mainAtom) {
        this.mainAtom = mainAtom;
        this.neighbors12 = new LinkedHashSet();
        this.neighbors12.addAll(mainAtom.bonds);
        this.neighbors13 = new LinkedHashSet();
        for (Atom bondedAtom : this.neighbors12) {
            for (Atom atom13 : bondedAtom.bonds) {
                if (atom13 == mainAtom || this.neighbors12.contains(atom13)) continue;
                this.neighbors13.add(atom13);
            }
        }
        this.neighbors14 = new LinkedHashSet();
        for (Atom atom13 : this.neighbors13) {
            for (Atom atom14 : atom13.bonds) {
                if (atom14 == mainAtom || this.neighbors12.contains(atom14) || this.neighbors13.contains(atom14)) continue;
                this.neighbors14.add(atom14);
            }
        }
    }

    public Type classifyAtom(Atom atom) {
        if (this.neighbors14.contains(atom)) {
            return Type.BONDED14;
        }
        if (this.neighbors13.contains(atom)) {
            return Type.BONDED13;
        }
        if (this.neighbors12.contains(atom)) {
            return Type.BONDED12;
        }
        if (atom == this.mainAtom) {
            return Type.SELF;
        }
        return Type.NONBONDED;
    }

    public static List<Atom[]> getPairs14(List<Atom> atoms1, List<Atom> atoms2, boolean internalE) {
        return AtomNeighbors.getPairsByType(atoms1, atoms2, internalE, Type.BONDED14);
    }

    public static List<Atom[]> getPairsNonBonded(List<Atom> atoms1, List<Atom> atoms2, boolean internalE) {
        return AtomNeighbors.getPairsByType(atoms1, atoms2, internalE, Type.NONBONDED);
    }

    public static List<Atom[]> getPairsByType(List<Atom> atoms1, List<Atom> atoms2, boolean internalE, Type type) {
        ArrayList<Atom[]> ans = new ArrayList<Atom[]>();
        if (internalE) {
            for (int atNum = 0; atNum < atoms1.size(); ++atNum) {
                Atom atom1 = atoms1.get(atNum);
                AtomNeighbors neighbors = new AtomNeighbors(atom1);
                for (int atNum2 = 0; atNum2 < atNum; ++atNum2) {
                    Atom atom2 = atoms1.get(atNum2);
                    if (neighbors.classifyAtom(atom2) != type) continue;
                    ans.add(new Atom[]{atom1, atom2});
                }
            }
        } else {
            for (Atom atom1 : atoms1) {
                AtomNeighbors neighbors = new AtomNeighbors(atom1);
                for (Atom atom2 : atoms2) {
                    if (neighbors.classifyAtom(atom2) != type) continue;
                    ans.add(new Atom[]{atom1, atom2});
                }
            }
        }
        return ans;
    }

    public static List<int[]> getPairIndicesByType(List<Atom> atoms1, List<Atom> atoms2, boolean internalE, Type type) {
        ArrayList<int[]> indexPairs = new ArrayList<int[]>();
        for (int i1 = 0; i1 < atoms1.size(); ++i1) {
            AtomNeighbors neighbors = new AtomNeighbors(atoms1.get(i1));
            int n = internalE ? i1 : atoms2.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (neighbors.classifyAtom(atoms2.get(i2)) != type) continue;
                indexPairs.add(new int[]{i1, i2});
            }
        }
        return indexPairs;
    }

    public static List<Atom[]> getPairsByType(List<Atom[]> atomPairs, Type type) {
        ArrayList<Atom[]> ans = new ArrayList<Atom[]>();
        for (Atom[] pair : atomPairs) {
            AtomNeighbors neighbors = new AtomNeighbors(pair[0]);
            if (neighbors.classifyAtom(pair[1]) != type) continue;
            ans.add(pair);
        }
        return ans;
    }

    public static List<Atom[]> getPairs14(List<Atom[]> atomPairs) {
        return AtomNeighbors.getPairsByType(atomPairs, Type.BONDED14);
    }

    public static List<Atom[]> getPairsNonBonded(List<Atom[]> atomPairs) {
        return AtomNeighbors.getPairsByType(atomPairs, Type.NONBONDED);
    }

    public static enum Type {
        SELF,
        BONDED12,
        BONDED13,
        BONDED14,
        NONBONDED,
        BONDED15H;

    }
}

