/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.sofea.FringeDB;
import edu.duke.cs.osprey.sofea.SeqDB;
import edu.duke.cs.osprey.sofea.Sofea;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.UnpossibleError;
import edu.duke.cs.osprey.tools.resultdoc.Plot;
import edu.duke.cs.osprey.tools.resultdoc.ResultDoc;
import java.io.File;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MinLMFE
implements Sofea.Criterion {
    public final MultiStateConfSpace.LMFE objective;
    public final int numSequences;
    public final double minFreeEnergyWidth;
    public MultiStateConfSpace.LMFE stabilityFunction = null;
    public double stabilityGap = 0.0;
    private final HashSet<StateSeq> finishedSequenced = new HashSet();
    private final HashSet<Integer> finishedUnsequenced = new HashSet();
    private final HashSet<Sequence> unstableSequences = new HashSet();

    public MinLMFE(MultiStateConfSpace.LMFE objective, int numSequences, double minFreeEnergyWidth) {
        BigInteger maxNumSequences = objective.confSpace.seqSpace.getNumSequences();
        if (BigInteger.valueOf(numSequences).compareTo(maxNumSequences) > 0) {
            throw new IllegalArgumentException(String.format("conf space only has %d sequences, can't find %d", maxNumSequences, numSequences));
        }
        this.objective = objective;
        this.numSequences = numSequences;
        this.minFreeEnergyWidth = minFreeEnergyWidth;
    }

    @Override
    public Sofea.Criterion.Filter filterNode(MultiStateConfSpace.State state, int[] conf, BoltzmannCalculator bcalc) {
        Sequence seq;
        boolean isFinished = state.isSequenced ? this.finishedSequenced.contains(new StateSeq(state, seq = state.confSpace.seqSpace().makeSequence(state.confSpace, conf))) || this.unstableSequences.contains(seq) : this.finishedUnsequenced.contains(state.unsequencedIndex);
        if (isFinished) {
            return Sofea.Criterion.Filter.Requeue;
        }
        return Sofea.Criterion.Filter.Process;
    }

    private void updateFinished(MultiStateConfSpace.State state, MathTools.DoubleBounds freeEnergyBounds) {
        double width = freeEnergyBounds.size();
        if (width <= this.minFreeEnergyWidth) {
            this.finishedUnsequenced.add(state.unsequencedIndex);
        }
    }

    private void updateFinished(MultiStateConfSpace.State state, Sequence seq, MathTools.DoubleBounds freeEnergyBounds) {
        double width = freeEnergyBounds.size();
        if (width <= this.minFreeEnergyWidth) {
            this.finishedSequenced.add(new StateSeq(state, seq));
        }
    }

    public TopSequences getTopSequences(SeqDB seqdb, MathContext mathContext) {
        return this.getTopSequences(seqdb, new BoltzmannCalculator(mathContext));
    }

    public TopSequences getTopSequences(SeqDB seqdb, BoltzmannCalculator bcalc) {
        assert (this.objective.confSpace == seqdb.confSpace);
        MultiStateConfSpace confSpace = seqdb.confSpace;
        TopSequences topSequences = new TopSequences();
        MathTools.DoubleBounds[] unsequencedFreeEnergy = new MathTools.DoubleBounds[confSpace.unsequencedStates.size()];
        for (MultiStateConfSpace.State state2 : confSpace.unsequencedStates) {
            MathTools.DoubleBounds freeEnergyBounds = bcalc.freeEnergyPrecise(seqdb.getUnsequencedZSumBounds(state2));
            this.updateFinished(state2, freeEnergyBounds);
            unsequencedFreeEnergy[state2.unsequencedIndex] = freeEnergyBounds;
        }
        MathTools.DoubleBounds wtStabilityBounds = null;
        if (this.stabilityFunction != null) {
            Sequence seq = confSpace.seqSpace.makeWildTypeSequence();
            SeqDB.SeqInfo seqInfo = seqdb.getSequencedZSumBounds(seq);
            MathTools.DoubleBounds[] stateFreeEnergies = this.objective.collectFreeEnergies(state -> {
                if (state.isSequenced) {
                    return bcalc.freeEnergyPrecise(seqInfo.zSumBounds[state.sequencedIndex]);
                }
                return unsequencedFreeEnergy[state.unsequencedIndex];
            });
            wtStabilityBounds = this.stabilityFunction.calc().addAll((MathTools.DoubleBounds[])stateFreeEnergies).bounds;
        }
        for (Map.Entry<Sequence, SeqDB.SeqInfo> entry : seqdb.getSequencedZSumBounds()) {
            MathTools.DoubleBounds objectiveBounds;
            Sequence seq = entry.getKey();
            SeqDB.SeqInfo seqInfo = entry.getValue();
            MathTools.DoubleBounds[] stateFreeEnergies = this.objective.collectFreeEnergies(state -> {
                if (state.isSequenced) {
                    return bcalc.freeEnergyPrecise(seqInfo.zSumBounds[state.sequencedIndex]);
                }
                return unsequencedFreeEnergy[state.unsequencedIndex];
            });
            for (MultiStateConfSpace.State state3 : confSpace.sequencedStates) {
                this.updateFinished(state3, seq, stateFreeEnergies[state3.index]);
            }
            if (this.stabilityFunction != null && seq.isFullyAssigned()) {
                boolean isStable;
                MathTools.DoubleBounds stabilityBounds = this.stabilityFunction.calc().addAll((MathTools.DoubleBounds[])stateFreeEnergies).bounds;
                boolean bl = isStable = stabilityBounds.lower <= wtStabilityBounds.upper + this.stabilityGap;
                if (!isStable) {
                    this.unstableSequences.add(seq);
                    continue;
                }
            }
            if (!topSequences.isTop(objectiveBounds = this.objective.calc().addAll((MathTools.DoubleBounds[])stateFreeEnergies).bounds)) continue;
            for (MultiStateConfSpace.State state4 : confSpace.states) {
                if (stateFreeEnergies[state4.index] != null) continue;
                if (state4.isSequenced) {
                    stateFreeEnergies[state4.index] = bcalc.freeEnergyPrecise(seqInfo.zSumBounds[state4.sequencedIndex]);
                    continue;
                }
                stateFreeEnergies[state4.index] = unsequencedFreeEnergy[state4.unsequencedIndex];
            }
            topSequences.add(new Sofea.SeqResult(seq, objectiveBounds, stateFreeEnergies));
        }
        return topSequences;
    }

    public List<MathTools.DoubleBounds> getUnsequencedGBounds(SeqDB seqdb, MathContext mathContext) {
        BoltzmannCalculator bcalc = new BoltzmannCalculator(mathContext);
        return this.objective.confSpace.unsequencedStates.stream().map(state -> bcalc.freeEnergyPrecise(seqdb.getUnsequencedZSumBounds((MultiStateConfSpace.State)state))).collect(Collectors.toList());
    }

    @Override
    public Sofea.Criterion.Satisfied isSatisfied(SeqDB seqdb, FringeDB fringedbLower, FringeDB fringedbUpper, long pass1Step, long pass2Step, BoltzmannCalculator bcalc) {
        boolean allFinished;
        assert (this.objective.confSpace == seqdb.confSpace);
        MultiStateConfSpace confSpace = seqdb.confSpace;
        TopSequences topSequences = this.getTopSequences(seqdb, bcalc);
        Log.log("lowest %d/%d sequences by LMFE:", topSequences.sequences.size(), this.numSequences);
        int i = 0;
        Function<Sofea.SeqResult, String> resultToString = result -> {
            StringBuilder buf = new StringBuilder();
            if (result == null) {
                buf.append("(none yet)");
            } else {
                buf.append(String.format("obj=%s w=%9.4f", result.lmfeFreeEnergy.toString(4, 9), result.lmfeFreeEnergy.size()));
                for (MultiStateConfSpace.State state : confSpace.sequencedStates) {
                    MathTools.DoubleBounds stateFreeEnergy = result.stateFreeEnergies[state.index];
                    buf.append(String.format("    %s=%s w=%.4f", state.name, stateFreeEnergy.toString(4, 9), stateFreeEnergy.size()));
                }
                buf.append(String.format("    [%s]", result.sequence));
            }
            return buf.toString();
        };
        for (Sofea.SeqResult result2 : topSequences.sequences) {
            Log.log("\tseq %6d   %s", ++i, resultToString.apply(result2));
        }
        Log.log("\tnext lowest: %s", resultToString.apply(topSequences.nextLowest));
        for (MultiStateConfSpace.State state : confSpace.unsequencedStates) {
            MathTools.DoubleBounds g = bcalc.freeEnergyPrecise(seqdb.getUnsequencedZSumBounds(state));
            Log.log("\t%s=%s w=%.4f", state.name, g.toString(4, 9), g.size());
        }
        for (Sofea.SeqResult result2 : topSequences.sequences) {
            if (!result2.sequence.isFullyAssigned()) {
                return Sofea.Criterion.Satisfied.KeepSweeping;
            }
            if (Double.isFinite(result2.lmfeFreeEnergy.lower) && Double.isFinite(result2.lmfeFreeEnergy.upper)) continue;
            return Sofea.Criterion.Satisfied.KeepSweeping;
        }
        BigInteger numTop = BigInteger.valueOf(topSequences.sequences.size());
        BigInteger numUnstable = BigInteger.valueOf(this.unstableSequences.size());
        BigInteger numSeqs = confSpace.seqSpace.getNumSequences();
        if (numTop.add(numUnstable).compareTo(numSeqs) >= 0) {
            Log.log("All sequences found, terminating", new Object[0]);
            return Sofea.Criterion.Satisfied.Terminate;
        }
        if (topSequences.nextLowest == null) {
            return Sofea.Criterion.Satisfied.KeepSweeping;
        }
        Function<Sofea.SeqResult, Boolean> seqFinished = result -> confSpace.states.stream().allMatch(state -> {
            if (state.isSequenced) {
                return this.finishedSequenced.contains(new StateSeq((MultiStateConfSpace.State)state, result.sequence));
            }
            return this.finishedUnsequenced.contains(state.unsequencedIndex);
        });
        boolean bl = allFinished = seqFinished.apply(topSequences.nextLowest) != false && topSequences.sequences.stream().allMatch(result -> (Boolean)seqFinished.apply((Sofea.SeqResult)result));
        if (allFinished) {
            Log.log("All sequences sufficiently precise, terminating", new Object[0]);
            return Sofea.Criterion.Satisfied.Terminate;
        }
        boolean allDistinct = topSequences.sequences.stream().allMatch(result -> result.lmfeFreeEnergy.upper <= topSequences.nextLowest.lmfeFreeEnergy.lower);
        if (allDistinct) {
            Log.log("Found top %d sequences, terminating", topSequences.sequences.size());
            return Sofea.Criterion.Satisfied.Terminate;
        }
        return Sofea.Criterion.Satisfied.KeepSweeping;
    }

    public void makeResultDoc(SeqDB seqdb, File file) {
        BoltzmannCalculator bcalc = new BoltzmannCalculator(seqdb.mathContext);
        TopSequences topSequences = this.getTopSequences(seqdb, bcalc);
        try (ResultDoc doc = new ResultDoc(file);){
            doc.h1("SOFEA Results");
            Plot plot = new Plot();
            plot.ylabels = new ArrayList<String>();
            Plot.IntervalsX intervalsMisc = new Plot.IntervalsX(plot);
            intervalsMisc.name = "";
            intervalsMisc.data = new ArrayList<Plot.Interval>();
            Plot.IntervalsX[] intervalsSequenced = new Plot.IntervalsX[seqdb.confSpace.sequencedStates.size()];
            for (MultiStateConfSpace.State state : seqdb.confSpace.sequencedStates) {
                intervalsSequenced[state.sequencedIndex] = new Plot.IntervalsX(plot);
                intervalsSequenced[state.sequencedIndex].name = state.name;
                intervalsSequenced[state.sequencedIndex].data = new ArrayList<Plot.Interval>();
            }
            Plot.IntervalsX intervalsObjective = new Plot.IntervalsX(plot);
            intervalsObjective.name = "objective LMFE";
            intervalsObjective.data = new ArrayList<Plot.Interval>();
            for (MultiStateConfSpace.State state : seqdb.confSpace.unsequencedStates) {
                MathTools.BigDecimalBounds z = seqdb.getUnsequencedZSumBounds(state);
                MathTools.DoubleBounds doubleBounds = bcalc.freeEnergyPrecise(z);
                plot.ylabels.add(state.name);
                intervalsMisc.data.add(new Plot.Interval(doubleBounds.lower, doubleBounds.upper));
                intervalsObjective.data.add(null);
                for (Plot.IntervalsX intervals : intervalsSequenced) {
                    intervals.data.add(null);
                }
            }
            for (Sofea.SeqResult result : topSequences.sequences) {
                plot.ylabels.add(result.sequence.toString());
                for (MultiStateConfSpace.State state : seqdb.confSpace.sequencedStates) {
                    MathTools.DoubleBounds g = result.stateFreeEnergies[state.sequencedIndex];
                    intervalsSequenced[state.sequencedIndex].data.add(new Plot.Interval(g.lower, g.upper));
                }
                intervalsObjective.data.add(new Plot.Interval(result.lmfeFreeEnergy.lower, result.lmfeFreeEnergy.upper));
                intervalsMisc.data.add(null);
            }
            plot.ylabels.add("next lowest objective LMFE");
            intervalsMisc.data.add(new Plot.Interval(topSequences.nextLowest.lmfeFreeEnergy.lower, topSequences.nextLowest.lmfeFreeEnergy.upper));
            for (Iterator<Object> iterator2 : intervalsSequenced) {
                ((Plot.Intervals)((Object)iterator2)).data.add(null);
            }
            intervalsObjective.data.add(null);
            plot.key = "on tmargin horizontal";
            plot.xlabel = "Free Energy (kcal/mol)";
            plot.xlabelrotate = 30.0;
            plot.width = 960;
            plot.height = 70 + plot.ylabels.size() * 40;
            doc.plot(plot);
            doc.println();
            doc.h2("Objective LMFE results");
            plot = new Plot();
            plot.ylabels = new ArrayList<String>();
            Plot.IntervalsX intervals = new Plot.IntervalsX(plot);
            intervals.name = "objective LMFE";
            intervals.data = new ArrayList<Plot.Interval>();
            for (Sofea.SeqResult result : topSequences.sequences) {
                plot.ylabels.add(result.sequence.toString());
                intervals.data.add(new Plot.Interval(result.lmfeFreeEnergy.lower, result.lmfeFreeEnergy.upper));
            }
            plot.ylabels.add("next lowest sequence");
            intervals.data.add(new Plot.Interval(topSequences.nextLowest.lmfeFreeEnergy.lower, topSequences.nextLowest.lmfeFreeEnergy.upper));
            plot.key = "on tmargin horizontal";
            plot.xlabel = "Free Energy (kcal/mol)";
            plot.xlabelrotate = 30.0;
            plot.width = 960;
            plot.height = 70 + plot.ylabels.size() * 40;
            doc.plot(plot);
        }
    }

    private static class StateSeq {
        final int stateIndex;
        final int[] seq;

        StateSeq(MultiStateConfSpace.State state, Sequence seq) {
            this.stateIndex = state.sequencedIndex;
            this.seq = seq.rtIndices;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(this.stateIndex + 1, Arrays.hashCode(this.seq));
        }

        public boolean equals(Object obj) {
            return obj instanceof StateSeq && this.equals((StateSeq)obj);
        }

        public boolean equals(StateSeq other) {
            return this.stateIndex == other.stateIndex && Arrays.equals(this.seq, other.seq);
        }
    }

    public class TopSequences {
        public final List<Sofea.SeqResult> sequences = new ArrayList<Sofea.SeqResult>();
        public Sofea.SeqResult nextLowest = null;

        public boolean isTop(MathTools.DoubleBounds bounds) {
            return this.nextLowest == null || bounds.upper < this.nextLowest.lmfeFreeEnergy.upper;
        }

        public void add(Sofea.SeqResult result) {
            assert (this.isTop(result.lmfeFreeEnergy));
            this.sequences.add(result);
            this.sequences.sort(Comparator.comparing(r -> r.lmfeFreeEnergy.upper));
            int numTopK = 0;
            Double lastVal = null;
            for (int i = 0; i < this.sequences.size(); ++i) {
                Sofea.SeqResult r2 = this.sequences.get(i);
                double val = r2.lmfeFreeEnergy.upper;
                if (val == Double.POSITIVE_INFINITY) {
                    this.trimAt(i);
                    break;
                }
                if (lastVal == null) {
                    ++numTopK;
                    lastVal = val;
                    continue;
                }
                if (val == lastVal) {
                    ++numTopK;
                    continue;
                }
                if (val > lastVal) {
                    if (numTopK < MinLMFE.this.numSequences) {
                        ++numTopK;
                        lastVal = val;
                        continue;
                    }
                    this.trimAt(i);
                    break;
                }
                throw new UnpossibleError();
            }
        }

        private void trimAt(int i) {
            this.nextLowest = this.sequences.get(i);
            if (this.nextLowest.lmfeFreeEnergy.upper == Double.POSITIVE_INFINITY) {
                this.nextLowest = null;
            }
            this.sequences.subList(i, this.sequences.size()).clear();
        }
    }
}

