/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.ByteBufferInputStream;
import edu.duke.cs.osprey.tools.ByteBufferOutputStream;
import edu.duke.cs.osprey.tools.IntEncoding;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;

public class FringeDB
implements AutoCloseable {
    static final byte[] Magic = new byte[]{102, 114, 105, 110, 103, 101, 100, 98};
    public final MultiStateConfSpace confSpace;
    public final File file;
    private final RandomAccessFile io;
    private final IOState iostate;
    private final IntEncoding stateEncoding;
    private final IntEncoding confEncoding;
    private final int confBytes;
    private final int entryBytes;
    private final long posIOState;
    private final long posZStats;
    private final long posEntries;
    private final long maxNumEntries;

    public static FringeDB create(MultiStateConfSpace confSpace, File file, long sizeBytes) {
        if (sizeBytes <= 0L) {
            throw new IllegalArgumentException("invalid FringeDB size: " + sizeBytes + " bytes");
        }
        try (RandomAccessFile io = new RandomAccessFile(file, "rw");){
            int i;
            io.setLength(sizeBytes);
            for (int i2 = 0; i2 < 8; ++i2) {
                io.writeByte(Magic[i2]);
            }
            io.writeInt(2);
            IntEncoding confEncoding = FringeDB.getConfEncoding(confSpace);
            int maxConfSize = confSpace.states.stream().mapToInt(state -> state.confSpace.numPos()).max().orElse(0);
            io.writeInt(confEncoding.numBytes * maxConfSize);
            io.writeLong(0L);
            io.writeLong(0L);
            io.writeLong(0L);
            io.writeLong(0L);
            for (i = 48; i < 64; ++i) {
                io.writeByte(0);
            }
            assert (io.getFilePointer() % 32L == 0L);
            for (i = 0; i < confSpace.states.size() * 2; ++i) {
                new BigExp(Double.NaN).writeTo(io);
            }
            int numBytesWritten = confSpace.states.size() * 12 * 2;
            int numBytesNeeded = MathTools.roundUpToMultiple(numBytesWritten, 32);
            for (int i3 = numBytesWritten; i3 < numBytesNeeded; ++i3) {
                io.writeByte(0);
            }
            assert (io.getFilePointer() % 32L == 0L);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("can't create new FringeDB of size %s (%d B) at %s", MathTools.formatBytes(sizeBytes), sizeBytes, file.getAbsolutePath()), ex);
        }
        return FringeDB.open(confSpace, file);
    }

    private static IntEncoding getConfEncoding(MultiStateConfSpace confSpace) {
        return IntEncoding.get(1 + confSpace.states.stream().mapToInt(state -> IntStream.range(0, state.confSpace.numPos()).map(posi -> IntStream.range(0, state.confSpace.numConf(posi)).max().orElse(0)).max().orElse(0)).max().orElse(0));
    }

    public static FringeDB open(MultiStateConfSpace confSpace, File file) {
        return new FringeDB(confSpace, file);
    }

    private FringeDB(MultiStateConfSpace confSpace, File file) {
        this.confSpace = confSpace;
        this.file = file;
        this.stateEncoding = IntEncoding.get(confSpace.states.stream().mapToInt(state -> state.index).max().orElse(0));
        this.confEncoding = FringeDB.getConfEncoding(confSpace);
        try {
            this.io = new RandomAccessFile(file, "rw");
            for (int i = 0; i < 8; ++i) {
                if (this.io.readByte() == Magic[i]) continue;
                throw new IOException("not a fringe db file");
            }
            int version = this.io.readInt();
            if (version != 2) {
                throw new IOException("unrecognized fringe db version: " + version);
            }
            this.confBytes = this.io.readInt();
            this.entryBytes = this.calcEntrySize();
            this.posIOState = this.io.getFilePointer();
            this.iostate = new IOState();
            this.iostate.readIndex = this.io.readLong();
            this.iostate.numToRead = this.io.readLong();
            this.iostate.writeIndex = this.io.readLong();
            this.iostate.numWritten = this.io.readLong();
            for (int i = 48; i < 64; ++i) {
                this.io.readByte();
            }
            assert (this.io.getFilePointer() % 32L == 0L);
            this.posZStats = this.io.getFilePointer();
            for (MultiStateConfSpace.State state2 : confSpace.states) {
                this.iostate.readZSumMax[state2.index].readFrom(this.io);
            }
            for (MultiStateConfSpace.State state2 : confSpace.states) {
                this.iostate.writeZSumMax[state2.index].readFrom(this.io);
            }
            int numBytesRead = confSpace.states.size() * 12 * 2;
            int numBytesNeeded = MathTools.roundUpToMultiple(numBytesRead, 32);
            for (int i = numBytesRead; i < numBytesNeeded; ++i) {
                this.io.readByte();
            }
            assert (this.io.getFilePointer() % 32L == 0L);
            this.posEntries = this.io.getFilePointer();
            this.maxNumEntries = (file.length() - this.posEntries) / (long)this.entryBytes;
        }
        catch (IOException ex) {
            throw new RuntimeException("can't open db file: " + file.getAbsolutePath(), ex);
        }
    }

    @Override
    public void close() {
        try {
            this.io.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int calcEntrySize() {
        return this.stateEncoding.numBytes + this.confBytes + 12;
    }

    public long getNumNodes() {
        return this.iostate.numToRead + this.iostate.numWritten;
    }

    public long getCapacity() {
        return this.maxNumEntries;
    }

    public boolean isEmpty() {
        return this.getNumNodes() <= 0L;
    }

    public long numNodesToRead() {
        return this.iostate.numToRead;
    }

    public boolean hasNodesToRead() {
        return this.iostate.numToRead > 0L;
    }

    public BigExp getZSumMax(MultiStateConfSpace.State state) {
        return this.iostate.readZSumMax[state.index];
    }

    public Transaction transaction() {
        return new Transaction();
    }

    public void finishStep() {
        if (this.iostate.numToRead > 0L) {
            throw new IllegalStateException("sweep not finished, " + this.iostate.numToRead + " nodes left to read");
        }
        try {
            this.iostate.numToRead = this.iostate.numWritten;
            this.iostate.numWritten = 0L;
            this.io.seek(this.posZStats);
            for (MultiStateConfSpace.State state : this.confSpace.states) {
                this.iostate.readZSumMax[state.index].set(this.iostate.writeZSumMax[state.index]);
                this.iostate.readZSumMax[state.index].writeTo(this.io);
            }
            for (MultiStateConfSpace.State state : this.confSpace.states) {
                this.iostate.writeZSumMax[state.index].set(Double.NaN);
                this.iostate.writeZSumMax[state.index].writeTo(this.io);
            }
            this.io.seek(this.posIOState);
            this.io.writeLong(this.iostate.readIndex);
            this.io.writeLong(this.iostate.numToRead);
            this.io.writeLong(this.iostate.writeIndex);
            this.io.writeLong(this.iostate.numWritten);
            this.io.getChannel().force(false);
        }
        catch (IOException ex) {
            throw new RuntimeException("finish failed", ex);
        }
    }

    private class IOState {
        final BigExp[] readZSumMax;
        final BigExp[] writeZSumMax;
        long readIndex;
        long numToRead;
        long writeIndex;
        long numWritten;

        IOState() {
            this.readZSumMax = new BigExp[FringeDB.this.confSpace.states.size()];
            this.writeZSumMax = new BigExp[FringeDB.this.confSpace.states.size()];
            this.readIndex = 0L;
            this.numToRead = 0L;
            this.writeIndex = 0L;
            this.numWritten = 0L;
            for (MultiStateConfSpace.State state : FringeDB.this.confSpace.states) {
                this.readZSumMax[state.index] = new BigExp(Double.NaN);
                this.writeZSumMax[state.index] = new BigExp(Double.NaN);
            }
        }

        void copyTo(IOState other) {
            System.arraycopy(this.readZSumMax, 0, other.readZSumMax, 0, FringeDB.this.confSpace.states.size());
            System.arraycopy(this.writeZSumMax, 0, other.writeZSumMax, 0, FringeDB.this.confSpace.states.size());
            other.readIndex = this.readIndex;
            other.numToRead = this.numToRead;
            other.writeIndex = this.writeIndex;
            other.numWritten = this.numWritten;
        }

        IOState copy() {
            IOState copy2 = new IOState();
            this.copyTo(copy2);
            return copy2;
        }

        void advanceRead(int count) {
            this.readIndex = this.advanceEntryIndex(this.readIndex, count);
            this.numToRead -= (long)count;
        }

        void advanceWrite(int count) {
            this.writeIndex = this.advanceEntryIndex(this.writeIndex, count);
            this.numWritten += (long)count;
        }

        long advanceEntryIndex(long index, int count) {
            return (index + (long)count) % FringeDB.this.maxNumEntries;
        }
    }

    public class Transaction {
        private final IOState iostate;
        private MultiStateConfSpace.State state;
        private int[] conf;
        private BigExp zSumUpper;
        private final ByteBuffer readBuf;
        private final DataInput readIn;
        private final int maxReadEntries;
        private final ByteBuffer writeBuf;
        private final DataOutput writeOut;
        private final int maxWrittenEntries;
        private int writtenEntries;

        private Transaction() {
            this.iostate = FringeDB.this.iostate.copy();
            this.readBuf = ByteBuffer.allocate(0x100000);
            this.readIn = new DataInputStream(new ByteBufferInputStream(this.readBuf));
            this.maxReadEntries = this.readBuf.capacity() / FringeDB.this.entryBytes;
            this.writeBuf = ByteBuffer.allocate(0x100000);
            this.writeOut = new DataOutputStream(new ByteBufferOutputStream(this.writeBuf));
            this.maxWrittenEntries = this.writeBuf.capacity() / FringeDB.this.entryBytes;
            this.writtenEntries = 0;
            this.readBuf.limit(0);
        }

        public long numNodesToRead() {
            return this.iostate.numToRead;
        }

        public boolean hasNodesToRead() {
            return this.iostate.numToRead > 0L;
        }

        public void readNode() {
            if (this.iostate.numToRead <= 0L) {
                throw new NoSuchElementException("out of fringe nodes to read");
            }
            try {
                int numBytesRead;
                if (this.readBuf.position() == this.readBuf.limit()) {
                    long numToRead = FringeDB.this.maxNumEntries - this.iostate.readIndex;
                    numToRead = Math.min(numToRead, this.iostate.numToRead);
                    numToRead = Math.min(numToRead, (long)this.maxReadEntries);
                    try {
                        int readSize = (int)(numToRead * (long)FringeDB.this.entryBytes);
                        FringeDB.this.io.seek(FringeDB.this.posEntries + this.iostate.readIndex * (long)FringeDB.this.entryBytes);
                        FringeDB.this.io.readFully(this.readBuf.array(), 0, readSize);
                        this.readBuf.position(0);
                        this.readBuf.limit(readSize);
                    }
                    catch (IOException ex) {
                        throw new IOException(String.format("can't fill read buffer.\n\tmaxReadEntries=%d\n\tiostate.numToRead=%d\n\tmaxNumToRead=%d\n\tnumToRead=%d\n\tposEntries=%d\n\tiostate.readIndex=%d\n\tentryBytes=%d\n\tseek pos=%d\n\tread len=%d\n\tend read pos=%d\n\tcapacity=%d", this.maxReadEntries, this.iostate.numToRead, FringeDB.this.maxNumEntries - this.iostate.readIndex, numToRead, FringeDB.this.posEntries, this.iostate.readIndex, FringeDB.this.entryBytes, FringeDB.this.posEntries + this.iostate.readIndex * (long)FringeDB.this.entryBytes, numToRead * (long)FringeDB.this.entryBytes, FringeDB.this.posEntries + this.iostate.readIndex * (long)FringeDB.this.entryBytes + numToRead * (long)FringeDB.this.entryBytes, FringeDB.this.io.length()), ex);
                    }
                }
                this.state = FringeDB.this.confSpace.states.get(FringeDB.this.stateEncoding.read(this.readIn));
                this.conf = new int[this.state.confSpace.numPos()];
                for (int i = 0; i < this.conf.length; ++i) {
                    this.conf[i] = FringeDB.this.confEncoding.read(this.readIn) - 1;
                }
                for (int i = numBytesRead = FringeDB.this.confEncoding.numBytes * this.conf.length; i < FringeDB.this.confBytes; ++i) {
                    this.readIn.readByte();
                }
                this.zSumUpper = BigExp.read(this.readIn);
            }
            catch (IOException ex) {
                throw new RuntimeException("can't advance to next fringe node", ex);
            }
            this.iostate.advanceRead(1);
        }

        public MultiStateConfSpace.State state() {
            return this.state;
        }

        public int[] conf() {
            return this.conf;
        }

        public BigExp zSumUpper() {
            return this.zSumUpper;
        }

        private void updateZMax(int stateIndex, BigExp val) {
            if (this.iostate.writeZSumMax[stateIndex].isNaN() || val.greaterThan(this.iostate.writeZSumMax[stateIndex])) {
                this.iostate.writeZSumMax[stateIndex].set(val);
            }
        }

        public int maxWriteBufferNodes() {
            return this.maxWrittenEntries;
        }

        public boolean txHasRoomFor(int count) {
            return this.writtenEntries + count <= this.maxWrittenEntries;
        }

        private void writeEntry(int stateIndex, int[] conf, BigExp zSumUpper, DataOutput out) {
            try {
                FringeDB.this.stateEncoding.write(out, stateIndex);
                for (int rc : conf) {
                    FringeDB.this.confEncoding.write(out, rc + 1);
                }
                int numBytesWritten = FringeDB.this.confEncoding.numBytes * conf.length;
                assert (numBytesWritten <= FringeDB.this.confBytes);
                for (int i = numBytesWritten; i < FringeDB.this.confBytes; ++i) {
                    out.writeByte(0);
                }
                zSumUpper.writeTo(out);
            }
            catch (IOException ex) {
                throw new RuntimeException("can't write fringe node", ex);
            }
        }

        public void writeRootNode(MultiStateConfSpace.State state, BigExp zSumUpper) {
            if (!this.txHasRoomFor(1)) {
                throw new IllegalStateException("transaction write buffer has no more room for nodes");
            }
            this.writeEntry(state.index, Conf.make(state.confSpace), zSumUpper, this.writeOut);
            ++this.writtenEntries;
            this.updateZMax(state.index, zSumUpper);
        }

        public void writeReplacementNode(MultiStateConfSpace.State state, int[] conf, BigExp zSumUpper) {
            if (!this.txHasRoomFor(1)) {
                throw new IllegalStateException("transaction write buffer has no more room for nodes");
            }
            this.writeEntry(state.index, conf, zSumUpper, this.writeOut);
            ++this.writtenEntries;
            this.updateZMax(state.index, zSumUpper);
        }

        public boolean dbHasRoomFor(int count) {
            long usedEntries = this.iostate.numToRead + this.iostate.numWritten + (long)this.writtenEntries;
            long freeEntries = FringeDB.this.maxNumEntries - usedEntries;
            return (long)count <= freeEntries;
        }

        public boolean dbHasRoomForCommit() {
            return this.dbHasRoomFor(0);
        }

        public void commit() {
            if (this.writtenEntries <= 0 && this.iostate.numToRead == FringeDB.this.iostate.numToRead) {
                return;
            }
            if (!this.dbHasRoomForCommit()) {
                throw new IllegalStateException("transaction too big to commit");
            }
            try {
                this.writeBuf.flip();
                long maxNumToWriteAtOnce = FringeDB.this.maxNumEntries - this.iostate.writeIndex;
                if ((long)this.writtenEntries <= maxNumToWriteAtOnce) {
                    FringeDB.this.io.seek(FringeDB.this.posEntries + this.iostate.writeIndex * (long)FringeDB.this.entryBytes);
                    FringeDB.this.io.write(this.writeBuf.array(), 0, this.writtenEntries * FringeDB.this.entryBytes);
                    this.iostate.advanceWrite(this.writtenEntries);
                } else {
                    int numWrittenPass1 = (int)maxNumToWriteAtOnce;
                    FringeDB.this.io.seek(FringeDB.this.posEntries + this.iostate.writeIndex * (long)FringeDB.this.entryBytes);
                    FringeDB.this.io.write(this.writeBuf.array(), 0, numWrittenPass1 * FringeDB.this.entryBytes);
                    this.iostate.advanceWrite(numWrittenPass1);
                    int numWrittenPass2 = this.writtenEntries - (int)maxNumToWriteAtOnce;
                    FringeDB.this.io.seek(FringeDB.this.posEntries + this.iostate.writeIndex * (long)FringeDB.this.entryBytes);
                    FringeDB.this.io.write(this.writeBuf.array(), numWrittenPass1 * FringeDB.this.entryBytes, numWrittenPass2 * FringeDB.this.entryBytes);
                    this.iostate.advanceWrite(numWrittenPass2);
                }
                this.writeBuf.clear();
                this.writtenEntries = 0;
                FringeDB.this.io.seek(FringeDB.this.posZStats + (long)(12 * FringeDB.this.confSpace.states.size()));
                for (MultiStateConfSpace.State state : FringeDB.this.confSpace.states) {
                    this.iostate.writeZSumMax[state.index].writeTo(FringeDB.this.io);
                }
                FringeDB.this.io.seek(FringeDB.this.posIOState);
                FringeDB.this.io.writeLong(this.iostate.readIndex);
                FringeDB.this.io.writeLong(this.iostate.numToRead);
                FringeDB.this.io.writeLong(this.iostate.writeIndex);
                FringeDB.this.io.writeLong(this.iostate.numWritten);
                this.iostate.copyTo(FringeDB.this.iostate);
                FringeDB.this.io.getChannel().force(false);
            }
            catch (IOException ex) {
                throw new RuntimeException("commit failed", ex);
            }
        }
    }
}

