/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.plug.LPChecks;
import edu.duke.cs.osprey.plug.VoxelVDWListChecker;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import org.apache.commons.math3.optim.linear.LinearConstraint;

public class VoxelVDWDistExplorer {
    public static void main(String[] args) {
        args = new String[]{"KStar.cfg", "System.cfg", "DEE.cfg"};
        ConfigFileParser cfp = ConfigFileParser.makeFromFilePaths(args);
        cfp.loadData();
        Molecule m = new Strand.Builder((Molecule)PDBIO.readFile((String)"1CC8.GMEC.pdb")).build().mol;
        Residue mainRes = m.getResByPDBResNumber("45");
        FreeDihedral dof1 = new FreeDihedral(mainRes, 0);
        ArrayList<Residue> bbFreeRes = new ArrayList<Residue>();
        for (int a = 43; a <= 47; ++a) {
            bbFreeRes.add(m.getResByPDBResNumber(String.valueOf(a)));
        }
        BBFreeBlock stupid = new BBFreeBlock(bbFreeRes);
        DegreeOfFreedom dof2 = stupid.getDOFs().get(3);
        ArrayList<Atom[]> interactingAtoms = new ArrayList<Atom[]>();
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG11", "47", "HG22");
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG12", "22", "HG22");
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG13", "38", "HG12");
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG21", "38", "HG12");
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG22", "22", "HG22");
        VoxelVDWDistExplorer.addAtomPair(m, interactingAtoms, "45", "HG23", "11", "HB");
        dof2 = new FreeDihedral(m.getResByPDBResNumber("38"), 0);
        VoxelVDWDistExplorer.showGridVDWBoundaries(dof1, dof2, 170.0, -69.8, 18.0, 18.0, interactingAtoms);
    }

    static void addAtomPair(Molecule m, ArrayList<Atom[]> atomList, String resName1, String atomName1, String resName2, String atomName2) {
        atomList.add(new Atom[]{m.getResByPDBResNumber(resName1).getAtomByName(atomName1), m.getResByPDBResNumber(resName2).getAtomByName(atomName2)});
    }

    public static double getVDWRadius(Atom at) {
        if (at.isHydrogen()) {
            switch (at.bonds.get((int)0).elementNumber) {
                case 7: 
                case 8: {
                    return 1.0;
                }
            }
            return 1.17;
        }
        if (at.isCarbon()) {
            if (at.bonds.size() == 3) {
                return 1.65;
            }
            return 1.75;
        }
        switch (at.elementNumber) {
            case 7: {
                return 1.55;
            }
            case 8: {
                return 1.4;
            }
            case 15: 
            case 16: {
                return 1.8;
            }
        }
        throw new RuntimeException("ERROR: Unknown VDW rad for el number: " + at.elementNumber);
    }

    static void showGridVDWBoundaries(DegreeOfFreedom dof1, DegreeOfFreedom dof2, double lb1, double lb2, double range1, double range2, ArrayList<Atom[]> interactingAtoms) {
        int gridSize = 80;
        double step1 = range1 / (double)(gridSize - 1);
        double step2 = range2 / (double)(gridSize - 1);
        int numVDWPairs = interactingAtoms.size();
        int[][][] gridVals = new int[numVDWPairs + 1][gridSize][gridSize];
        for (int g = 0; g < gridSize; ++g) {
            for (int h = 0; h < gridSize; ++h) {
                dof1.apply(lb1 + step1 * (double)g);
                dof2.apply(lb2 + step2 * (double)h);
                boolean ok = true;
                for (int p = 0; p < numVDWPairs; ++p) {
                    double targetDist;
                    Atom[] pair = interactingAtoms.get(p);
                    double dist = VectorAlgebra.distance(pair[0].getCoords(), pair[1].getCoords());
                    if (dist > (targetDist = VoxelVDWDistExplorer.getVDWRadius(pair[0]) + VoxelVDWDistExplorer.getVDWRadius(pair[1])) + 0.25) {
                        gridVals[p][g][h] = -1;
                        continue;
                    }
                    if (dist < targetDist - 0.4) {
                        ok = false;
                        gridVals[p][g][h] = 1;
                        continue;
                    }
                    gridVals[p][g][h] = 0;
                }
                gridVals[numVDWPairs][g][h] = ok ? 0 : 1;
            }
        }
        System.out.println("VDW BOUNDARIES ON GRID: ");
        for (int p = 0; p < numVDWPairs + 1; ++p) {
            if (p < numVDWPairs) {
                System.out.println("VDW PAIR " + p + ": ");
            } else {
                System.out.println("OVERALL FAVORABILITY: ");
            }
            for (int g = 0; g < gridSize; ++g) {
                for (int h = 0; h < gridSize; ++h) {
                    System.out.print(gridVals[p][g][h] + " ");
                }
                System.out.println();
            }
        }
        VoxelVDWListChecker vvlc = new VoxelVDWListChecker();
        vvlc.addDOFInterval(dof1, lb1, range1);
        vvlc.addDOFInterval(dof2, lb2, range2);
        for (Atom[] pair : interactingAtoms) {
            vvlc.addAtomPair(pair[0], pair[1]);
        }
        ArrayList<LinearConstraint> polytope = vvlc.calcFeasiblePolytope(null);
        System.out.println("LINEAR-BASED APPROX OF FEASIBLE REGION: ");
        double[] x = new double[2];
        for (int g = 0; g < gridSize; ++g) {
            for (int h = 0; h < gridSize; ++h) {
                x[0] = lb1 + step1 * (double)g;
                x[1] = lb2 + step2 * (double)h;
                boolean ok = LPChecks.isPointInPolytope(polytope, x);
                System.out.print(ok ? "0 " : "1 ");
            }
            System.out.println();
        }
    }
}

