/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.plug.LPChecks;
import edu.duke.cs.osprey.plug.RCPairVDWChecker;
import edu.duke.cs.osprey.plug.RCTuplePolytope;
import edu.duke.cs.osprey.plug.VoxConstrCache;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.Relationship;

public class PolytopeMatrix
extends TupleMatrixGeneric<RCTuplePolytope> {
    public ConfSpace cSpace;

    void writePDBFile(Molecule m, String name) {
        PDBIO.writeFile(m, name);
    }

    public PolytopeMatrix(ConfSpace confSpace) {
        super(confSpace, Double.POSITIVE_INFINITY, null);
    }

    public PolytopeMatrix(SearchProblem sp, boolean doPruning) {
        super(sp.confSpace, Double.POSITIVE_INFINITY, null);
        this.cSpace = sp.confSpace;
        int[] numRCsAtPos = this.cSpace.getNumRCsAtPos();
        System.out.println("Building PLUG matrix");
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            for (int rc = 0; rc < numRCsAtPos[pos]; ++rc) {
                RCTuple single = new RCTuple(pos, rc);
                RCPairVDWChecker rpvc = new RCPairVDWChecker(this.cSpace, single, sp.shellResidues);
                RCTuplePolytope tope = rpvc.buildPolytope();
                this.setOneBody(pos, rc, tope);
                if (doPruning && tope == null) {
                    sp.pruneMat.setOneBody(pos, rc, true);
                    System.out.println("Geometrically pruned RC " + pos + " " + rc);
                }
                for (int pos2 = 0; pos2 < pos; ++pos2) {
                    for (int rc2 = 0; rc2 < numRCsAtPos[pos2]; ++rc2) {
                        RCTuple pair = new RCTuple(pos, rc, pos2, rc2);
                        if (sp.pruneMat.getPairwise(pos, rc, pos2, rc2).booleanValue()) {
                            this.setPairwise(pos, rc, pos2, rc2, null);
                            continue;
                        }
                        RCPairVDWChecker rpvc2 = new RCPairVDWChecker(this.cSpace, pair, sp.shellResidues);
                        RCTuplePolytope tope2 = rpvc2.buildPolytope();
                        this.setPairwise(pos, rc, pos2, rc2, tope2);
                        if (!doPruning || tope2 != null) continue;
                        sp.pruneMat.setPairwise(pos, rc, pos2, rc2, true);
                        System.out.println("Geometrically pruned RC pair " + pos + " " + rc + " , " + pos2 + " " + rc2);
                    }
                }
            }
        }
    }

    public void doMultiTermPruning(PruningMatrix pruneMat, boolean doTriples) {
        int numPrunedThisRound;
        System.out.println("Doing full PLUG pruning.");
        int[] numRCsAtPos = this.cSpace.getNumRCsAtPos();
        int numPrunedDirectly = 0;
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            for (int rc = 0; rc < numRCsAtPos[pos]; ++rc) {
                if (this.isTupleFeasible(new RCTuple(pos, rc))) {
                    for (int pos2 = 0; pos2 < pos; ++pos2) {
                        for (int rc2 = 0; rc2 < numRCsAtPos[pos2]; ++rc2) {
                            RCTuple pair = new RCTuple(pos, rc, pos2, rc2);
                            if (this.isTupleFeasible(pair)) {
                                if (!doTriples) continue;
                                for (int pos3 = 0; pos3 < pos2; ++pos3) {
                                    for (int rc3 = 0; rc3 < numRCsAtPos[pos3]; ++rc3) {
                                        RCTuple triple = pair.addRC(pos3, rc3);
                                        if (this.isTupleFeasible(triple)) continue;
                                        pruneMat.setHigherOrder(triple, true);
                                        ++numPrunedDirectly;
                                    }
                                }
                                continue;
                            }
                            pruneMat.setPairwise(pos, rc, pos2, rc2, true);
                            ++numPrunedDirectly;
                        }
                    }
                    continue;
                }
                pruneMat.setOneBody(pos, rc, true);
                ++numPrunedDirectly;
            }
        }
        System.out.println(numPrunedDirectly + " RCs, pairs, and triples pruned directly");
        do {
            numPrunedThisRound = 0;
            TupleEnumerator tupEnum = new TupleEnumerator(pruneMat, null, this.cSpace.numPos);
            ArrayList<RCTuple> pruneable = tupEnum.enumerateUnprunedTuples(1);
            pruneable.addAll(tupEnum.enumerateUnprunedTuples(2));
            for (RCTuple tup : pruneable) {
                for (int pos2 = 0; pos2 < this.cSpace.numPos; ++pos2) {
                    if (tup.pos.contains(pos2)) continue;
                    boolean witnessAvailable = false;
                    for (int rc2 = 0; rc2 < numRCsAtPos[pos2]; ++rc2) {
                        if (pruneMat.isPruned(tup.addRC(pos2, rc2))) continue;
                        witnessAvailable = true;
                        break;
                    }
                    if (witnessAvailable) continue;
                    ++numPrunedThisRound;
                    pruneMat.setTupleValue(tup, true);
                }
            }
            System.out.println("Singles/pairs pruned this round because nothing compatible: " + numPrunedThisRound);
        } while (numPrunedThisRound > 0);
        System.out.println("Full PLUG pruning complete");
    }

    public LinearMultivariateRealFunction[] getJoptPolytope(RCTuple conf, ArrayList<DegreeOfFreedom> DOFs, double ineqTol) {
        double redundancyTol = 1.0E-6;
        ArrayList<LinearConstraint> constrList = this.getFullStericPolytope(conf, DOFs);
        ArrayList<LinearMultivariateRealFunction> ajlnv = new ArrayList<LinearMultivariateRealFunction>();
        for (LinearConstraint c : constrList) {
            LinearMultivariateRealFunction f = LPChecks.toLinearMultivariateRealFunction(c, ineqTol);
            boolean redundant = false;
            for (LinearMultivariateRealFunction g : ajlnv) {
                if (!(Math.abs(f.getR() - g.getR()) < 1.0E-6) || !(Algebra.DEFAULT.norm2(f.getQ().copy().assign(g.getQ(), Functions.minus)) < 1.0E-12)) continue;
                redundant = true;
                break;
            }
            if (redundant) continue;
            ajlnv.add(f);
        }
        LinearMultivariateRealFunction[] constr = ajlnv.toArray(new LinearMultivariateRealFunction[ajlnv.size()]);
        return constr;
    }

    public ArrayList<LinearConstraint> getFullStericPolytope(RCTuple conf, ArrayList<DegreeOfFreedom> DOFs) {
        ArrayList<LinearConstraint> ans = new ArrayList<LinearConstraint>();
        VoxConstrCache constrCache = new VoxConstrCache();
        for (int count = 0; count < conf.size(); ++count) {
            RCTuplePolytope singlePolytope = (RCTuplePolytope)this.getOneBody(conf.pos.get(count), conf.RCs.get(count));
            if (singlePolytope == null) {
                return null;
            }
            for (LinearConstraint constr : singlePolytope.expandConstraints(DOFs)) {
                if (constrCache.checkRedundancy(constr)) continue;
                ans.add(constr);
            }
            for (int count2 = 0; count2 < count; ++count2) {
                RCTuplePolytope pairPolytope = (RCTuplePolytope)this.getPairwise(conf.pos.get(count), conf.RCs.get(count), conf.pos.get(count2), conf.RCs.get(count2));
                if (pairPolytope == null) {
                    return null;
                }
                for (LinearConstraint constr : pairPolytope.expandConstraints(DOFs)) {
                    if (constrCache.checkRedundancy(constr)) continue;
                    ans.add(constr);
                }
            }
        }
        return ans;
    }

    public ArrayList<LinearConstraint> getFullPolytope(RCTuple conf) {
        LinkedHashMap<DegreeOfFreedom, double[]> DOFBounds = this.calcDOFBounds(conf);
        ArrayList<DegreeOfFreedom> DOFs = new ArrayList<DegreeOfFreedom>(DOFBounds.keySet());
        ArrayList<LinearConstraint> polytope = this.getFullStericPolytope(conf, DOFs);
        if (polytope == null) {
            return null;
        }
        int dof = 0;
        for (DegreeOfFreedom curDOF : DOFs) {
            double[] unitVec = new double[DOFBounds.size()];
            unitVec[dof] = 1.0;
            double[] bounds = DOFBounds.get(curDOF);
            polytope.add(new LinearConstraint(unitVec, Relationship.GEQ, bounds[0]));
            polytope.add(new LinearConstraint(unitVec, Relationship.LEQ, bounds[1]));
            ++dof;
        }
        return polytope;
    }

    LinkedHashMap<DegreeOfFreedom, double[]> calcDOFBounds(RCTuple conf) {
        LinkedHashMap<DegreeOfFreedom, double[]> DOFBounds = new LinkedHashMap<DegreeOfFreedom, double[]>();
        for (int posCount = 0; posCount < conf.pos.size(); ++posCount) {
            RC curRC = this.cSpace.posFlex.get((int)conf.pos.get((int)posCount).intValue()).RCs.get(conf.RCs.get(posCount));
            for (int dofCount = 0; dofCount < curRC.DOFs.size(); ++dofCount) {
                DegreeOfFreedom curDOF = curRC.DOFs.get(dofCount);
                double lb = curRC.DOFmin.get(dofCount);
                double ub = curRC.DOFmax.get(dofCount);
                if (DOFBounds.containsKey(curDOF)) {
                    double[] curBounds = DOFBounds.get(curDOF);
                    curBounds[0] = Math.max(lb, curBounds[0]);
                    curBounds[1] = Math.min(ub, curBounds[1]);
                    continue;
                }
                DOFBounds.put(curDOF, new double[]{lb, ub});
            }
        }
        return DOFBounds;
    }

    public boolean isTupleFeasible(RCTuple conf) {
        ArrayList<LinearConstraint> polytope = this.getFullPolytope(conf);
        if (polytope == null) {
            return false;
        }
        return LPChecks.polytopeHasFeasiblePt(polytope);
    }

    public boolean isPointFeasible(int[] conf, DoubleMatrix1D pt, ArrayList<DegreeOfFreedom> dofs) {
        HashMap<DegreeOfFreedom, Double> DOFValMapping = new HashMap<DegreeOfFreedom, Double>();
        if (pt.size() != dofs.size()) {
            throw new RuntimeException("ERROR wrong number of DOFs");
        }
        for (int dof = 0; dof < pt.size(); ++dof) {
            DOFValMapping.put(dofs.get(dof), pt.get(dof));
        }
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            RCTuplePolytope tope = (RCTuplePolytope)this.getOneBody(pos, conf[pos]);
            if (!tope.containsPoint(this.ptForDOFs(DOFValMapping, tope.DOFs))) {
                return false;
            }
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                RCTuplePolytope tope2 = (RCTuplePolytope)this.getPairwise(pos, conf[pos], pos2, conf[pos2]);
                if (tope2.containsPoint(this.ptForDOFs(DOFValMapping, tope2.DOFs))) continue;
                return false;
            }
        }
        return true;
    }

    private double[] ptForDOFs(HashMap<DegreeOfFreedom, Double> DOFValMapping, ArrayList<DegreeOfFreedom> dofList) {
        double[] ans = new double[dofList.size()];
        for (int dof = 0; dof < dofList.size(); ++dof) {
            if (DOFValMapping.containsKey(dofList.get(dof))) {
                ans[dof] = DOFValMapping.get(dofList.get(dof));
                continue;
            }
            System.out.println("DOF UNRECOGNIZED;");
        }
        return ans;
    }

    public void listClashes(int[] conf, DoubleMatrix1D pt, ArrayList<DegreeOfFreedom> dofs) {
        HashMap<DegreeOfFreedom, Double> DOFValMapping = new HashMap<DegreeOfFreedom, Double>();
        if (pt.size() != dofs.size()) {
            throw new RuntimeException("ERROR wrong number of DOFs");
        }
        for (int dof = 0; dof < pt.size(); ++dof) {
            DOFValMapping.put(dofs.get(dof), pt.get(dof));
        }
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            RCTuplePolytope tope = (RCTuplePolytope)this.getOneBody(pos, conf[pos]);
            if (tope != null) {
                tope.listClashes(this.ptForDOFs(DOFValMapping, tope.DOFs));
            }
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                RCTuplePolytope tope2 = (RCTuplePolytope)this.getPairwise(pos, conf[pos], pos2, conf[pos2]);
                if (tope2 == null) continue;
                tope2.listClashes(this.ptForDOFs(DOFValMapping, tope2.DOFs));
            }
        }
    }
}

