/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.ProbeAtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Iterator;

public class ISAtomsIterable
implements Iterable<Atom> {
    ProbeAtomNeighbors neighbors;
    Residue res1;
    ArrayList<Residue> shellResidues;

    public ISAtomsIterable(Atom at1, Residue res1, ArrayList<Residue> shellResidues) {
        this.neighbors = new ProbeAtomNeighbors(at1);
        this.res1 = res1;
        this.shellResidues = shellResidues;
    }

    @Override
    public Iterator<Atom> iterator() {
        return new ISAtomsIterator();
    }

    private class ISAtomsIterator
    implements Iterator<Atom> {
        int resCounter = -1;
        int atomCounter = -1;
        boolean done = false;

        private ISAtomsIterator() {
            this.updateCounters();
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Atom next() {
            Residue nextRes = this.resCounter == -1 ? ISAtomsIterable.this.res1 : ISAtomsIterable.this.shellResidues.get(this.resCounter);
            Atom nextAtom = nextRes.atoms.get(this.atomCounter);
            this.updateCounters();
            return nextAtom;
        }

        private void updateCounters() {
            Atom candAtom;
            Residue nextRes = this.resCounter == -1 ? ISAtomsIterable.this.res1 : ISAtomsIterable.this.shellResidues.get(this.resCounter);
            do {
                ++this.atomCounter;
                if (this.atomCounter != nextRes.atoms.size()) continue;
                ++this.resCounter;
                this.atomCounter = 0;
                if (this.resCounter == ISAtomsIterable.this.shellResidues.size()) {
                    this.done = true;
                    break;
                }
                nextRes = ISAtomsIterable.this.shellResidues.get(this.resCounter);
            } while (ISAtomsIterable.this.neighbors.classifyAtom(candAtom = nextRes.atoms.get(this.atomCounter)) != AtomNeighbors.Type.NONBONDED);
        }
    }
}

