/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.paste;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import edu.duke.cs.osprey.paste.PasteGradientDescentPfunc;
import edu.duke.cs.osprey.paste.PastePartitionFunction;
import edu.duke.cs.osprey.paste.PasteScore;
import edu.duke.cs.osprey.paste.PasteScoreWriter;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Paste {
    public final ConfSpaceInfo protein;
    public final Settings settings;
    private final int numPDBs;
    private List<Sequence> sequences;

    public Paste(SimpleConfSpace protein, Settings settings, int numPDBs) {
        this.settings = settings;
        this.protein = new ConfSpaceInfo(protein, ConfSpaceType.Protein);
        this.sequences = new ArrayList<Sequence>();
        this.numPDBs = numPDBs;
    }

    public Iterable<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein);
    }

    public void run() {
        this.protein.check();
        this.sequences.clear();
        ArrayList scores = new ArrayList();
        this.sequences.add(this.protein.confSpace.seqSpace.makeWildTypeSequence());
        if (this.settings.mutFile == null) {
            this.sequences.addAll(this.protein.confSpace.seqSpace.getMutants(this.settings.maxSimultaneousMutations, true));
        } else {
            this.sequences.addAll(this.protein.confSpace.seqSpace.getMutants(this.settings.mutFile));
        }
        int n = this.sequences.size();
        Scorer scorer = (sequenceNumber, complexResult, wtResult) -> {
            String seqDir;
            File directory;
            PasteScore pasteScore = sequenceNumber == 0 ? null : new PasteScore(complexResult, wtResult);
            Sequence sequence = this.sequences.get(sequenceNumber);
            this.settings.scoreWriters.writeScore(new PasteScoreWriter.ScoreInfo(sequenceNumber, n, sequence, pasteScore));
            ConfAnalyzer analyzer = new ConfAnalyzer(this.protein.confEcalc);
            ConfAnalyzer.EnsembleAnalysis analysis = analyzer.analyzeEnsemble(complexResult.sConfs, complexResult.epMols.iterator(), this.numPDBs);
            String pdbString = "pdbs";
            File pdbDir = new File(pdbString);
            if (!pdbDir.exists()) {
                pdbDir.mkdir();
            }
            if (!(directory = new File(pdbString + "/" + (seqDir = this.sequences.get(sequenceNumber).toString().replaceAll(" ", "_")))).exists()) {
                directory.mkdir();
            }
            analysis.writePdbs(pdbString + "/" + seqDir + "/conf.*.pdb");
            return pasteScore;
        };
        System.out.println("computing PAStE scores for " + (this.sequences.size() - 1) + " sequence(s) to epsilon = " + this.settings.epsilon + " ...");
        this.settings.scoreWriters.writeHeader();
        PastePartitionFunction.Result wtResult2 = this.protein.calcPfunc(0, BigDecimal.ZERO, null);
        wtResult2.clearSomeResults();
        for (int i = 1; i < n; ++i) {
            PastePartitionFunction.Result proteinResult = this.protein.calcPfunc(i, null, wtResult2);
            scorer.score(i, proteinResult, wtResult2);
            proteinResult.clearSomeResults();
        }
    }

    public static class Settings {
        public final File mutFile;
        public final double epsilon;
        public final Double stabilityThreshold;
        public final int maxSimultaneousMutations;
        public final PasteScoreWriter.Writers scoreWriters;
        public final boolean showPfuncProgress;
        public final boolean useExternalMemory;
        public final double eW;
        public final int maxNumPfConfs;
        public final boolean useWindowCriterion;

        public Settings(double epsilon, double eW, int maxNumPfConfs, Double stabilityThreshold, int maxSimultaneousMutations, PasteScoreWriter.Writers scoreWriters, boolean dumpPfuncConfs, boolean useExternalMemory, boolean useWindowCriterion, File mutFile) {
            this.eW = eW;
            this.maxNumPfConfs = maxNumPfConfs;
            this.epsilon = epsilon;
            this.stabilityThreshold = stabilityThreshold;
            this.maxSimultaneousMutations = maxSimultaneousMutations;
            this.scoreWriters = scoreWriters;
            this.showPfuncProgress = dumpPfuncConfs;
            this.useExternalMemory = useExternalMemory;
            this.useWindowCriterion = useWindowCriterion;
            this.mutFile = mutFile;
        }

        public static class Builder {
            private double epsilon = 0.683;
            private double eW = 10.0;
            private int maxNumPfConfs = 5000;
            private boolean useWindowCriterion = true;
            private File mutFile = null;
            private Double stabilityThreshold = null;
            private int maxSimultaneousMutations = 1;
            private PasteScoreWriter.Writers scoreWriters = new PasteScoreWriter.Writers();
            private boolean showPfuncProgress = false;
            private boolean useExternalMemory = false;

            public Builder setPfConfs(int val) {
                this.maxNumPfConfs = val;
                return this;
            }

            public Builder setUseWindowCriterion(boolean val) {
                this.useWindowCriterion = val;
                return this;
            }

            public Builder setEnergy(double val) {
                this.eW = val;
                return this;
            }

            public Builder setNumMaxPfConfs(int val) {
                this.maxNumPfConfs = val;
                return this;
            }

            public Builder setEpsilon(double val) {
                this.epsilon = val;
                return this;
            }

            public Builder setStabilityThreshold(Double val) {
                if (val != null && val.isInfinite()) {
                    throw new IllegalArgumentException("only finite values allowed. To turn off the filter, pass null");
                }
                this.stabilityThreshold = val;
                return this;
            }

            public Builder setMaxSimultaneousMutations(int val) {
                this.maxSimultaneousMutations = val;
                return this;
            }

            public Builder addScoreWriter(PasteScoreWriter val) {
                this.scoreWriters.add(val);
                return this;
            }

            public Builder addScoreConsoleWriter(PasteScoreWriter.Formatter val) {
                return this.addScoreWriter(new PasteScoreWriter.ToConsole(val));
            }

            public Builder addScoreConsoleWriter() {
                return this.addScoreConsoleWriter(new PasteScoreWriter.Formatter.SequenceKStarPfuncs());
            }

            public Builder addScoreFileWriter(File file, PasteScoreWriter.Formatter val) {
                return this.addScoreWriter(new PasteScoreWriter.ToFile(file, val));
            }

            public Builder addScoreFileWriter(File file) {
                return this.addScoreFileWriter(file, new PasteScoreWriter.Formatter.Log());
            }

            public Builder addMutFile(File file) {
                this.mutFile = file;
                return this;
            }

            public Builder setShowPfuncProgress(boolean val) {
                this.showPfuncProgress = val;
                return this;
            }

            public Builder setExternalMemory(boolean val) {
                this.useExternalMemory = val;
                return this;
            }

            public Settings build() {
                return new Settings(this.epsilon, this.eW, this.maxNumPfConfs, this.stabilityThreshold, this.maxSimultaneousMutations, this.scoreWriters, this.showPfuncProgress, this.useExternalMemory, this.useWindowCriterion, this.mutFile);
            }
        }
    }

    public class ConfSpaceInfo {
        public final SimpleConfSpace confSpace;
        public final ConfSpaceType type;
        public final String id;
        public ConfEnergyCalculator confEcalc = null;
        public ConfSearchFactory confSearchFactory = null;
        public File confDBFile = null;

        public ConfSpaceInfo(SimpleConfSpace confSpace, ConfSpaceType type) {
            this.confSpace = confSpace;
            this.type = type;
            this.id = type.name().toLowerCase();
        }

        private void check() {
            if (this.confEcalc == null) {
                throw new InitException(this.type, "confEcalc");
            }
            if (this.confSearchFactory == null) {
                throw new InitException(this.type, "confSearchFactory");
            }
        }

        public PastePartitionFunction.Result calcPfunc(int sequenceIndex, BigDecimal stabilityThreshold, PastePartitionFunction.Result wtResult) {
            Sequence sequence = Paste.this.sequences.get(sequenceIndex).filter(this.confSpace.seqSpace);
            PasteGradientDescentPfunc pfunc = new PasteGradientDescentPfunc(this.confEcalc);
            pfunc.setReportProgress(Paste.this.settings.showPfuncProgress);
            RCs rcs = sequence.makeRCs(this.confSpace);
            if (Paste.this.settings.useExternalMemory) {
                PastePartitionFunction.WithExternalMemory.setOrThrow(pfunc, true, rcs);
            }
            ConfSearch astar = this.confSearchFactory.make(rcs);
            ConfSearch astar2 = this.confSearchFactory.make(rcs);
            pfunc.init(astar, astar2, rcs.getNumConformations(), Paste.this.settings.epsilon, Paste.this.settings.eW, wtResult, Paste.this.settings.useWindowCriterion);
            pfunc.setStabilityThreshold(stabilityThreshold);
            pfunc.compute(Paste.this.settings.maxNumPfConfs, Paste.this.numPDBs);
            PastePartitionFunction.Result result = pfunc.makeResult();
            Runtime.getRuntime().gc();
            return result;
        }

        public void setConfDBFile(String path2) {
            this.confDBFile = new File(path2);
        }
    }

    public static enum ConfSpaceType {
        Protein,
        Ligand,
        Complex;

    }

    private static interface Scorer {
        public PasteScore score(int var1, PastePartitionFunction.Result var2, PastePartitionFunction.Result var3);
    }

    public static interface ConfSearchFactory {
        public ConfSearch make(RCs var1);
    }

    public static class InitException
    extends RuntimeException {
        public InitException(ConfSpaceType type, String name) {
            super(String.format("set %s for the %s conf space info before running", name, type.name()));
        }
    }

    public static class ScoredSequence {
        public final Sequence sequence;
        public final PasteScore score;

        public ScoredSequence(Sequence sequence, PasteScore score) {
            this.sequence = sequence;
            this.score = score;
        }

        public String toString() {
            return "sequence: " + String.valueOf(this.sequence) + "   K*(log10): " + String.valueOf(this.score);
        }

        public String toString(Sequence wildtype) {
            return "sequence: " + this.sequence.toString(Sequence.Renderer.AssignmentMutations) + "   K*(log10): " + String.valueOf(this.score);
        }
    }
}

