/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr.pickers;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.partcr.pickers.ConfPicker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WalkingConfPicker
implements ConfPicker {
    private int numItersPerConf;
    private Map<List<Integer>, Integer> pickedConfs;

    public WalkingConfPicker() {
        this(1);
    }

    public WalkingConfPicker(int numItersPerConf) {
        this.numItersPerConf = numItersPerConf;
        this.pickedConfs = new HashMap<List<Integer>, Integer>();
    }

    @Override
    public ConfSearch.ScoredConf pick(List<ConfSearch.ScoredConf> confs) {
        for (ConfSearch.ScoredConf conf : confs) {
            List confList = Arrays.stream(conf.getAssignments()).boxed().collect(Collectors.toList());
            Integer numIters = this.pickedConfs.get(confList);
            if (numIters == null) {
                this.pickedConfs.put(confList, 1);
                return conf;
            }
            if (numIters >= this.numItersPerConf) continue;
            this.pickedConfs.put(confList, numIters + 1);
            return conf;
        }
        this.pickedConfs.clear();
        return this.pick(confs);
    }
}

