/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.parallelism.Signal;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.util.List;

public abstract class TimingThread
extends Thread {
    public Signal warmupSignal;
    public Signal goSignal;
    public Signal doneSignal;

    public TimingThread(String name) {
        super(name);
        this.setDaemon(true);
        this.warmupSignal = new Signal();
        this.goSignal = new Signal();
        this.doneSignal = new Signal();
    }

    protected void init() throws Exception {
    }

    protected abstract void warmup();

    protected abstract void time();

    protected void cleanup() {
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        this.warmup();
        this.warmupSignal.sendSignal();
        this.goSignal.waitForSignal();
        this.time();
        this.doneSignal.sendSignal();
        this.cleanup();
    }

    public void waitForFinish() {
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    public static Stopwatch timeThreads(List<TimingThread> threads) {
        for (TimingThread thread2 : threads) {
            thread2.start();
        }
        for (TimingThread thread2 : threads) {
            thread2.warmupSignal.waitForSignal();
        }
        Stopwatch stopwatch = new Stopwatch().start();
        for (TimingThread thread3 : threads) {
            thread3.goSignal.sendSignal();
        }
        for (TimingThread thread3 : threads) {
            thread3.doneSignal.waitForSignal();
        }
        stopwatch.stop();
        for (TimingThread thread3 : threads) {
            thread3.waitForFinish();
        }
        return stopwatch;
    }
}

