/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import java.util.concurrent.ForkJoinPool;

public class ThreadParallelism {
    private static int NUM_THREADS = 1;

    public static void setNumThreads(int threads) {
        boolean itWorked = ThreadParallelism.setNumThreadsIfPossible(threads);
        assert (itWorked) : String.format("tried to set fork join pool to %d threads, but it has %d instead", NUM_THREADS, ForkJoinPool.commonPool().getParallelism());
    }

    public static boolean setNumThreadsIfPossible(int numThreads) {
        boolean itWorked;
        if (numThreads == NUM_THREADS) {
            return true;
        }
        if (numThreads < 1) {
            numThreads = 1;
        } else if (numThreads >= Runtime.getRuntime().availableProcessors()) {
            numThreads = Runtime.getRuntime().availableProcessors();
        }
        ThreadParallelism.setForkJoinPoolConstructorArg(numThreads);
        boolean bl = itWorked = ForkJoinPool.commonPool().getParallelism() == numThreads;
        if (itWorked) {
            NUM_THREADS = numThreads;
        }
        return itWorked;
    }

    public static int getNumThreads() {
        return NUM_THREADS;
    }

    public static void setDefaultNumThreads() {
        ThreadParallelism.setNumThreads(NUM_THREADS);
    }

    private static void setForkJoinPoolConstructorArg(int numThreads) {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(numThreads));
    }

    static {
        ThreadParallelism.setForkJoinPoolConstructorArg(NUM_THREADS);
    }
}

