/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import java.util.concurrent.TimeUnit;

public class RateLimitedThread
implements AutoCloseable {
    public final String name;
    public final long interval;
    public final TimeUnit unit;
    public final Runnable task;
    private final Thread thread;
    private volatile boolean isRunning;
    private volatile boolean isRequested;

    public RateLimitedThread(String name, long interval, TimeUnit unit, Runnable task) {
        this.name = name;
        this.interval = interval;
        this.unit = unit;
        this.task = task;
        this.isRunning = true;
        this.isRequested = false;
        this.thread = new Thread(() -> this.threadLoop());
        this.thread.setName(name);
        this.thread.setDaemon(false);
        this.thread.start();
    }

    @Override
    public void close() {
        this.isRunning = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void request() {
        this.isRequested = true;
    }

    private void threadLoop() {
        long millis = this.unit.toMillis(this.interval);
        try {
            while (this.isRunning) {
                if (this.isRequested) {
                    this.task.run();
                    this.isRequested = false;
                }
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

